/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.test;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.ejb.TransactionAttributeType;
import org.eclipse.jst.j2ee.ejb.test.EjbEMFTestBase;

public class MethodTransactionTest
extends EjbEMFTestBase {
    public MethodTransactionTest(String name) {
        super(name);
    }

    public void test_MethodTransaction() {
        MethodTransaction tmpMethodTransaction = EjbFactory.eINSTANCE.createMethodTransaction();
        MethodTransactionTest.assertNotNull((Object)tmpMethodTransaction);
    }

    public void test_getMethodElements() throws Exception {
        this.init();
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        AssemblyDescriptor assemblyDescriptor = DD.getEJBJar().getAssemblyDescriptor();
        MethodTransactionTest.assertNotNull((Object)assemblyDescriptor);
        EList enterpriseBeans = DD.getEJBJar().getEnterpriseBeans();
        EnterpriseBean eb1 = (EnterpriseBean)enterpriseBeans.get(0);
        MethodTransaction methodTransaction = this.getEjbFactory().createMethodTransaction();
        EList methodTransactions = assemblyDescriptor.getMethodTransactions();
        methodTransactions.add(methodTransaction);
        MethodElement methodElement = this.getEjbFactory().createMethodElement();
        methodElement.setEnterpriseBean(eb1);
        methodTransaction.getMethodElements().add((Object)methodElement);
        List methodElements = methodTransaction.getMethodElements(eb1);
        MethodTransactionTest.assertEquals((boolean)methodElements.contains(methodElement), (boolean)true);
    }

    public void test_isEquivalent() {
        MethodTransaction objMethodTransaction1 = this.getEjbFactory().createMethodTransaction();
        MethodTransaction objMethodTransaction2 = this.getEjbFactory().createMethodTransaction();
        objMethodTransaction1.setTransactionAttribute(TransactionAttributeType.SUPPORTS_LITERAL);
        objMethodTransaction2.setTransactionAttribute(TransactionAttributeType.SUPPORTS_LITERAL);
        boolean retValue = objMethodTransaction1.isEquivalent(objMethodTransaction2);
        MethodTransactionTest.assertEquals((boolean)retValue, (boolean)true);
        objMethodTransaction2.setTransactionAttribute(TransactionAttributeType.REQUIRED_LITERAL);
        retValue = objMethodTransaction1.isEquivalent(objMethodTransaction2);
        MethodTransactionTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new MethodTransactionTest("test_isEquivalent"));
        suite.addTest((Test)new MethodTransactionTest("test_getMethodElements"));
        return suite;
    }
}

