/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operation.extensionui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.MasterDescriptor;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.SlaveDescriptor;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtensionRegistry;

public class UIOperationExtensionRegistry
extends RegistryReader {
    public static final UIOperationExtensionRegistry INSTANCE = new UIOperationExtensionRegistry();
    public static final String EXTENSION_POINT = "wtpuiAction";
    private Map slaveDescriptorMap;
    private Map masterDescriptorMap;
    private HashMap overriddingDescriptorMap;

    static {
        INSTANCE.readRegistry();
    }

    protected UIOperationExtensionRegistry() {
        super("org.eclipse.wst.common.frameworks.ui", EXTENSION_POINT);
    }

    public MasterDescriptor[] getExtendedUIOperations(String extendedOperationId, IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return new MasterDescriptor[0];
        }
        ArrayList<MasterDescriptor> enabledExtendedOperations = new ArrayList<MasterDescriptor>();
        List descs = this.getMasterDescriptorsById(extendedOperationId);
        MasterDescriptor descriptor = null;
        Iterator itr = descs.iterator();
        while (itr.hasNext()) {
            descriptor = (MasterDescriptor)itr.next();
            if (!descriptor.isEnabledFor(selection) || this.isOverridden(descriptor, selection)) continue;
            enabledExtendedOperations.add(descriptor);
        }
        if (enabledExtendedOperations.size() == 0) {
            return new MasterDescriptor[0];
        }
        MasterDescriptor[] enabledExtendedOperationsArray = new MasterDescriptor[enabledExtendedOperations.size()];
        enabledExtendedOperations.toArray(enabledExtendedOperationsArray);
        return enabledExtendedOperationsArray;
    }

    protected boolean isOverridden(MasterDescriptor descriptor, IStructuredSelection selection) {
        MasterDescriptor overriddingDescriptor = this.getOverriddingDescriptor(descriptor);
        if (overriddingDescriptor == null) {
            return false;
        }
        return overriddingDescriptor.isEnabledFor(selection);
    }

    protected MasterDescriptor getOverriddingDescriptor(MasterDescriptor descriptor) {
        return (MasterDescriptor)this.getOverriddingDescriptorMap().get(descriptor.getId());
    }

    protected Map getOverriddingDescriptorMap() {
        if (this.overriddingDescriptorMap == null) {
            this.overriddingDescriptorMap = new HashMap();
        }
        return this.overriddingDescriptorMap;
    }

    public SlaveDescriptor[] getSlaveDescriptors(String parentOperationClass) {
        String[] slaves = OperationExtensionRegistry.getRegisteredOperations((String)parentOperationClass);
        ArrayList<SlaveDescriptor> slaveDescriptors = new ArrayList<SlaveDescriptor>();
        SlaveDescriptor slaveDescriptor = null;
        int i = 0;
        while (slaves != null && i < slaves.length) {
            slaveDescriptor = this.getSlaveDescriptor(slaves[i]);
            if (slaveDescriptor != null) {
                slaveDescriptors.add(slaveDescriptor);
            }
            ++i;
        }
        SlaveDescriptor[] slaveDescriptorsArray = new SlaveDescriptor[slaveDescriptors.size()];
        slaveDescriptors.toArray(slaveDescriptorsArray);
        return slaveDescriptorsArray;
    }

    public SlaveDescriptor getSlaveDescriptor(String operationClass) {
        return (SlaveDescriptor)this.getSlaveDescriptorMap().get(operationClass);
    }

    public boolean readElement(IConfigurationElement element) {
        if ("masterOperation".equals(element.getName())) {
            MasterDescriptor md = new MasterDescriptor(element);
            this.addDescriptor(md);
            if (md.getOverrideId() != null && md.getOverrideId().length() > 0) {
                this.getOverriddingDescriptorMap().put(md.getOverrideId(), md);
            }
        } else if ("slaveOperation".equals(element.getName())) {
            this.addDescriptor(new SlaveDescriptor(element));
        } else {
            return false;
        }
        return true;
    }

    protected void addDescriptor(MasterDescriptor descriptor) {
        this.getMasterDescriptorsById(descriptor.getExtendedOperationId()).add(descriptor);
    }

    protected void addDescriptor(SlaveDescriptor descriptor) {
        this.getSlaveDescriptorMap().put(descriptor.getOperationClass(), descriptor);
    }

    protected List getMasterDescriptorsById(String extendedOperationId) {
        ArrayList descs = (ArrayList)this.getMasterDescriptorMap().get(extendedOperationId);
        if (descs == null) {
            descs = new ArrayList();
            this.getMasterDescriptorMap().put(extendedOperationId, descs);
        }
        return descs;
    }

    protected Map getMasterDescriptorMap() {
        if (this.masterDescriptorMap == null) {
            this.masterDescriptorMap = new HashMap();
        }
        return this.masterDescriptorMap;
    }

    protected Map getSlaveDescriptorMap() {
        if (this.slaveDescriptorMap == null) {
            this.slaveDescriptorMap = new HashMap();
        }
        return this.slaveDescriptorMap;
    }
}

