/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.parser;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import junit.framework.TestCase;
import org.eclipse.wst.html.core.tests.parser.NullInputStream;
import org.eclipse.wst.html.core.tests.utils.DateUtil;
import org.eclipse.wst.html.core.tests.utils.FileUtil;
import org.eclipse.wst.html.core.tests.utils.StringCompareUtil;
import org.eclipse.wst.html.core.tests.utils.TestWriter;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.util.StringUtils;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionChecker;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public abstract class ModelTest
extends TestCase {
    public static final String testResultsDirectoryPrefix = "ParserResults";
    private static final String fileExtension = ".txt";
    protected TestWriter fOutputWriter = new TestWriter();
    private int READ_BUFFER_SIZE = 4096;
    private boolean echoToSystemOut = false;
    private boolean printedOnce;
    private boolean printSummaryToSystemOut;

    public ModelTest(String name) {
        super(name);
        try {
            this.printClass();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ModelTest() {
        this("dummy");
    }

    public static IDOMModel createHTMLModel() {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            model = modelManager.getModelForEdit("test.html", (InputStream)new NullInputStream(), null);
            model.getStructuredDocument().setLineDelimiter("\r\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (IDOMModel)model;
    }

    public static IDOMModel createXMLModel() {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            model = modelManager.getModelForEdit("test.xml", (InputStream)new NullInputStream(), null);
            model.getStructuredDocument().setLineDelimiter("\r\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (IDOMModel)model;
    }

    private void printClass() throws IOException {
        this.fOutputWriter.writeln(((Object)((Object)this)).getClass().getName());
    }

    public static void printException(Exception ex) {
        ex.printStackTrace();
    }

    private void printNode(Node node, int indent) {
        try {
            StringBuffer buffer = new StringBuffer(10);
            int i = 0;
            while (i < indent) {
                buffer.append("--");
                ++i;
            }
            buffer.append(StringUtils.escape((String)node.toString()));
            this.fOutputWriter.writeln(buffer.toString());
            ++indent;
            Node child = node.getFirstChild();
            while (child != null) {
                this.printNode(child, indent);
                child = child.getNextSibling();
            }
        }
        catch (Exception ex) {
            ModelTest.printException(ex);
        }
    }

    public void printSource(IDOMModel model) {
        try {
            this.fOutputWriter.writeln("Source :");
            this.fOutputWriter.writeln(model.getStructuredDocument().getText());
            this.fOutputWriter.writeln("");
        }
        catch (Exception ex) {
            ModelTest.printException(ex);
        }
    }

    public void printTree(IDOMModel model) {
        try {
            this.printFlatModel(model.getStructuredDocument());
            new StructuredDocumentRegionChecker((Writer)this.fOutputWriter).checkModel(model);
            this.fOutputWriter.writeln("Tree :");
            this.printNode((Node)model.getDocument(), 0);
            this.fOutputWriter.writeln("");
        }
        catch (Exception ex) {
            ModelTest.printException(ex);
        }
    }

    protected void saveAndCompareTestResults() {
        try {
            String testOutputDirectory = testResultsDirectoryPrefix + DateUtil.now();
            String currentFilename = String.valueOf(((Object)((Object)this)).getClass().getName()) + fileExtension;
            File fileout = FileUtil.makeFileFor(testOutputDirectory, currentFilename, testResultsDirectoryPrefix);
            FileWriter fileWriter = new FileWriter(fileout);
            fileWriter.write(this.fOutputWriter.toString());
            ((Writer)fileWriter).close();
            this.compareWithPreviousResults(this.fOutputWriter, currentFilename);
            if (this.echoToSystemOut) {
                System.out.println(this.fOutputWriter.toString());
            }
            this.fOutputWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void compareWithPreviousResults(TestWriter outputWriter, String currentFilename) throws IOException {
        boolean success = false;
        File previousResultsDir = FileUtil.getPreviousResultsDirectory(testResultsDirectoryPrefix);
        if (previousResultsDir != null) {
            String currentResults = outputWriter.toString();
            StringCompareUtil stringCompare = new StringCompareUtil();
            File previousResultsFile = new File(previousResultsDir, currentFilename);
            FileReader previousResultsFileReader = new FileReader(previousResultsFile);
            String previousResults = this.readString(previousResultsFileReader);
            if (!stringCompare.equalsIgnoreLineSeperator(previousResults, currentResults)) {
                success = false;
                System.out.println();
                System.out.println(String.valueOf(currentFilename) + " failed comparison to previous results");
                System.out.println("Previous: ");
                System.out.println(previousResults);
                System.out.println();
                System.out.println("Current: ");
                System.out.println(currentResults);
                System.out.println();
            } else {
                success = true;
                if (this.printSummaryToSystemOut) {
                    System.out.println();
                    System.out.println(String.valueOf(currentFilename) + " compared ok");
                    System.out.println();
                }
            }
        } else if (!this.printedOnce) {
            System.out.println();
            System.out.println("No Previous Directory found ... couldn't compare " + currentFilename + " with previous results");
            this.printedOnce = true;
            System.out.println();
        }
        ModelTest.assertTrue((String)("current is not equal to reference results for " + currentFilename), (boolean)success);
    }

    private String readString(FileReader fileReader) throws IOException {
        return this.readInputStream(fileReader);
    }

    private String readInputStream(InputStreamReader inputStreamReader) throws IOException {
        int numRead = 0;
        StringBuffer buffer = new StringBuffer();
        char[] tBuff = new char[this.READ_BUFFER_SIZE];
        while ((numRead = inputStreamReader.read(tBuff, 0, tBuff.length)) != -1) {
            buffer.append(tBuff, 0, numRead);
        }
        return buffer.toString();
    }

    public abstract void testModel();

    protected void printFlatModel(IStructuredDocument flatModel) {
        this.fOutputWriter.writeln("");
        this.fOutputWriter.writeln("StructuredDocument Regions :");
        IStructuredDocumentRegion flatnode = flatModel.getFirstStructuredDocumentRegion();
        while (flatnode != null) {
            this.fOutputWriter.writeln(flatnode.toString());
            flatnode = flatnode.getNext();
        }
        this.fOutputWriter.writeln("");
    }
}

