/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.task;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.ClasspathUtils;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.FileUtil;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.PlatformUtils;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.WSDLUtils;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ui.wsil.Utils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class DefaultsForServerJavaWSDLCommand
extends SimpleCommand {
    private MessageUtils msgUtils_;
    private MessageUtils coreMsgUtils_;
    private MessageUtils conMsgUtils_;
    private JavaWSDLParameter javaWSDLParam_ = null;
    private IProject serviceProject_;
    private String javaBeanName_;
    private String WSDLServiceURL_;
    private String WSDLServicePathname_;
    private WebServicesParser WSParser_;
    private String moduleName_;
    private String LABEL = "TASK_LABEL_SERVER_JAVA_WSDL_DEFAULTS";
    private String DESCRIPTION = "TASK_DESC_SERVER_JAVA_WSDL_DEFAULTS";
    private final String WSDL_FOLDER = "wsdl";
    public final String SERVICE_EXT = "/services/";
    private final String WSDL_EXT = "wsdl";
    public final byte MODE_BEAN = 0;
    public final String SERVICE_NAME_EXT = "Service";

    public DefaultsForServerJavaWSDLCommand(String moduleName) {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.coreMsgUtils_ = new MessageUtils("org.eclipse.jst.ws.axis.consumption.core.consumption", (Object)this);
        this.conMsgUtils_ = new MessageUtils("org.eclipse.jst.ws.axis.consumption.ui.plugin", (Object)this);
        this.moduleName_ = moduleName;
        this.setName(this.msgUtils_.getMessage(this.LABEL));
        this.setDescription(this.msgUtils_.getMessage(this.DESCRIPTION));
    }

    public DefaultsForServerJavaWSDLCommand(JavaWSDLParameter javaWSDLParam, Model model) {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.coreMsgUtils_ = new MessageUtils("org.eclipse.jst.ws.axis.consumption.core.consumption", (Object)this);
        this.setName(this.msgUtils_.getMessage(this.LABEL));
        this.setDescription(this.msgUtils_.getMessage(this.DESCRIPTION));
        this.setJavaWSDLParam(javaWSDLParam);
    }

    public Status execute(Environment env) {
        int index;
        if (this.javaWSDLParam_ == null) {
            SimpleStatus status = new SimpleStatus("DefaultsForServerJavaWSDLTask", this.coreMsgUtils_.getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"), 4);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        if (this.javaBeanName_ == null) {
            this.javaBeanName_ = this.javaWSDLParam_.getBeanName();
            if (this.javaBeanName_ == null) {
                this.javaWSDLParam_.setBeanName(this.javaBeanName_);
            }
        }
        this.javaWSDLParam_.setServerSide((byte)1);
        this.javaWSDLParam_.setSkeletonDeploy(false);
        this.javaWSDLParam_.setBeanName(this.javaBeanName_);
        String classpath = ClasspathUtils.getInstance().getClasspathString(this.serviceProject_, this.moduleName_);
        this.javaWSDLParam_.setClasspath(classpath);
        String simpleBeanName = this.javaBeanName_;
        if (this.javaBeanName_ != null && (index = this.javaBeanName_.lastIndexOf(46)) != -1) {
            simpleBeanName = this.javaBeanName_.substring(index + 1);
            this.javaBeanName_.substring(0, index);
        }
        String namespace = WSDLUtils.makeNamespace((String)this.javaWSDLParam_.getBeanName());
        this.javaWSDLParam_.setNamespace(namespace);
        this.javaWSDLParam_.setPortTypeName(simpleBeanName);
        this.javaWSDLParam_.setServiceName(String.valueOf(simpleBeanName) + "Service");
        IPath moduleServerRoot = null;
        IPath modulePath = this.serviceProject_.getFullPath();
        IPath webinfPath = this.serviceProject_.getFullPath();
        try {
            if (J2EEUtils.isWebComponent((IProject)this.serviceProject_, (String)this.moduleName_)) {
                moduleServerRoot = ResourceUtils.getJavaSourceLocation((IProject)this.serviceProject_, (String)this.moduleName_);
                modulePath = J2EEUtils.getWebContentPath((IProject)this.serviceProject_, (String)this.moduleName_);
                webinfPath = J2EEUtils.getWebInfPath((IProject)this.serviceProject_, (String)this.moduleName_);
            }
        }
        catch (Exception e) {
            SimpleStatus status = new SimpleStatus("DefaultsForServerJavaWSDLTask", this.conMsgUtils_.getMessage("MSG_ERROR_DEFAULT_BEAN"), 4, (Throwable)e);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        IPath wsdlPath = modulePath.append("wsdl").append(simpleBeanName).addFileExtension("wsdl");
        try {
            IFolder folder = ResourceUtils.getWorkspaceRoot().getFolder(modulePath.append("wsdl"));
            FileUtil.createFolder((IFolder)folder, (boolean)true, (boolean)true);
        }
        catch (CoreException e) {
            SimpleStatus status = new SimpleStatus("DefaultsForServerJavaWSDLTask", this.conMsgUtils_.getMessage("MSG_ERROR_WRITE_WSDL"), 4, (Throwable)e);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        String wsdlLocation = ResourceUtils.getWorkspaceRoot().getFile(wsdlPath).getLocation().toString();
        this.javaWSDLParam_.setOutputWsdlLocation(wsdlLocation);
        this.javaWSDLParam_.setInputWsdlLocation(wsdlLocation);
        this.WSDLServicePathname_ = wsdlPath.toString();
        if (wsdlPath != null) {
            IResource res;
            String wsdlURL;
            this.WSDLServiceURL_ = wsdlURL = PlatformUtils.getFileURLFromPath((IPath)new Path(wsdlLocation));
            if ((wsdlURL == null || wsdlURL.length() <= 0) && (res = ResourceUtils.findResource((String)this.WSDLServicePathname_)) != null) {
                wsdlURL = new Utils().toFileSystemURI(res);
            }
            if (wsdlURL != null && wsdlURL.length() > 0) {
                if (this.WSParser_ == null) {
                    this.WSParser_ = new WebServicesParserExt();
                }
                this.WSParser_.getWSDLDefinition(wsdlURL);
            }
        }
        this.javaWSDLParam_.setStyle("RPC");
        this.javaWSDLParam_.setUse("ENCODED");
        String projectURL = ServerUtils.getEncodedWebComponentURL((IProject)this.serviceProject_, (String)this.moduleName_);
        if (projectURL == null) {
            SimpleStatus status = new SimpleStatus("DefaultsForServerJavaWSDLTask", this.msgUtils_.getMessage("MSG_ERROR_PROJECT_URL"), 4);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        String serviceURL = String.valueOf(projectURL) + "/services/" + simpleBeanName;
        this.javaWSDLParam_.setUrlLocation(serviceURL);
        this.javaWSDLParam_.setMetaInfOnly(true);
        String javaOutput = ResourceUtils.findResource((IPath)moduleServerRoot).getLocation().toString();
        String serviceName = this.javaWSDLParam_.getServiceName();
        IPath outputPath = ResourceUtils.findResource((IPath)webinfPath).getLocation();
        String output = this.serviceProject_.getFullPath().toString();
        if (outputPath != null) {
            output = outputPath.append(serviceName).toString();
        }
        this.javaWSDLParam_.setJavaOutput(javaOutput);
        this.javaWSDLParam_.setOutput(output);
        return new SimpleStatus("");
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject_ = serviceProject;
    }

    public void setJavaBeanName(String javaBeanName) {
        this.javaBeanName_ = javaBeanName;
    }

    public String getWSDLServiceURL() {
        return this.WSDLServiceURL_;
    }

    public String getWSDLServicePathname() {
        return this.WSDLServicePathname_;
    }

    public void setParser(WebServicesParser wsParser) {
        this.WSParser_ = wsParser;
    }

    public WebServicesParser getParser() {
        return this.WSParser_;
    }

    public void setObjectSelection(IStructuredSelection objectSelection) {
        Object object;
        if (objectSelection != null && !objectSelection.isEmpty() && (object = objectSelection.getFirstElement()) instanceof String) {
            this.setJavaBeanName((String)object);
        }
    }
}

