/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.widgets.bean;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.PlatformUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class BeanConfigWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.axis.creation.ui";
    private Button rpcEncodedButton_;
    private Button rpcLiteralButton_;
    private Button docLiteralButton_;
    private Listener statusListener_;
    private JavaWSDLParameter javaParameter_;
    private final String INFOPOP_PBCF_PAGE = "PBCF0001";
    private final String TOOLTIP_PBCF_PAGE = "TOOLTIP_PBCF_PAGE";
    private Text uriText_;
    private final String INFOPOP_PBCF_TEXT_URI = "PBCF0002";
    private final String TOOLTIP_PBCF_TEXT_URI = "TOOLTIP_PBCF_TEXT_URI";
    private Text wsdlFolderText_;
    private final String INFOPOP_PBCF_TEXT_WSDL_FOLDER = "PBCF0006";
    private final String TOOLTIP_PBCF_TEXT_WSDL_FOLDER = "TOOLTIP_PBCF_TEXT_WSDL_FOLDER";
    private Text wsdlFileText_;
    private final String INFOPOP_PBCF_TEXT_WSDL_FILE = "PBCF0007";
    private final String TOOLTIP_PBCF_TEXT_WSDL_FILE = "TOOLTIP_PBCF_TEXT_WSDL_FILE";
    private Tree methodsTree_;
    private final String INFOPOP_PBME_TREE_METHODS = "PBME0002";
    private final String TOOLTIP_PBME_TREE_METHODS = "TOOLTIP_PBME_TREE_METHODS";
    private Button selectAllMethodsButton_;
    private final String INFOPOP_PBME_BUTTON_SELECT_ALL = "PBME0010";
    private final String TOOLTIP_PBME_BUTTON_SELECT_ALL = "TOOLTIP_PBME_BUTTON_SELECT_ALL";
    private Button deselectAllMethodsButton_;
    private final String INFOPOP_PBME_BUTTON_DESELECT_ALL = "PBME0011";
    private final String TOOLTIP_PBME_BUTTON_DESELECT_ALL = "TOOLTIP_PBME_BUTTON_DESELECT_ALL";
    private Button showMappingsCheckbox_;
    private String INFOPOP_P2N_SHOW_MAPPINGS = "PBCF0016";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        String baseConPluginId = "org.eclipse.jst.ws.consumption.ui";
        MessageUtils msgUtils = new MessageUtils(String.valueOf(this.pluginId_) + ".plugin", (Object)this);
        MessageUtils baseConUtils = new MessageUtils(String.valueOf(baseConPluginId) + ".plugin", (Object)this);
        UIUtils uiUtils = new UIUtils(msgUtils, this.pluginId_);
        UIUtils baseConUiUtils = new UIUtils(baseConUtils, this.pluginId_);
        this.statusListener_ = statusListener;
        parent.setToolTipText(msgUtils.getMessage("TOOLTIP_PBCF_PAGE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(this.pluginId_) + "." + "PBCF0001");
        Composite configGroup = uiUtils.createComposite(parent, 2);
        this.uriText_ = uiUtils.createText(configGroup, "LABEL_URI", "TOOLTIP_PBCF_TEXT_URI", "PBCF0002", 2060);
        this.wsdlFolderText_ = uiUtils.createText(configGroup, "LABEL_OUTPUT_FOLDER_NAME", "TOOLTIP_PBCF_TEXT_WSDL_FOLDER", "PBCF0006", 2060);
        this.wsdlFileText_ = uiUtils.createText(configGroup, "LABEL_OUTPUT_FILE_NAME", "TOOLTIP_PBCF_TEXT_WSDL_FILE", "PBCF0007", 2052);
        this.wsdlFileText_.addListener(24, statusListener);
        uiUtils.createHorizontalSeparator(parent, 6);
        Group methodsGroup = baseConUiUtils.createGroup(parent, "LABEL_METHODS", null, null);
        methodsGroup.setLayoutData((Object)uiUtils.createFillAll());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        methodsGroup.setLayout((Layout)layout);
        this.methodsTree_ = uiUtils.createTree((Composite)methodsGroup, "TOOLTIP_PBME_TREE_METHODS", "PBME0002", 2850);
        this.methodsTree_.addListener(13, statusListener);
        Composite selectButtons = uiUtils.createComposite((Composite)methodsGroup, 2);
        this.selectAllMethodsButton_ = baseConUiUtils.createPushButton(selectButtons, "BUTTON_SELECT_ALL", "TOOLTIP_PBME_BUTTON_SELECT_ALL", "PBME0010");
        this.selectAllMethodsButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                BeanConfigWidget.this.handleSelectAll(true);
            }
        });
        this.deselectAllMethodsButton_ = baseConUiUtils.createPushButton(selectButtons, "BUTTON_DESELECT_ALL", "TOOLTIP_PBME_BUTTON_DESELECT_ALL", "PBME0011");
        this.deselectAllMethodsButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                BeanConfigWidget.this.handleSelectAll(false);
            }
        });
        Group styleGroup = uiUtils.createGroup(parent, "LABEL_STYLE_USE", null, null);
        this.docLiteralButton_ = uiUtils.createRadioButton((Composite)styleGroup, "STYLE_DOC_LITERAL", null, null);
        this.rpcLiteralButton_ = uiUtils.createRadioButton((Composite)styleGroup, "STYLE_RPC_LITERAL", null, null);
        this.rpcEncodedButton_ = uiUtils.createRadioButton((Composite)styleGroup, "STYLE_RPC_ENCODED", null, null);
        this.showMappingsCheckbox_ = uiUtils.createCheckbox(parent, "LABEL_EXPLORE_MAPPINGS_BEAN2XML", "TOOLTIP_P2N_SHOW_MAPPINGS", this.INFOPOP_P2N_SHOW_MAPPINGS);
        return this;
    }

    public void handleSelectAll(boolean value) {
        TreeItem[] items = this.methodsTree_.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(value);
            ++i;
        }
        this.statusListener_.handleEvent(null);
    }

    public void setCustomizeServiceMappings(boolean value) {
        this.showMappingsCheckbox_.setSelection(value);
    }

    public boolean getCustomizeServiceMappings() {
        return this.showMappingsCheckbox_ == null ? false : this.showMappingsCheckbox_.getSelection();
    }

    public void setJavaParameter(JavaWSDLParameter javaParameter) {
        String style;
        this.javaParameter_ = javaParameter;
        String wsdlLocation = javaParameter.getOutputWsdlLocation();
        Path wsdlPath = new Path(wsdlLocation);
        this.wsdlFolderText_.setText(wsdlPath.removeLastSegments(1).toString());
        this.wsdlFileText_.setText(wsdlPath.lastSegment());
        String location = javaParameter.getUrlLocation();
        this.uriText_.setText(location == null ? "" : location);
        this.methodsTree_.removeAll();
        Hashtable methods = javaParameter.getMethods();
        Enumeration e = methods.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            TreeItem item = new TreeItem(this.methodsTree_, 0);
            item.setData((Object)name);
            item.setText(name);
            item.setChecked(((Boolean)methods.get(name)).booleanValue());
        }
        TreeItem[] items = this.methodsTree_.getItems();
        if (items.length > 0) {
            this.methodsTree_.setSelection(new TreeItem[]{items[0]});
        }
        if ((style = javaParameter.getStyle()).equals("RPC")) {
            this.rpcEncodedButton_.setSelection(true);
        } else if (style.equals("DOCUMENT")) {
            this.rpcLiteralButton_.setSelection(true);
        } else {
            this.docLiteralButton_.setSelection(true);
        }
    }

    public JavaWSDLParameter getJavaParameter() {
        IPath wsdlPath = new Path(this.wsdlFolderText_.getText().trim()).append(this.wsdlFileText_.getText().trim());
        ResourceUtils.getWorkspaceRoot();
        String wsdlLocation = wsdlPath.toString();
        this.javaParameter_.setOutputWsdlLocation(wsdlLocation);
        this.javaParameter_.setInputWsdlLocation(wsdlLocation);
        PlatformUtils.getFileURLFromPath((IPath)new Path(wsdlLocation));
        Hashtable<String, Boolean> methods = new Hashtable<String, Boolean>();
        TreeItem[] items = this.methodsTree_.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            methods.put((String)item.getData(), new Boolean(item.getChecked()));
            ++i;
        }
        this.javaParameter_.setMethods(methods);
        if (this.rpcEncodedButton_.getSelection()) {
            this.javaParameter_.setStyle("RPC");
            this.javaParameter_.setUse("ENCODED");
        } else if (this.rpcLiteralButton_.getSelection()) {
            this.javaParameter_.setStyle("DOCUMENT");
            this.javaParameter_.setUse("LITERAL");
        } else {
            this.javaParameter_.setStyle("WRAPPED");
            this.javaParameter_.setUse("LITERAL");
        }
        return this.javaParameter_;
    }

    public Status getStatus() {
        SimpleStatus result = null;
        MessageUtils msgUtils = new MessageUtils(String.valueOf(this.pluginId_) + ".plugin", (Object)this);
        if (this.wsdlFileText_.getText().equals("")) {
            result = new SimpleStatus("", msgUtils.getMessage("PAGE_MSG_NO_FILE_SPECIFIED"), 4);
        } else {
            TreeItem[] items = this.methodsTree_.getItems();
            boolean itemSelected = false;
            int index = 0;
            while (index < items.length) {
                if (items[index].getChecked()) {
                    itemSelected = true;
                    break;
                }
                ++index;
            }
            if (!itemSelected) {
                result = new SimpleStatus("", msgUtils.getMessage("PAGE_MSG_NO_METHOD_SELECTED"), 4);
            }
        }
        return result;
    }
}

