/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.content;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.UserIdentification;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManager;
import org.eclipse.wst.rdb.internal.core.util.DatabaseProviderHelper;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.WorkOffline;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

public class ServerExplorerConfiguration {
    private static final RDBCorePlugin corePlugin = RDBCorePlugin.getDefault();
    private static final ConnectionManager connectionManager = corePlugin.getConnectionManager();
    private static final String ERROR_CONNECTION = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.CONNECTION.ERROR.MESSAGE");
    private static final String ERROR_CONN_TITLE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.CONNECTION.ERROR.TITLE");
    private static final String ERROR_MESSAGE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.CONNECTION.ERROR.MESSAGE");
    private static final String USER_NAME = "user";
    private static final String PASSWORD = "password";
    private UserNotLoggedException userException;
    private Connection userConnection = null;
    private Exception connectException = null;

    private void getLoginInformation(final IConnectionNode server, final ConnectionInfo info, final String userName) throws UserNotLoggedException {
        this.userException = null;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                block6: {
                    UserIdentification idDialog = new UserIdentification(userName);
                    if (idDialog.open() == 0) {
                        String us = idDialog.getUserNameInformation();
                        String pa = idDialog.getPasswordInformation();
                        info.getProperties().setProperty(ServerExplorerConfiguration.USER_NAME, us == null ? "" : us);
                        info.getProperties().setProperty(ServerExplorerConfiguration.PASSWORD, pa == null ? "" : pa);
                        try {
                            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this, info){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ ConnectionInfo val$info;
                                {
                                    this.this$1 = var1_1;
                                    this.val$info = connectionInfo;
                                }

                                public void run() {
                                    try {
                                        ServerExplorerConfiguration.access$0(1.access$0(this.this$1), this.val$info.connect());
                                    }
                                    catch (Exception e) {
                                        ServerExplorerConfiguration.access$1(1.access$0(this.this$1), e);
                                    }
                                }
                            });
                            if (ServerExplorerConfiguration.this.userConnection == null) {
                                throw new Exception(ServerExplorerConfiguration.this.connectException);
                            }
                            info.setSharedConnection(ServerExplorerConfiguration.this.userConnection);
                            new DatabaseProviderHelper().setDatabase(ServerExplorerConfiguration.this.userConnection, info, info.getDatabaseName());
                            info.saveConnectionInfo();
                        }
                        catch (Exception e) {
                            String message = MessageFormat.format(ERROR_CONNECTION, e.getMessage());
                            if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)ERROR_CONN_TITLE, (String)message)) {
                                WorkOffline offline = new WorkOffline();
                                offline.selectionChanged(null, (ISelection)new StructuredSelection((Object)server));
                                offline.run(null);
                                break block6;
                            }
                            ServerExplorerConfiguration.this.userException = new UserNotLoggedException();
                        }
                    } else {
                        ServerExplorerConfiguration.this.userException = new UserNotLoggedException();
                    }
                }
            }

            static /* synthetic */ ServerExplorerConfiguration access$0(1 var0) {
                return var0.ServerExplorerConfiguration.this;
            }
        });
        if (this.userException != null) {
            throw this.userException;
        }
    }

    public void save(ConnectionInfo connectionInfo) throws IOException {
        connectionInfo.saveConnectionInfo();
    }

    public void deleteServer(IConnectionNode serverNode) {
        ConnectionInfo info = corePlugin.getConnectionManager().getConnectionInfo(serverNode.getName());
        if (info != null) {
            corePlugin.getConnectionManager().removeConnectionInfo(serverNode.getName());
        }
    }

    public ConnectionInfo restoreConnectionInfo(IConnectionNode server, ConnectionInfo connectionInfo) {
        try {
            Database database = connectionInfo.getSharedDatabase();
            if (database == null) {
                this.getLoginInformation(server, connectionInfo, connectionInfo.getUserName());
            }
            return connectionInfo;
        }
        catch (UserNotLoggedException userNotLoggedException) {
            return null;
        }
    }

    public ConnectionInfo[] getRestoredConnections() {
        return corePlugin.getConnectionManager().getAllNamedConnectionInfo();
    }

    static /* synthetic */ void access$0(ServerExplorerConfiguration serverExplorerConfiguration, Connection connection) {
        serverExplorerConfiguration.userConnection = connection;
    }

    static /* synthetic */ void access$1(ServerExplorerConfiguration serverExplorerConfiguration, Exception exception) {
        serverExplorerConfiguration.connectException = exception;
    }

    private class UserNotLoggedException
    extends Exception {
        private static final long serialVersionUID = -5743507206244947582L;

        UserNotLoggedException() {
        }
    }

    private class ConnectionNotEstablishedException
    extends Exception {
        private static final long serialVersionUID = 6480464713778981637L;

        public ConnectionNotEstablishedException(Throwable e) {
            super(e);
        }
    }
}

