/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.providers.bookmark;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionSharingListener;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.server.internal.ui.util.ServerUIDebugOptions;
import org.eclipse.wst.rdb.server.internal.ui.util.TransientEObjectUtil;
import org.eclipse.wst.rdb.server.internal.ui.util.logging.Logger;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

public class BookmarkProvider
extends Action {
    private static final String BLANK_ID = "";
    private static final String ADD_BOOKMARK_TITLE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.BOOKMARK.TITLE");
    private static final String ADD_BOOKMARK_MESSAGE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.BOOKMARK.MESSAGE");
    private IViewPart viewPart;
    private IResourceChangeListener bookmarkListener;
    private List infoListener = new LinkedList();

    private String getElementId(EObject eObject) throws Exception {
        return TransientEObjectUtil.getEObjectId(eObject);
    }

    private EObject getElementFromId(String elementID) {
        return TransientEObjectUtil.getEObjectFromId(elementID);
    }

    private IMarker addBookmark(Map attributes, Object element) {
        try {
            IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker("org.eclipse.wst.rdb.core.ui.transientBookmark");
            marker.setAttributes(attributes);
            IDataToolsUIServiceManager.INSTANCE.getBookmarkDecorationService().refreshDecoration(element);
            return marker;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void enableConnectionListener(IMarker marker, EObject eObject) {
        ConnectionInfo info = TransientEObjectUtil.getConnectionInfo(eObject);
        try {
            marker.setAttribute("connectionName", (Object)info.getName());
        }
        catch (CoreException coreException) {}
        if (!this.infoListener.contains(info)) {
            this.infoListener.add(info);
            info.addConnectionSharingListener(new ConnectionSharingListener(){

                public void sharedConnectionAdded(ConnectionInfo info, Connection connection) {
                }

                public void sharedConnectionRemove(ConnectionInfo info, Connection connection) {
                }

                public void sharedDatabaseAdded(ConnectionInfo info, Database database) {
                }

                public void sharedDatabaseRemove(ConnectionInfo info, Database database) {
                    BookmarkProvider.this.infoListener.remove(info);
                    try {
                        IMarker[] markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.bookmark", true, 2);
                        int i = 0;
                        int n = markers.length;
                        while (i < n) {
                            IMarker marker = markers[i];
                            if (info.getName().equals(marker.getAttribute("connectionName"))) {
                                marker.delete();
                            }
                            ++i;
                        }
                    }
                    catch (CoreException coreException) {}
                }

                public void onSQLException(ConnectionInfo info, Connection connection, SQLException exception) {
                }
            });
        }
    }

    private void addEObjectBookmark(EObject eObject, String description) {
        try {
            String elementName = IDataToolsUIServiceManager.INSTANCE.getLabelService((Object)eObject).getName();
            HashMap<String, String> attribMap = new HashMap<String, String>();
            attribMap.put("location", elementName);
            attribMap.put("message", description);
            attribMap.put("elementId", this.getElementId(eObject));
            IMarker marker = this.addBookmark(attribMap, eObject);
            this.enableConnectionListener(marker, eObject);
        }
        catch (Exception e) {
            Logger.log((Object)this, e, ServerUIDebugOptions.SERVER_EXPLORER_LOG);
        }
    }

    private void addBookmark(Object element, String name) {
        InputDialog descriptionDialog = new InputDialog(Display.getCurrent().getActiveShell(), ADD_BOOKMARK_TITLE, ADD_BOOKMARK_MESSAGE, name, null);
        if (descriptionDialog.open() == 0 && element instanceof EObject) {
            this.addEObjectBookmark((EObject)element, descriptionDialog.getValue());
        }
    }

    public BookmarkProvider(IViewPart viewPart) {
        this.viewPart = viewPart;
        this.bookmarkListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IMarkerDelta[] delta = event.findMarkerDeltas("org.eclipse.wst.rdb.core.ui.transientBookmark", false);
                if (delta.length != 0) {
                    int i = 0;
                    int n = delta.length;
                    while (i < n) {
                        EObject object;
                        String id;
                        if (delta[i].getKind() == 2 && !(id = delta[i].getAttribute("elementId", BookmarkProvider.BLANK_ID)).equals(BookmarkProvider.BLANK_ID) && (object = BookmarkProvider.this.getElementFromId(id)) != null) {
                            IDataToolsUIServiceManager.INSTANCE.getBookmarkDecorationService().refreshDecoration((Object)object);
                        }
                        ++i;
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.bookmarkListener);
    }

    public void removeListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.bookmarkListener);
    }

    public void run() {
        ISelection selection = this.viewPart.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)selection).iterator();
            while (iterator.hasNext()) {
                Object current = iterator.next();
                String currentName = BLANK_ID;
                if (current instanceof SQLObject) {
                    currentName = IDataToolsUIServiceManager.INSTANCE.getLabelService(current).getName();
                }
                this.addBookmark(current, currentName);
            }
        }
    }
}

