/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.core;

import org.eclipse.core.runtime.*;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.rdb.internal.core.*;
import org.eclipse.wst.rdb.internal.models.sql.schema.*;
import org.eclipse.wst.rdb.internal.models.sql.tables.*;
import org.osgi.framework.BundleContext;
import java.util.*;

/**
 * The main plugin class to be used in the desktop.
 */
public class DataCorePlugin extends Plugin
{
	//The shared instance.
	private static DataCorePlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	
	public static final String ID = "org.eclipse.wst.rdb.data.core"; //$NON-NLS-1$
	
	/**
	 * The constructor.
	 */
	public DataCorePlugin() {
		super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle.getBundle("org.eclipse.wst.rdb.data.internal.core.CorePluginResources"); //$NON-NLS-1$
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}

	/**
	 * Returns the shared instance.
	 */
	public static DataCorePlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = DataCorePlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	
	/**
	 * Method writeLog.
	 * @param severity - the severity; one of IStatus.OK, IStatus.ERROR, IStatus.INFO, or IStatus.WARNING
	 * @param code - the plug-in-specific status code, or OK
	 * @param message - a human-readable message, localized to the current locale
	 * @param exception- a low-level exception, or null if not applicable
	 */
	public void writeLog(int severity, int code, String message, Throwable exception) {
		if (message == null)
			message = ""; //$NON-NLS-1$
		getLog().log(
				new Status(severity, getBundle().getSymbolicName(), code, message, exception));
	}
	
    public static String getQualifiedTableName(Table table) {        
        return quoteIdentifier(table, table.getSchema().getName()) + "." + quoteIdentifier(table, table.getName()); //$NON-NLS-1$
    }
    
    public static String quoteIdentifier(SQLObject o, String s)
    {
//        String delim = RDBCorePlugin.getDefault().getConnectionManager().getConnectionInfo(o).getIdentifierQuoteString();
//        if (delim == null || delim.length() == 0)
//            delim = "\""; //$NON-NLS-1$
        String delim = "\""; //$NON-NLS-1$
        
        return delim + doubleStringDelim(s, delim) + delim;
    }
    
    public static String doubleStringDelim(String s, String delim)
	{
        if (delim==null||delim.length()==0)
            return s;
        
        int i = s.indexOf(delim);
        if(i != -1) {
            StringBuffer sb = new StringBuffer(s);            
            int j;
            for(; i != -1; i = sb.toString().indexOf(delim, j)) {
                sb = sb.insert(i, delim);
                j = i + 2*delim.length();
            }
            return sb.toString();
        } else
            return s;
	}
}
