/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.views.deferred;

import java.util.Comparator;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.DefaultNavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;


/** 
 */
public class ProxyContentExtension extends DefaultNavigatorContentExtension implements INavigatorContentExtension {

	private NavigatorContentDescriptor descriptor;
	private INavigatorContentExtension delegateExtension;
	private INavigatorContentProvider delegateContentProvider;
	private ILabelProvider delegateLabelProvider;
	private ICommonLabelProvider labelProvider;
	private INavigatorContentProvider contentProvider;
	private NavigatorContentService contentService;

	public ProxyContentExtension(NavigatorContentDescriptor descriptor) {
		this.descriptor = descriptor;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentExtension#getContentProvider()
	 */
	public INavigatorContentProvider getContentProvider() {

		if (contentProvider == null)
			contentProvider = new ProxyContentProvider(this);
		return contentProvider;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentExtension#getLabelProvider()
	 */
	public ICommonLabelProvider getLabelProvider() {
		if (labelProvider == null)
			labelProvider = new ProxyLabelProvider(this);
		return labelProvider;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.views.INavigatorContentExtension#init(org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentService)
	 */
	public void init(NavigatorContentService aContentService) {
		contentService = aContentService;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentExtension#dispose()
	 */
	public void dispose() {
		if (isExtensionLoaded())
			getDelegateExtension().dispose();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentExtension#getComparator()
	 */
	public Comparator getComparator() {
		if (!isExtensionLoaded())
			return null;
		return getDelegateExtension().getComparator();
	}



	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentExtension#setDescriptor(org.eclipse.wst.common.navigator.internal.views.navigator.internal.registry.NavigatorContentDescriptor)
	 */
	public void setDescriptor(NavigatorContentDescriptor descriptor) {
		if (descriptor == null)
			this.descriptor = descriptor;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentExtension#getDescriptor()
	 */
	public NavigatorContentDescriptor getDescriptor() {
		return this.descriptor;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter) {
		if (!isExtensionLoaded())
			return Platform.getAdapterManager().getAdapter(this, adapter);
		return getDelegateExtension().getAdapter(adapter);
	}

	protected boolean isExtensionLoaded() {
		return delegateExtension != null;
	}

	protected boolean isContentProviderLoaded() {
		return delegateContentProvider != null;
	}

	public boolean isLabelProviderLoaded() {
		return delegateLabelProvider != null;
	}

	protected INavigatorContentExtension getDelegateExtension() {
		if (delegateExtension == null) {
			delegateExtension = descriptor.createExtension(/* proxyIfNecessary = */false);
			delegateExtension.init(descriptor, contentService);

		}
		return delegateExtension;
	}

	protected INavigatorContentProvider getDelegateContentProvider() {
		if (delegateContentProvider == null)
			delegateContentProvider = getDelegateExtension().getContentProvider();
		return delegateContentProvider;
	}

	protected ILabelProvider getDelegateLabelProvider() {
		if (delegateLabelProvider == null)
			delegateLabelProvider = getDelegateExtension().getLabelProvider();
		return delegateLabelProvider;
	}

}