/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.common.navigator.internal.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jst.common.navigator.internal.plugin.WTPNavigatorResourceHandler;
import org.eclipse.swt.widgets.Menu;


/**
 * @author mdelder
 *  
 */
public class CompressedMenu extends MenuManager {

	private String unit = null;
	private Map unitMap;
	private Map groupMap;
	private boolean compressGroups = false;

	/**
	 *  
	 */
	public CompressedMenu() {
		super();
	}

	/**
	 * @param text
	 */
	public CompressedMenu(String text) {
		super(text);
	}

	/**
	 * @param text
	 * @param id
	 */
	public CompressedMenu(String text, String id) {
		super(text, id);
	}

	public void openUnit(String unit1) {
		if (isUnitActive())
			throw new IllegalStateException(WTPNavigatorResourceHandler.getString("1_UI_", new Object[]{this.unit})); //$NON-NLS-1$
		this.unit = unit1;
	}

	public void closeUnit(String unit1) {
		if (!isUnitActive() || !this.unit.equals(unit1))
			throw new IllegalStateException(WTPNavigatorResourceHandler.getString("2_UI_", new Object[]{unit1, unit1})); //$NON-NLS-1$
		this.unit = null;
	}

	public void commit() {

		if (menusShouldBeCompressed()) {
			String key = null;
			/* commit the units -- units are built via add(IContributionItem|IAction) */
			for (Iterator keys = getUnitMap().keySet().iterator(); keys.hasNext();) {
				key = keys.next().toString();
				List list = getUnitList(key);

				if (list.size() < 2) {
					for (Iterator iterator = list.iterator(); iterator.hasNext();)
						super.add((ContributionItem) iterator.next());
				} else {
					IMenuManager submenu = new MenuManager(key, key + ".id"); //$NON-NLS-1$
					for (Iterator iterator = list.iterator(); iterator.hasNext();)
						submenu.add((ContributionItem) iterator.next());
					super.add(submenu);
				}
			}
			//			if (isCompressGroups()) {
			//				/* commit the groups -- groups are built via appendToGroup(String, IContributionItem)
			// */
			//				for (Iterator keys = getGroupMap().keySet().iterator(); keys.hasNext();) {
			//					key = keys.next().toString();
			//					List list = getGroupList(key);
			//
			//					if (list.size() < 2) {
			//						for (Iterator iterator = list.iterator(); iterator.hasNext();)
			//							super.appendToGroup(key, (ContributionItem) iterator.next());
			//					} else {
			//						IMenuManager submenu = new MenuManager(key, key + ".id");
			//						for (Iterator iterator = list.iterator(); iterator.hasNext();)
			//							submenu.appendToGroup(key, (ContributionItem) iterator.next());
			//						super.add(submenu);
			//					}
			//				}
			//			}
			getUnitMap().clear();
		} else {
			/* commit the units -- units are built via add(IContributionItem|IAction) */
			for (Iterator keys = getUnitMap().keySet().iterator(); keys.hasNext();) {
				List list = getUnitList(keys.next().toString());
				for (Iterator iterator = list.iterator(); iterator.hasNext();)
					super.add((ContributionItem) iterator.next());
			}
			//			/* commit the groups -- groups are built via appendToGroup(String, IContributionItem)
			// */
			//			String key = null;
			//			for (Iterator keys = getGroupMap().keySet().iterator(); keys.hasNext();) {
			//				key = keys.next().toString();
			//				List list = getGroupList(key);
			//				for (Iterator iterator = list.iterator(); iterator.hasNext();)
			//					super.appendToGroup(key, (ContributionItem) iterator.next());
			//			}
		}
	}

	/**
	 * @return
	 */
	private boolean menusShouldBeCompressed() {
		int count = 0;
		if (getUnitMap().size() < 2)
			return false;
		for (Iterator unitKeys = getUnitMap().keySet().iterator(); unitKeys.hasNext();) {
			List unitList = getUnitList(unitKeys.next().toString());
			if ((count += unitList.size()) > 5)
				return true;
		}
		return false;
	}

	//	/*
	//	 * (non-Javadoc)
	//	 *
	//	 * @see org.eclipse.jface.action.ContributionManager#add(org.eclipse.jface.action.IAction)
	//	 */
	//	public void add(IAction action) {
	//		if (isUnitActive())
	//			getUnitList(this.unit).add(new ActionContributionItem(action));
	//		else
	//			super.add(action);
	//	}

	/**
	 * @return
	 */
	private boolean isUnitActive() {
		return this.unit != null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.action.ContributionManager#add(org.eclipse.jface.action.IContributionItem)
	 */
	public void add(IContributionItem item) {
		if (isUnitActive())
			getUnitList(this.unit).add(item);
		else
			super.add(item);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.action.MenuManager#fill(org.eclipse.swt.widgets.Menu, int)
	 */
	public void fill(Menu parent, int index) {
		commit();
		/* perform some mininaml heuristics to provide a better user experience. */
		IContributionItem[] items = getItems();
		int cnt = 0, contributionIndex = 0;
		for (int i = 0; cnt < 2 && i < items.length; i++)
			if (items[i] instanceof ActionContributionItem || items[i] instanceof IContributionManager) {
				cnt++;
				contributionIndex = i;
			}

		if (cnt == 1)
			items[contributionIndex].fill(parent, index);
		else
			super.fill(parent, index);
	}

	protected List getUnitList(String name) {
		if (name == null)
			throw new IllegalArgumentException(WTPNavigatorResourceHandler.getString("", new Object[]{name})); //$NON-NLS-1$
		List result = (List) getUnitMap().get(name);
		if (result == null)
			getUnitMap().put(name, (result = new ArrayList()));
		return result;
	}

	/**
	 * @return Returns the unitMap.
	 */
	protected Map getUnitMap() {
		if (unitMap == null)
			unitMap = new HashMap();
		return unitMap;
	}

	protected List getGroupList(String name) {
		if (name == null)
			throw new IllegalArgumentException(WTPNavigatorResourceHandler.getString("4_UI_", new Object[]{name})); //$NON-NLS-1$
		List result = (List) getGroupMap().get(name);
		if (result == null)
			getGroupMap().put(name, (result = new ArrayList()));
		return result;
	}

	/**
	 * @return Returns the groupMap.
	 */
	protected Map getGroupMap() {
		if (groupMap == null)
			groupMap = new HashMap();
		return groupMap;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.action.ContributionManager#appendToGroup(java.lang.String,
	 *      org.eclipse.jface.action.IContributionItem)
	 */
	public void appendToGroup(String groupName, IContributionItem item) {
		if (compressGroups)
			getGroupList(groupName).add(item);
		else
			super.appendToGroup(groupName, item);
	}

	/**
	 * @return Returns the compressGroups.
	 */
	public boolean isCompressGroups() {
		return compressGroups;
	}

	/**
	 * @param compressGroups
	 *            The compressGroups to set.
	 */
	public void setCompressGroups(boolean compressGroups) {
		this.compressGroups = compressGroups;
	}

}