/***************************************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 **************************************************************************************************/
package org.eclipse.jst.common.navigator.internal.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.actions.CommonActionProvider;


/** 
 */
public class ResourceRefactorActionsExtension extends CommonActionProvider implements ICommonActionProvider {


	private RefactorActionGroup refactorGroup;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#init(org.eclipse.ui.IViewPart,
	 *      org.eclipse.jface.viewers.StructuredViewer,
	 *      org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentService)
	 */
	public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService) {
		refactorGroup = new RefactorActionGroup(aViewPart);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#setActionContext(org.eclipse.ui.actions.ActionContext)
	 */
	public void setActionContext(ActionContext aContext) {
		refactorGroup.setContext(aContext);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#fillActionBars(org.eclipse.ui.IActionBars)
	 */
	public boolean fillActionBars(IActionBars theActionBars) {
		refactorGroup.fillActionBars(theActionBars);
		refactorGroup.retargetFileMenuActions(theActionBars);
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#fillContextMenu(org.eclipse.jface.action.IMenuManager)
	 */
	public boolean fillContextMenu(IMenuManager aMenu) {
		refactorGroup.fillContextMenu(aMenu);
		return true;
	}

	/**
	 * @param selection
	 * @return
	 */
	protected IStructuredSelection convertToJavaElements(IStructuredSelection selection) {
		Object[] elements = selection.toArray();
		for (int i = 0; i < elements.length; i++) {
			elements[i] = convertToJavaElement(elements[i]);
		}
		return new StructuredSelection(elements);
	}

	/**
	 * @param object
	 * @return
	 */
	private Object convertToJavaElement(Object object) {
		if (object instanceof IResource) {
			IJavaElement element = JavaCore.create((IResource) object);
			if (element != null)
				return element;
		}
		return object;
	}


}