/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.common.navigator.internal.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.views.filters.NavigatorExtensionFilter;

/**
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public class JavaResourceFilter extends NavigatorExtensionFilter {

	/**
	 *  
	 */
	public JavaResourceFilter() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.views.INavigatorExtensionFilter#select(org.eclipse.wst.common.navigator.internal.views.CommonViewer,
	 *      java.lang.Object, java.lang.Object)
	 */
	public boolean select(CommonViewer aViewer, Object aParentElement, Object anElement) {
		if (anElement instanceof IFile || anElement instanceof IFolder) {
			IResource res = (IResource) anElement;
			return "class".equals(res.getFileExtension()) || !(JavaCore.create(res) != null); //$NON-NLS-1$
		}
		return true;
	}

}