package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.common.navigator.internal.provisional.views.AdaptabilityUtility;

public class CommonWorkingSetAdapterFactory implements IAdapterFactory {

	protected static final Class ISCHEDULINGRULE_CLASS = ISchedulingRule.class;
	protected static final Class IRESOURCE_CLASS = IResource.class;
	

	public CommonWorkingSetAdapterFactory() {
		super();
	}

	public Object getAdapter(Object adaptableObject, Class adapterType) {
		
		if (adaptableObject instanceof ISchedulingRule) {
			if (adapterType == ISCHEDULINGRULE_CLASS)
				return (ISchedulingRule)adaptableObject;
		
		} else if (adaptableObject instanceof IWorkingSet) {
			if (adapterType == ISCHEDULINGRULE_CLASS) {
				IWorkingSet workingSet = (IWorkingSet)adaptableObject;
				IAdaptable[] elements = workingSet.getElements();
				IResource resource = null;
				List resources = new ArrayList();
				for (int x=0; x< elements.length; ++x ) {
					resource = (IResource) AdaptabilityUtility.getAdapter(elements[x], IRESOURCE_CLASS);
					if (resource != null)
						resources.add(resource);
				}
				ISchedulingRule[] rules = new ISchedulingRule[resources.size()];
				rules =(ISchedulingRule[]) resources.toArray(rules);
				return MultiRule.combine(rules) ;
			}
		}
		return null;
	}

	public Class[] getAdapterList() {
		return new Class[]{ISCHEDULINGRULE_CLASS};
	}

}
