package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import org.eclipse.jface.util.Assert;
import org.eclipse.ui.ILocalWorkingSetManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.framework.BundleContext;

public class LocalWorkingSetManager extends AbstractWorkingSetManager implements
		ILocalWorkingSetManager {

	public LocalWorkingSetManager() {
		super(WorkbenchPlugin.getDefault().getBundleContext()); 
	}
	
	public LocalWorkingSetManager(BundleContext context) {
		super(context);
	}

	/**
	 * {@inheritDoc}
	 */
	public void removeWorkingSet(IWorkingSet workingSet) {
		internalRemoveWorkingSet(workingSet);
	}

	/**
	 * {@inheritDoc}
	 */
	public void addRecentWorkingSet(IWorkingSet workingSet) {
		internalAddRecentWorkingSet(workingSet);
	}

	/**
	 * {@inheritDoc}
	 */
	public void saveState(IMemento memento) {
        saveWorkingSetState(memento);
        saveMruList(memento);
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void restoreState(IMemento memento) {
		Assert.isNotNull(memento);
		Assert.isTrue(getWorkingSets().length == 0);
        restoreWorkingSetState(memento);
        restoreMruList(memento);
	}

}
