/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui.util;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager;
import org.eclipse.wst.rdb.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;


public class CatalogUtil {
	private static final String LOADING = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.LOADING"); //$NON-NLS-1$

	public static void load(EObject obj, IProgressMonitor monitor, int task) {
		loadInternal(obj, monitor, task, true);
		Iterator it = obj.eClass().getEAllStructuralFeatures().iterator();
		while(it.hasNext()) {
			EStructuralFeature feature = (EStructuralFeature) it.next();
			if(!feature.isDerived() && !feature.isTransient()) obj.eGet(feature);
		}				
	}

	public static void loadWithoutAttributes(EObject obj, IProgressMonitor monitor, int task) {
		loadInternal(obj, monitor, task, false);
		Iterator it = obj.eClass().getEAllReferences().iterator();
		while(it.hasNext()) {
			EStructuralFeature feature = (EStructuralFeature) it.next();
			if(!feature.isDerived() && !feature.isTransient()) obj.eGet(feature);
		}				
	}

	private static double loadInternal(EObject object, IProgressMonitor monitor, double task, boolean includingAttributes) {
		ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
		Collection c = containmentService.getContainedElements(object);
		
		double acc = 0;
		if(c.size() != 0) {
			double delta = task/c.size();
			Iterator it = c.iterator();
			while(it.hasNext()) {
				EObject child = (EObject) it.next();
				if(containmentService.isDisplayableElement(child)) {
					if(child instanceof ENamedElement) {
						String name = ((ENamedElement) child).getName();
						if(name != null) {
							String type = IDataToolsUIServiceManager.INSTANCE.getLabelService(child).getDisplayType();
							name = "<" + type + "> " + name;  //$NON-NLS-1$//$NON-NLS-2$
							monitor.subTask(LOADING + " " + name); //$NON-NLS-1$
						}
					}
				}
				acc += loadInternal(child, monitor, delta, includingAttributes);
				if(monitor.isCanceled()) return 0.0;
				if(acc >= 1.0) {
					monitor.worked((int) acc);			
					acc = acc - (int) acc;
				}
			}
		}
		else {
			acc = task;
		}

		if(includingAttributes) {
			Iterator it = object.eClass().getEAllStructuralFeatures().iterator();
			while(it.hasNext()) {
				EStructuralFeature feature = (EStructuralFeature) it.next();
				if(!feature.isDerived() && !feature.isTransient()) object.eGet(feature);
			}
		}
		else {
			Iterator it = object.eClass().getEAllReferences().iterator();
			while(it.hasNext()) {
				EStructuralFeature feature = (EStructuralFeature) it.next();
				if(!feature.isDerived() && !feature.isTransient()) object.eGet(feature);
			}
		}
		return acc;
	}
}