/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.fe.internal.ui.actions.popup;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FEWizard;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.AbstractAction;

/**
 * @author ldunnell
 */
public class ForwardEngineerAction extends AbstractAction implements IActionDelegate2
{
	private static ISelection selection;
	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action)
	{
		try
		{
			List list = this.getMultipleSelectionEx(SQLObject.class);
			if (list.size() > 0)
			{	
				Wizard wizard = new FEWizard(list);
				WizardDialog dialog = new WizardDialog(Display.getCurrent()
						.getActiveShell(), wizard);
				dialog.create();
				dialog.open();
				}
		}
		catch(Exception e)
		{
			 e.printStackTrace();
		}
	}
	
    /* (non-Javadoc)
     * @see org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.AbstractAction#setSelection(org.eclipse.jface.viewers.ISelection)
     */
    protected void setSelection(ISelection selection) {
        ForwardEngineerAction.selection = selection;        
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.AbstractAction#getSelection()
     */
    protected ISelection getSelection() {
        return selection;
    }

    /**
	 * @return the selected object - The object will have to be adapted by subclasses
	 */
	protected List getMultipleSelectionEx (Class type)
	{
		List linkedList = new LinkedList ();
		if (getSelection () instanceof IStructuredSelection)
		{
			for (Iterator i = ((IStructuredSelection)getSelection ()).iterator(); i.hasNext();)
			{
				Object nextSelected = i.next();
				if (type.isAssignableFrom(nextSelected.getClass()))
				{
					linkedList.add(nextSelected);
				}
			}
		}
		return linkedList;
	}

}
