/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.ui.properties.internal.provisional;

/**
 * An abstract implementation of a section in a tab that overrides the tabs that
 * are provided by the tabbed property registry with a new list of tabs.
 * 
 * @author Anthony Hunter <a
 *         href="mailto:anthonyh@ca.ibm.com">anthonyh@ca.ibm.com </a>
 */
public class AbstractDynamicTabListPropertySection
	extends AbstractPropertySection
	implements IDynamicTabListSection {

	/**
	 * @see org.eclipse.wst.common.ui.properties.internal.provisional.IDynamicTabListSection#getTabs()
	 */
	public IDynamicTabItem[] getTabs() {
		return null;
	}

	/**
	 * @see org.eclipse.wst.common.ui.properties.internal.provisional.IDynamicTabListSection#selectTab(int)
	 */
	public void selectTab(int tab) {
		/* empty default implementation */
	}
}
