/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.ui;

import org.eclipse.core.runtime.*;
import org.eclipse.ui.plugin.*;
import org.eclipse.wst.rdb.data.internal.ui.editor.*;

public class DataUIPlugin extends AbstractUIPlugin
{
    //The shared instance.
    private static DataUIPlugin plugin;
    
    public static final String PLUGIN_ID = "org.eclipse.wst.rdb.data.ui"; //$NON-NLS-1$

    protected TableDataEditorActionBarContributor tableDataEditorContributor;

    /**
     * The constructor.
     */
    public DataUIPlugin()
    {
        super();
        plugin = this;
    }

    /**
     * Returns the shared instance.
     */
    public static DataUIPlugin getDefault()
    {
        return plugin;
    }
    public TableDataEditorActionBarContributor getTableDataEditorContributor() {
        return tableDataEditorContributor;
    }
    public void setTableDataEditorContributor(
            TableDataEditorActionBarContributor tableDataEditorContributor) {
        this.tableDataEditorContributor = tableDataEditorContributor;
    }
    
	/**
	 * Method writeLog.
	 * @param severity - the severity; one of IStatus.OK, IStatus.ERROR, IStatus.INFO, or IStatus.WARNING
	 * @param code - the plug-in-specific status code, or OK
	 * @param message - a human-readable message, localized to the current locale
	 * @param exception- a low-level exception, or null if not applicable
	 */
	public void writeLog(int severity, int code, String message, Throwable exception) {
		if (message == null)
			message = ""; //$NON-NLS-1$
		getLog().log(
				new Status(severity, getBundle().getSymbolicName(), code, message, exception));
	}
}
