/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.definition;

import java.util.Iterator;
import java.util.List;

import org.eclipse.wst.rdb.internal.core.rte.DDLGenerator;
import org.eclipse.wst.rdb.internal.core.rte.DDLParser;
import org.eclipse.wst.rdb.internal.core.rte.DeltaDDLGenerator;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogProvider;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.PredefinedDataType;


public interface DatabaseDefinition {
	public String getProduct();
	public String getProductDisplayString();
	public String getVersion();
	public String getVersionDisplayString();
	public String getDescription();
	public DataModelElementFactory getDataModelElementFactory();

	public Iterator getPredefinedDataTypes();
	public Iterator getSequenceSupportedPredefinedDataTypes();
	
	public boolean supportsSchema();
	public boolean supportsIdentityColumns();
	public boolean supportsComputedColumns();
	public boolean supportsSequence();
	public boolean supportsMQT();
	public boolean supportsDeferrableConstraints();
	public boolean supportsInformationalConstraints();
	public boolean supportsClusteredIndexes();
	public boolean isUniqueKeyNullable();
	public List  getParentDeleteDRIRules();
	public List  getParentUpdateDRIRules();
	public boolean supportsConstraints();
	public int queryMaxCommentLength();
	public int queryMaxIdentifierLength();
	public int queryMaxCheckExpression();
	public int queryTriggerMaxReferencePartLength();
	public int queryTriggerMaxActionBodyLength();
	public int queryStoredProcedureMaxActionBodyLength();
	public boolean supportsStoredProcedureNullInputAction();
	public boolean supportsNicknames();
	public boolean supportsNicknameConstraints();
	public boolean supportsNicknameIndex();
	public boolean supportsQuotedDML();
	public boolean supportsQuotedDDL();

	public boolean supportsAlias();
	public boolean supportsSynonym();
	public boolean supportsTriggers();
	public boolean supportsTriggerTypes();
	public boolean supportsInsteadOfTrigger();	
	public boolean supportsPerColumnUpdateTrigger();
	public boolean supportsTriggerReferencesClause();
	public boolean supportsRowTriggerReference();
	public boolean supportsTableTriggerReference();
	public boolean supportTriggerWhenClause();
	public boolean supportsTriggerGranularity();
	public boolean supportsUserDefinedType();
	
	public boolean supportsSnapshotViews();
	public boolean supportsViewTriggers();

	public boolean isKeyConstraintSupported(DataType dataType);
	
	public String getIdentifierQuoteString();
	public String getHostVariableMarker();
	public boolean supportsHostVariableMarker();
	public boolean supportsCastExpression();
	public boolean supportsDefaultKeywordForInsertValue();
	public boolean supportsExtendedGrouping();
	public boolean supportsTableAliasInDelete();
	
	public List getProcedureLanguageType();
	public List getFunctionLanguageType();
	public boolean supportsSQLStatement();
	
	public List getSQLKeywords();
	public List getSQLOperators();
	public boolean isSQLKeyword(String word);
	public boolean isSQLOperator(String word);
	
	public int getMaximumIdentifierLength();
	
	public List getPredefinedDataTypeDefinitionsByJDBCEnumType(int jdbcEnumType);
	public List getPredefinedDataTypesByJDBCEnumType(int jdbcEnumType);
	
	public PredefinedDataTypeDefinition getPredefinedDataTypeDefinition(String dataTypeName);
	public PredefinedDataType getPredefinedDataType(String dataTypeName);
	public PredefinedDataType getPredefinedDataType(PredefinedDataTypeDefinition predefinedDataTypeDefinition);
	
	public PredefinedDataTypeDefinition getPredefinedDataTypeDefinitionByNameAndJDBCEnumType(String dataTypeName, int jdbcEnumType);
	public PredefinedDataType getPredefinedDataTypeByNameAndJDBCEnumType(String dataTypeName, int jdbcEnumType);
	
	public String getPredefinedDataTypeFormattedName(PredefinedDataType predefinedDataType);
		
	public DDLParser getDdlParser();

	public ICatalogProvider getDatabaseCatalogProvider();

	public DDLGenerator getDDLGenerator();
	public DeltaDDLGenerator getDeltaDDLGenerator();
}
