/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.server.geronimo.core.internal.model;

import org.eclipse.jst.server.geronimo.core.internal.xml.IMemento;
import org.eclipse.jst.server.geronimo.core.internal.xml.XMLMemento;
/**
 * Sample resource-ref definition
 * 
 *      <resource-env-ref>
 *	       <ref-name>jms/topic/weather</ref-name>
 *	       <message-destination-link>WeatherTopic</message-destination-link>
 *      </resource-env-ref>
 * 
 */
public class ResourceEnvRef {
	
	public static final String RESOURCE_ENV_REF = "resource-env-ref";
	public static final String RESOURCE_ENV_REF_QUALIFIED = "naming:resource-env-ref";
	private static final String REF_NAME = "ref-name";
	private static final String REF_NAME_QUALIFIED = "naming:ref-name";
	private static final String MSG_DESTINATION_LINK = "message-destination-link";
	private static final String MSG_DESTINATION_LINK_QUALIFIED = "naming:message-destination-link";

	private XMLMemento memento;

	
	public static ResourceEnvRef createResourceRef(WebAppDeploymentPlan deployPlan, String refName, String messageDestinationLink)
	{
		XMLMemento refMemento=(XMLMemento)deployPlan.getRootMemento().createChild(RESOURCE_ENV_REF);
		ResourceEnvRef ref=new ResourceEnvRef(refMemento);
		ref.setRefName(refName);
		if(messageDestinationLink!=null)
			ref.setMsgDestLink(messageDestinationLink);
		return ref;
	}	
	

	public String getRefName() {
		// Load the ref name
		IMemento refName=memento.getChild(REF_NAME);
		// could not find, look for a qualified ref name
		if(refName==null)
			refName=memento.getChild(REF_NAME_QUALIFIED);
		
		String data;
		if(refName==null)
			data="";
		else
			data=refName.getTextData();
		return data;
	}

	public void setRefName(String refNameText) {
		// Load the ref name
		IMemento refName=memento.getChild(REF_NAME);
		// could not find, look for a qualified ref name
		if(refName==null)
			refName=memento.getChild(REF_NAME_QUALIFIED);
		// still could not find, create a new ref name
		if(refName==null)
			refName=memento.createChild(REF_NAME);
			
		if(refName instanceof XMLMemento)
		{
			XMLMemento xmlRefName=(XMLMemento)refName;

			if(refNameText==null || refNameText.length()==0)
				memento.removeChild(xmlRefName);
			else
				xmlRefName.setTextData(refNameText);
		}
		else
			throw new IllegalStateException();
	}

	public String getMsgDestLink() {
		// Load the resource link
		IMemento msgDestLink=memento.getChild(MSG_DESTINATION_LINK);
		// could not find, look for a qualified resource link
		if(msgDestLink==null)
			msgDestLink=memento.getChild(MSG_DESTINATION_LINK_QUALIFIED);
		
		String data;
		if(msgDestLink==null)
			data="";
		else
			data=msgDestLink.getTextData();
		return data;
	}

	public void setMsgDestLink(String msgDestLinkText) {
		// Load the resource link
		IMemento msgDestLink=memento.getChild(MSG_DESTINATION_LINK);
		// could not find, look for a qualified resource link
		if(msgDestLink==null)
			msgDestLink=memento.getChild(MSG_DESTINATION_LINK_QUALIFIED);
		// still could not find, create a new resource link
		if(msgDestLink==null)
			msgDestLink=memento.createChild(MSG_DESTINATION_LINK);
			
		if(msgDestLink instanceof XMLMemento)
		{
			XMLMemento xmlMsgDestLink=(XMLMemento)msgDestLink;

			if(msgDestLinkText==null || msgDestLinkText.length()==0)
				memento.removeChild(xmlMsgDestLink);
			else
				xmlMsgDestLink.setTextData(msgDestLinkText);
		}
		else
			throw new IllegalStateException();
	}


	
	public ResourceEnvRef(XMLMemento source)
	{
		memento=source;
	}	

	public boolean equals(Object otherObject)
	{
		if(!(otherObject.getClass().equals(this.getClass())))
			return false;
		ResourceEnvRef other=(ResourceEnvRef)otherObject;
		return (this.getRefName().equals(other.getRefName())
			 && this.getMsgDestLink().equals(other.getMsgDestLink()));
		
	}

	public XMLMemento getMemento() {
		return memento;
	}
}
