/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import java.text.MessageFormat;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

/**
 * @author ljulien
 */
public class DeleteServerAction extends AbstractAction
{
    private static final String TITLE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.DELETE_CONNECTION_TITLE");
    private static final String MANY = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.DELETE_CONNECTION_MANY");
    private static final String ONE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.DELETE_CONNECTION_ONE");
    private static final String COMA = ",";
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";
    
    private ISelection selection;

    private void removeConnectionInfo (ConnectionInfo info)
    {
        if (info.getSharedConnection() != null)
        {
            info.removeSharedConnection();
        }
        if (info.getSharedDatabase() != null)
        {
            info.removeSharedDatabase();
        }
        connectionManager.removeConnectionInfo(info.getName());
    }
    
    private String getMessage (String connectionName, IProject [] projects)
    {
        StringBuffer projectsName = new StringBuffer ();
        for (int i = 0, n = projects.length; i < n; i++)
        {
            projectsName.append(i < n - 1 ? QUOTE + projects[i].getName() + QUOTE + COMA + SPACE : QUOTE + projects[i].getName() + QUOTE);
        }
        return MessageFormat.format(projects.length == 1 ? ONE : MANY, new String [] {projectsName.toString(), connectionName});
    }
    
    /**
     * @see org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.AbstractAction#setSelection(org.eclipse.jface.viewers.ISelection)
     */
    protected void setSelection(ISelection selection)
    {
        this.selection = selection;
    }

    /**
     * @see org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.AbstractAction#getSelection()
     */
    protected ISelection getSelection()
    {
        return this.selection;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action)
    {
        IConnectionNode connection = (IConnectionNode) ((IStructuredSelection) selection).getFirstElement();
        IProject [] projects = connection.getConnectionInfo().getDependentProjects();
        if (projects.length != 0)
        {
            if (MessageDialog.openConfirm(Display.getDefault().getActiveShell(), TITLE, getMessage (connection.getDisplayName(), projects)))
            {
                removeConnectionInfo (connection.getConnectionInfo());
            }
        }
        else
        {
            removeConnectionInfo (connection.getConnectionInfo());
        }
    }
}
