/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import java.io.IOException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.core.internal.ui.util.CatalogUtil;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.server.internal.ui.util.ServerUIDebugOptions;
import org.eclipse.wst.rdb.server.internal.ui.util.logging.Logger;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;


/**
 * @author ljulien
 */
public class UpdateOfflineItems extends AbstractAction
{
    private static final String JOB_NAME = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.UPDATE_OFFLINE");
    private static final ISchedulingRule MUTEX = new ISchedulingRule()
    {
        public boolean isConflicting(ISchedulingRule rule)
        {
            return rule == this;
        }
        public boolean contains(ISchedulingRule rule)
        {
            return rule == this;
        }
    };

    private ISelection selection;

    protected void setSelection(ISelection selection)
    {
        this.selection = selection;
    }

    protected ISelection getSelection()
    {
        return this.selection;
    }

    public void run(IAction action)
    {
        IConnectionNode connection = (IConnectionNode) ((IStructuredSelection) selection).getFirstElement();
        Database database = connection.getConnectionInfo().getSharedDatabase();
        if (database != null)
        {
    		Job j = new UpdateJob(connection, database);
       		j.setUser(true);
       		j.schedule();
        }
    }
    
    private class UpdateJob extends Job
    {
        private Database database;
        private IConnectionNode connection;

        public UpdateJob(IConnectionNode connection, Database database)
        {
            super(UpdateOfflineItems.JOB_NAME);
            this.connection = connection;
            this.database = database;
            setRule(MUTEX);
        }

        public boolean belongsTo(Object family)
        {
            if (family == UpdateOfflineItems.JOB_NAME)
            {
                return true;
            }
            return false;
        }

        public IStatus run(IProgressMonitor monitor)
        {
            try
            {
            	monitor.beginTask(JOB_NAME + " - " + connection.getName(), 100);
            	monitor.worked(5);
            	CatalogUtil.load(database, monitor, 90);
            	if(!monitor.isCanceled()) {
            		monitor.subTask("");
            		connection.getConnectionInfo().cacheDatabase(database);
            	}
            }
            catch (IOException e)
            {
                Logger.log(this, e, ServerUIDebugOptions.SERVER_EXPLORER_LOG);
                return Status.CANCEL_STATUS;
            }
            finally {
            	monitor.done();
            }
            
            if (monitor.isCanceled())
            {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }

}
