/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.providers.decorators;

import java.text.MessageFormat;

import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.server.internal.ui.services.IServerStatusDecorationService;


/**
 * @author ljulien
 */
public class ServerStatusDecoration extends LabelProvider implements ILightweightLabelDecorator, IServerStatusDecorationService
{
    private static final String PREFIX = " [{0} {1}]"; //$NON-NLS-1$

    /**
     * @see org.eclipse.jface.viewers.ILightweightLabelDecorator#decorate(java.lang.Object, org.eclipse.jface.viewers.IDecoration)
     */
    public void decorate(Object element, IDecoration decoration)
    {
        IConnectionNode server = (IConnectionNode) element;
        String type = server.getConnectionInfo().getDatabaseDefinition().getProduct();
        String version = server.getConnectionInfo().getDatabaseDefinition().getVersion();
        boolean isConnected = server.isConnected();
        if (isConnected)
        {
            decoration.addSuffix(MessageFormat.format(PREFIX, new String[] { type, version }));
        }
        else
        {
            
        }
    }

    /**
     * @see org.eclipse.wst.rdb.core.internal.ui.explorer.providers.decorators.IDecorationService#refreshDecoration(org.eclipse.core.runtime.IAdaptable[])
     */
    public void refreshDecoration(Object[] elements)
    {
        fireLabelChangedEvent(new LabelProviderChangedEvent(this, elements));
    }

    /**
     * Will notify the Model Explorer to redecorate
     * @param event
     */
    protected void fireLabelChangedEvent(final LabelProviderChangedEvent event)
    {
        Display.getDefault().asyncExec(new Runnable()
        {
            public void run()
            {
                fireLabelProviderChanged(event);
            }
        });
    }
}
