/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.performance;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class TestInsertPerformance
extends PerformanceTestCase {
    float total = 0.0f;
    long thisTime = 0L;
    int nTrials = 3;

    public TestInsertPerformance(String name) {
        super(name);
    }

    protected void doTestBigTable(String filename) throws IOException {
        int i = 0;
        while (i < this.nTrials) {
            this.doTestBigTable(i, filename);
            if (i > 0) {
                this.total += (float)this.thisTime;
            }
            ++i;
        }
        System.out.println();
        System.out.println("          Average Time to insert 1000 row table in " + filename + ": " + this.total / (float)(this.nTrials - 1));
        System.out.println("          (used " + (this.nTrials - 1) + " trials)");
    }

    protected void doTestBigTable(int i, String filename) throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        IStructuredModel model = modelManager.getModelForEdit(filename, inStream, null);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        InputStream textStream = ((Object)((Object)this)).getClass().getResourceAsStream("bigTable.txt");
        String tableText = this.readInputStream(new InputStreamReader(textStream));
        long startTime = System.currentTimeMillis();
        structuredDocument.replaceText((Object)this, 80, 0, tableText);
        long endTime = System.currentTimeMillis();
        this.thisTime = endTime - startTime;
        model.releaseFromEdit();
        inStream.close();
        textStream.close();
    }

    private String readInputStream(InputStreamReader inputStreamReader) throws IOException {
        int numRead = 0;
        StringBuffer buffer = new StringBuffer();
        char[] tBuff = new char[4000];
        while ((numRead = inputStreamReader.read(tBuff, 0, tBuff.length)) != -1) {
            buffer.append(tBuff, 0, numRead);
        }
        return buffer.toString();
    }

    public void testHTMLInsert() throws IOException {
        this.startMeasuring();
        this.doTestBigTable("plainTemplate.html");
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testXMLInsert() throws IOException {
        this.startMeasuring();
        this.doTestBigTable("plainTemplate.xml");
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testJSPInsert() throws IOException {
        this.startMeasuring();
        this.doTestBigTable("plainTemplate.jsp");
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }
}

