/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.performance;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TestModelPerformanceOLD
extends TestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public TestModelPerformanceOLD(String name) {
        super(name);
    }

    public void testStructuredModel100JSP() throws IOException {
        this.doStructuredModelTest("Test100K.jsp");
    }

    public void testStructuredModel100HTML() throws IOException {
        this.doStructuredModelTest("Test100K.html");
    }

    public void testStructuredModel100XML() throws IOException {
        this.doStructuredModelTest("Test100K.xml");
    }

    public void testStructuredModel300JSP() throws IOException {
        this.doStructuredModelTest("Test300K.jsp");
    }

    public void testStructuredModel300HTML() throws IOException {
        this.doStructuredModelTest("Test300K.html");
    }

    public void testStructuredModel300XML() throws IOException {
        this.doStructuredModelTest("Test300K.xml");
    }

    protected int countNodes(Node node) {
        int count = 1;
        Node child = node.getFirstChild();
        while (child != null) {
            count += this.countNodes(child);
            child = child.getNextSibling();
        }
        return count;
    }

    protected void doStructuredModelTest(String filename) throws IOException {
        int nodeCount = 0;
        int nFactories = 0;
        int nPropagatingFactories = 0;
        int nEmbeddedFactories = 0;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        System.out.println();
        float total = 0.0f;
        int nTrials = 101;
        int i = 0;
        while (i < nTrials) {
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
            long startTime = System.currentTimeMillis();
            IStructuredModel model = modelManager.getModelForEdit(filename, inStream, null);
            long endTime = System.currentTimeMillis();
            long thisTime = endTime - startTime;
            if (i > 0) {
                total += (float)thisTime;
            } else {
                IDOMDocument document = ((IDOMModel)model).getDocument();
                nodeCount = this.countNodes((Node)document);
                nFactories = this.countFactories(model);
                nPropagatingFactories = this.countPropatingFactories((Document)document);
                nEmbeddedFactories = this.countEmbeddedFactories((Document)document);
            }
            model.releaseFromEdit();
            inStream.close();
            ++i;
        }
        System.out.println();
        System.out.println("          Average Time to create model for " + filename + ": " + total / (float)(nTrials - 1));
        System.out.println("          (used " + (nTrials - 1) + " trials)");
        System.out.println("          (N Nodes == " + nodeCount + ")");
        System.out.println("          (N Factories == " + nFactories + ")");
        System.out.println("          (N PropagatingFactories == " + nPropagatingFactories + ")");
        System.out.println("          (N EmbeddedFactories == " + nEmbeddedFactories + ")");
    }

    private int countEmbeddedFactories(Document document) {
        int result = 0;
        if (document instanceof IDOMDocument) {
            EmbeddedTypeHandler embeddedHandler;
            PageDirectiveAdapter pageDirectiveAdapter;
            IDOMDocument xmlDocument = (IDOMDocument)document;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((pageDirectiveAdapter = (PageDirectiveAdapter)xmlDocument.getExistingAdapter((Object)clazz)) != null && (embeddedHandler = pageDirectiveAdapter.getEmbeddedType()) != null) {
                result = embeddedHandler.getAdapterFactories().size();
            }
        }
        return result;
    }

    private int countPropatingFactories(Document document) {
        int result = 0;
        if (document instanceof IDOMDocument) {
            IDOMDocument iDOMDocument = (IDOMDocument)document;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.PropagatingAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PropagatingAdapter pAdapter = (PropagatingAdapter)iDOMDocument.getAdapterFor((Object)clazz);
            result = pAdapter.getAdaptOnCreateFactories().size();
        }
        return result;
    }

    private int countFactories(IStructuredModel model) {
        FactoryRegistry reg = model.getFactoryRegistry();
        int result = reg.getFactories().size();
        return result;
    }
}

