/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.tests.performance;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jst.j2ee.tests.performance.PerformanceTestCaseWrapper;
import org.eclipse.jst.j2ee.tests.performance.PerformanceTestObject;
import org.eclipse.jst.j2ee.tests.performance.TestCaseSAXParser;
import org.eclipse.wst.common.tests.BaseTestCase;

public abstract class BasePerformanceTestCase
extends BaseTestCase {
    protected static Map performanceClass = null;
    static ClassLoader clazzLoader = null;
    protected static String file = null;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        performanceClass = null;
        return BasePerformanceTestCase.createTestSuites();
    }

    private static Test createTestSuites() {
        BasePerformanceTestCase.createPerformanceClass();
        TestSuite suite = new TestSuite();
        Iterator iter = performanceClass.keySet().iterator();
        while (iter.hasNext()) {
            Class clazz = (Class)iter.next();
            List methodList = (List)performanceClass.get(clazz);
            int x = 0;
            while (x < methodList.size()) {
                PerformanceTestObject testObject = (PerformanceTestObject)methodList.get(x);
                Test test = BasePerformanceTestCase.createTest(clazz, testObject.getName());
                if (test instanceof BaseTestCase) {
                    suite.addTest((Test)new PerformanceTestCaseWrapper((BaseTestCase)test, testObject.getTagging(), testObject.getShortName()));
                }
                ++x;
            }
        }
        return suite;
    }

    public static Test createTest(Class theClass, String name) {
        Object test;
        Constructor constructor;
        try {
            constructor = BasePerformanceTestCase.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return BasePerformanceTestCase.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name) or TestCase()");
        }
        try {
            if (constructor.getParameterTypes().length == 0) {
                test = constructor.newInstance(new Object[0]);
                if (test instanceof TestCase) {
                    ((TestCase)test).setName(name);
                }
            } else {
                test = constructor.newInstance(name);
            }
        }
        catch (InstantiationException e) {
            return BasePerformanceTestCase.warning("Cannot instantiate test case: " + name + " (" + BasePerformanceTestCase.exceptionToString(e) + ")");
        }
        catch (InvocationTargetException e) {
            return BasePerformanceTestCase.warning("Exception in constructor: " + name + " (" + BasePerformanceTestCase.exceptionToString(e.getTargetException()) + ")");
        }
        catch (IllegalAccessException e) {
            return BasePerformanceTestCase.warning("Cannot access test case: " + name + " (" + BasePerformanceTestCase.exceptionToString(e) + ")");
        }
        return (Test)test;
    }

    private static Test warning(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                1.fail((String)message);
            }
        };
    }

    public static Constructor getTestConstructor(Class theClass) throws NoSuchMethodException {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] args = classArray;
        try {
            return theClass.getConstructor(args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return theClass.getConstructor(new Class[0]);
        }
    }

    private static String exceptionToString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }

    public static Map getPerformanceClass() {
        if (performanceClass == null) {
            BasePerformanceTestCase.createPerformanceClass();
        }
        return performanceClass;
    }

    protected static void createPerformanceClass() {
        if (performanceClass == null) {
            performanceClass = new TestCaseSAXParser().doLoad(new File(file));
        }
    }

    public static ClassLoader getClassLoader() {
        return clazzLoader;
    }

    public static void setClassLoader(ClassLoader clazzLoader) {
        BasePerformanceTestCase.clazzLoader = clazzLoader;
    }

    public static String getFile() {
        return file;
    }

    public static void setFile(String file) {
        BasePerformanceTestCase.file = file;
    }

    protected static void addPerformanceTest(TestSuite suite, BaseTestCase test, int tagging, String shortName) {
        PerformanceTestCaseWrapper testCase = new PerformanceTestCaseWrapper(test, tagging, shortName);
        suite.addTest((Test)testCase);
    }
}

