/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.tests.performance;

import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.wst.common.tests.BaseTestCase;

public class PerformanceTestCaseWrapper
extends PerformanceTestCase {
    protected BaseTestCase fTest;
    public static final int NONE = 0;
    public static final int LOCAL = 1;
    public static final int GLOBAL = 2;
    private boolean tagAsGlobalSummary;
    private boolean tagAsSummary;
    private String shortName;
    public static final int ITERATIONS = 10;

    public PerformanceTestCaseWrapper(BaseTestCase test, int tagging, String shortName) {
        this.fTest = test;
        this.tagAsGlobalSummary = (tagging & 2) != 0;
        this.tagAsSummary = (tagging & 1) != 0;
        this.shortName = shortName;
    }

    public int countTestCases() {
        return this.fTest.countTestCases();
    }

    public String toString() {
        return this.fTest.toString();
    }

    public Test getTest() {
        return this.fTest;
    }

    protected void setUp() throws Exception {
        this.fTest.setUpTest();
    }

    protected void basicSetUp() throws Exception {
        Performance performance = Performance.getDefault();
        this.fPerformanceMeter = performance.createPerformanceMeter(performance.getDefaultScenarioId((TestCase)this.fTest));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runBare() throws Throwable {
        this.basicSetUp();
        this.tagIfNecessary(this.shortName, Dimension.CPU_TIME);
        try {
            int i = 0;
            while (i < 10) {
                this.setUp();
                this.startMeasuring();
                this.runTest();
                this.stopMeasuring();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.commitMeasurements();
            this.assertPerformance();
            this.tearDown();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.commitMeasurements();
        this.assertPerformance();
        this.tearDown();
    }

    protected void runTest() throws Throwable {
        this.fTest.runCoreTest();
    }

    protected void tearDown() throws Exception {
        this.fTest.tearDownTest();
    }

    public void setName(String name) {
        this.fTest.setName(name);
    }

    public String getName() {
        return this.fTest.getName();
    }

    private boolean shouldGloballyTag() {
        return this.tagAsGlobalSummary;
    }

    private boolean shouldLocallyTag() {
        return this.tagAsSummary;
    }

    public void tagIfNecessary(String shortName, Dimension dimension) {
        if (this.shouldGloballyTag()) {
            this.tagAsGlobalSummary(shortName, dimension);
        }
        if (this.shouldLocallyTag()) {
            this.tagAsSummary(shortName, dimension);
        }
    }

    public void tagIfNecessary(String shortName, Dimension[] dimensions) {
        if (this.shouldGloballyTag()) {
            this.tagAsGlobalSummary(shortName, dimensions);
        }
        if (this.shouldLocallyTag()) {
            this.tagAsSummary(shortName, dimensions);
        }
    }
}

