/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.widgets.runtime;

import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.ui.common.ValidationUtils;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.ClientRuntimeSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.ProjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.RuntimeServerSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionListChoices;

public class ServerRuntimeSelectionWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private String createPluginId_ = "org.eclipse.jst.ws.creation.ui";
    private String INFOPOP_PWRS_GROUP_SERVICE = "PWRS0002";
    private RuntimeServerSelectionWidget runtimeWidget_;
    private ProjectSelectionWidget projectWidget_;
    private ClientRuntimeSelectionWidget clientWidget_;
    private TextModifyListener textListener_;
    private MessageUtils msgUtils_;
    private boolean isClientWidgetVisible_ = true;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.msgUtils_ = new MessageUtils(String.valueOf(this.pluginId_) + ".plugin", (Object)this);
        UIUtils uiUtils = new UIUtils(this.msgUtils_, this.createPluginId_);
        ScrolledComposite scroller = new ScrolledComposite(parent, 768);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        Composite root = uiUtils.createComposite((Composite)scroller, 1);
        scroller.setContent((Control)root);
        Composite textComposite = uiUtils.createComposite(root, 1, 0, 0);
        this.createMessageText(textComposite, this.msgUtils_.getMessage("MSG_GENERAL_PROJECT_AND_EAR", (Object[])new String[]{this.msgUtils_.getMessage("MSG_SERVICE_SUB")}));
        this.createMessageText(textComposite, this.msgUtils_.getMessage("MSG_EAR_PROJECT_WILL_BE_CREATED"));
        Composite serverComp = uiUtils.createComposite(root, 1, 5, 0);
        Group serverGroup = uiUtils.createGroup(serverComp, "LABEL_SELECTION_VIEW_TITLE", null, this.INFOPOP_PWRS_GROUP_SERVICE, 2, 5, 5);
        this.runtimeWidget_ = new RuntimeServerSelectionWidget(false);
        this.runtimeWidget_.addControls((Composite)serverGroup, statusListener);
        this.textListener_ = new TextModifyListener();
        this.runtimeWidget_.addModifyListener((ModifyListener)this.textListener_);
        this.projectWidget_ = new ProjectSelectionWidget();
        this.projectWidget_.addControls((Composite)serverGroup, statusListener);
        this.clientWidget_ = new ClientRuntimeSelectionWidget();
        this.clientWidget_.addControls(root, statusListener);
        Point size = root.computeSize(-1, -1);
        scroller.setMinSize(size);
        root.setSize(size);
        scroller.setLayoutData((Object)new GridData(1808));
        return this;
    }

    public void setGenerateProxy(Boolean value) {
        this.clientWidget_.setVisible(value.booleanValue());
        this.isClientWidgetVisible_ = value;
    }

    public TypeRuntimeServer getServiceTypeRuntimeServer() {
        return this.runtimeWidget_.getTypeRuntimeServer();
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer ids) {
        this.runtimeWidget_.removeModifyListener((ModifyListener)this.textListener_);
        this.runtimeWidget_.setTypeRuntimeServer(ids);
        this.projectWidget_.setTypeRuntimeServer(ids);
        this.runtimeWidget_.addModifyListener((ModifyListener)this.textListener_);
    }

    public TypeRuntimeServer getClientTypeRuntimeServer() {
        return this.clientWidget_.getClientTypeRuntimeServer();
    }

    public void setClientTypeRuntimeServer(TypeRuntimeServer ids) {
        this.clientWidget_.setClientTypeRuntimeServer(ids);
    }

    public SelectionListChoices getServiceProject2EARProject() {
        return this.projectWidget_.getProjectChoices();
    }

    public void setServiceProject2EARProject(SelectionListChoices serviceProject2EARProject) {
        this.projectWidget_.setProjectChoices(serviceProject2EARProject);
    }

    public SelectionListChoices getRuntime2ClientTypes() {
        return this.clientWidget_.getRuntime2ClientTypes();
    }

    public void setRuntime2ClientTypes(SelectionListChoices runtime2ClientTypes) {
        this.clientWidget_.setRuntime2ClientTypes(runtime2ClientTypes);
    }

    public String getServiceJ2EEVersion() {
        return this.runtimeWidget_.getJ2EEVersion();
    }

    public void setServiceJ2EEVersion(String j2eeVersion) {
        this.runtimeWidget_.setJ2EEVersion(j2eeVersion);
        this.projectWidget_.setJ2EEVersion(j2eeVersion);
    }

    public String getClientJ2EEVersion() {
        return this.clientWidget_.getJ2EEVersion();
    }

    public void setClientJ2EEVersion(String j2eeVersion) {
        this.clientWidget_.setJ2EEVersion(j2eeVersion);
    }

    public boolean getServiceNeedEAR() {
        return this.projectWidget_.getNeedEAR();
    }

    public void setServiceNeedEAR(boolean b) {
        this.projectWidget_.setNeedEAR(b);
    }

    public boolean getClientNeedEAR() {
        return this.clientWidget_.getClientNeedEAR();
    }

    public void setClientNeedEAR(boolean b) {
        this.clientWidget_.setClientNeedEAR(b);
    }

    public String getServiceComponentName() {
        return this.projectWidget_.getComponentName();
    }

    public void setServiceComponentName(String name) {
        this.projectWidget_.setComponentName(name);
    }

    public String getServiceEarComponentName() {
        return this.projectWidget_.getEarComponentName();
    }

    public void setServiceEarComponentName(String name) {
        this.projectWidget_.setEarComponentName(name);
    }

    public void setServiceComponentType(String type) {
        this.projectWidget_.setComponentType(type);
    }

    public String getClientComponentName() {
        return this.clientWidget_.getClientComponentName();
    }

    public void setClientComponentName(String name) {
        this.clientWidget_.setClientComponentName(name);
    }

    public String getClientEarComponentName() {
        return this.clientWidget_.getClientEarComponentName();
    }

    public void setClientEarComponentName(String name) {
        this.clientWidget_.setClientEarComponentName(name);
    }

    public String getClientComponentType() {
        return this.clientWidget_.getClientComponentType();
    }

    public void setComponentType(String type) {
        this.clientWidget_.setClientComponentType(type);
    }

    public String getServiceProjectName() {
        return this.projectWidget_.getProjectName();
    }

    public String getServiceEarProjectName() {
        return this.projectWidget_.getEarProjectName();
    }

    public String getClientProjectName() {
        return this.clientWidget_.getClientProjectName();
    }

    public String getClientEarProjectName() {
        return this.clientWidget_.getClientEarProjectName();
    }

    public Status getStatus() {
        IProject serviceProj;
        Status serviceStatus = this.runtimeWidget_.getStatus();
        Status projectStatus = this.projectWidget_.getStatus();
        Status clientStatus = this.clientWidget_.getStatus();
        SimpleStatus finalStatus = new SimpleStatus("");
        if (serviceStatus.getSeverity() == 4) {
            finalStatus = serviceStatus;
        } else if (clientStatus.getSeverity() == 4) {
            if (this.isClientWidgetVisible_) {
                finalStatus = clientStatus;
            }
        } else if (projectStatus.getSeverity() == 4) {
            finalStatus = projectStatus;
        }
        ValidationUtils valUtils = new ValidationUtils();
        String serviceEARName = this.projectWidget_.getEarProjectName();
        String serviceProjName = this.projectWidget_.getProjectName();
        String serviceServerFactoryId = this.runtimeWidget_.getTypeRuntimeServer().getServerId();
        String serviceJ2EElevel = this.runtimeWidget_.getJ2EEVersion();
        String serviceComponentName = this.projectWidget_.getComponentName();
        String serviceEARComponentName = this.projectWidget_.getEarComponentName();
        Status serviceProjectStatus = valUtils.validateProjectTargetAndJ2EE(serviceProjName, serviceComponentName, serviceEARName, serviceEARComponentName, serviceServerFactoryId, serviceJ2EElevel);
        if (serviceProjectStatus.getSeverity() == 4) {
            finalStatus = serviceProjectStatus;
        }
        if (serviceProjName != null && serviceProjName.length() > 0 && (serviceProj = ProjectUtilities.getProject((String)serviceProjName)).exists()) {
            String webServiceTypeId;
            String webServiceRuntimeId = this.runtimeWidget_.getTypeRuntimeServer().getRuntimeId();
            boolean isEJBRequired = WebServiceRuntimeExtensionUtils.requiresEJBProject((String)webServiceRuntimeId, (String)(webServiceTypeId = this.runtimeWidget_.getTypeRuntimeServer().getTypeId()));
            if (isEJBRequired && serviceComponentName != null && serviceComponentName.length() > 0 && !J2EEUtils.isEJBComponent((IProject)serviceProj, (String)serviceComponentName)) {
                finalStatus = new SimpleStatus("", this.msgUtils_.getMessage("MSG_INVALID_EJB_PROJECT", (Object[])new String[]{serviceProjName}), 4);
            }
            if (!isEJBRequired && serviceComponentName != null && serviceComponentName.length() > 0 && !J2EEUtils.isWebComponent((IProject)serviceProj, (String)serviceComponentName)) {
                finalStatus = new SimpleStatus("", this.msgUtils_.getMessage("MSG_INVALID_WEB_PROJECT", (Object[])new String[]{serviceProjName}), 4);
            }
        }
        if (this.isClientWidgetVisible_) {
            String clientEARName = this.clientWidget_.getClientEarProjectName();
            String clientProjName = this.clientWidget_.getClientProjectName();
            String clientComponentName = this.clientWidget_.getClientComponentName();
            String warning_msg = this.getEARProjectWarningMessage(serviceEARName, clientEARName);
            if (serviceComponentName.equalsIgnoreCase(clientComponentName)) {
                String err_msg = this.msgUtils_.getMessage("MSG_SAME_CLIENT_AND_SERVICE_COMPONENTS", (Object[])new String[]{"WEB"});
                finalStatus = new SimpleStatus("", err_msg, 4);
            }
            if (clientProjName != null && serviceProjName != null && clientProjName.equalsIgnoreCase(serviceProjName)) {
                String error_msg = this.msgUtils_.getMessage("MSG_SAME_CLIENT_AND_SERVICE_PROJECTS");
                finalStatus = new SimpleStatus("", error_msg, 4);
            }
            if (warning_msg != null && finalStatus.getSeverity() != 4) {
                return new SimpleStatus("", warning_msg, 2);
            }
        }
        return finalStatus;
    }

    private void createMessageText(Composite parent, String value) {
        Text messageText = new Text(parent, 74);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 10;
        messageText.setLayoutData((Object)gridData);
        messageText.setText(value);
    }

    private String getEARProjectWarningMessage(String serviceEARName, String clientEARName) {
        if (serviceEARName != null && clientEARName != null && clientEARName.equalsIgnoreCase(serviceEARName) && clientEARName.length() > 0) {
            return this.msgUtils_.getMessage("MSG_SAME_CLIENT_AND_SERVICE_EARS", (Object[])new String[]{"EAR"});
        }
        return null;
    }

    private class TextModifyListener
    implements ModifyListener {
        TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ServerRuntimeSelectionWidget.this.clientWidget_.isVisible()) {
                TypeRuntimeServer serviceIds = ServerRuntimeSelectionWidget.this.runtimeWidget_.getTypeRuntimeServer();
                TypeRuntimeServer clientIds = ServerRuntimeSelectionWidget.this.clientWidget_.getClientTypeRuntimeServer();
                clientIds.setRuntimeId(serviceIds.getRuntimeId());
                clientIds.setServerId(serviceIds.getServerId());
                clientIds.setServerInstanceId(serviceIds.getServerInstanceId());
                ServerRuntimeSelectionWidget.this.clientWidget_.setClientTypeRuntimeServer(clientIds);
                ServerRuntimeSelectionWidget.this.clientWidget_.setJ2EEVersion(ServerRuntimeSelectionWidget.this.runtimeWidget_.getJ2EEVersion());
            }
            ServerRuntimeSelectionWidget.this.projectWidget_.setTypeRuntimeServer(ServerRuntimeSelectionWidget.this.runtimeWidget_.getTypeRuntimeServer());
            ServerRuntimeSelectionWidget.this.projectWidget_.setJ2EEVersion(ServerRuntimeSelectionWidget.this.runtimeWidget_.getJ2EEVersion());
        }
    }
}

