/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.command;

import java.util.GregorianCalendar;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.consumption.ui.common.ValidationUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusException;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionListChoices;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class CheckForServiceProjectCommand
extends SimpleCommand {
    MessageUtils msgUtils;
    SelectionListChoices runtime2ClientTypes;
    String wsdlURI;
    WebServicesParser webServicesParser;

    public CheckForServiceProjectCommand() {
        String pluginId = "org.eclipse.jst.ws.consumption.ui";
        this.msgUtils = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
    }

    public void setRuntime2ClientTypes(SelectionListChoices runtime2ClientTypes) {
        this.runtime2ClientTypes = runtime2ClientTypes;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public Status execute(Environment environment) {
        SimpleStatus status = new SimpleStatus("");
        if (this.runtime2ClientTypes == null || this.wsdlURI == null || this.wsdlURI.length() == 0 || this.webServicesParser == null) {
            return status;
        }
        String clientProjectName = this.runtime2ClientTypes.getChoice().getChoice().getList().getSelection();
        if (clientProjectName == null || clientProjectName.length() == 0) {
            return status;
        }
        IProject clientProject = ProjectUtilities.getProject((String)clientProjectName);
        ValidationUtils vu = new ValidationUtils();
        new GregorianCalendar();
        boolean isServiceProject = vu.isProjectServiceProject(clientProject, this.wsdlURI, this.webServicesParser);
        if (isServiceProject) {
            SimpleStatus wStatus = new SimpleStatus("", this.msgUtils.getMessage("MSG_WARN_IS_SERVICE_PROJECT", (Object[])new String[]{clientProjectName}), 2);
            try {
                environment.getStatusHandler().report((Status)wStatus);
            }
            catch (StatusException statusException) {
                SimpleStatus eStatus = new SimpleStatus("", this.msgUtils.getMessage("MSG_USER_ABORTED"), 4);
                return eStatus;
            }
        }
        return status;
    }
}

