/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ui.common.ServerSelectionUtils;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionListChoices;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.internal.FlexibleJavaProjectPreferenceUtil;
import org.eclipse.wst.server.core.IRuntime;

public class ProjectSelectionWidget
extends SimpleWidgetDataContributor {
    private final String EAR_PERMITTED_PROJECT_TYPE = "EAR_PERMITTED_PROJECT_TYPE";
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private SelectionListChoices projects_;
    private boolean needEAR_;
    private TypeRuntimeServer trsIds_;
    private String j2eeVersion_;
    private String projectTypeId_ = "EAR_PERMITTED_PROJECT_TYPE";
    private Listener statusListener_;
    private Text messageText_;
    private boolean isClient_ = false;
    private MessageUtils msgUtils;
    private byte CREATE_PROJECT = 1;
    private byte CREATE_EAR = (byte)2;
    private byte ADD_EAR_ASSOCIATION = (byte)4;
    private Combo moduleProject_;
    private Combo earProject_;
    private String componentType_;
    private ModifyListener moduleProjectListener_;
    private ModifyListener moduleListener_;
    private ModifyListener earProjectListener_;
    private ModifyListener earModuleListener_;
    private String initialModuleName_;
    private String INFOPOP_PWRS_COMBO_PROJECT = String.valueOf(this.pluginId_) + ".PWRS0006";
    private Combo module_;
    private String INFOPOP_PWRS_COMBO_EAR = String.valueOf(this.pluginId_) + ".PWRS0012";
    private Combo earModule_;

    public ProjectSelectionWidget() {
    }

    public ProjectSelectionWidget(boolean isClient) {
        this.isClient_ = isClient;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.msgUtils = new MessageUtils(String.valueOf(this.pluginId_) + ".plugin", (Object)this);
        UIUtils uiUtils = new UIUtils(this.msgUtils, this.pluginId_);
        this.statusListener_ = statusListener;
        if (this.isClient_) {
            this.moduleProject_ = uiUtils.createCombo(parent, "LABEL_CLIENT_PROJECT", "LABEL_CLIENT_PROJECT", this.INFOPOP_PWRS_COMBO_PROJECT, 2052);
            this.module_ = uiUtils.createCombo(parent, "LABEL_CLIENT_MODULE", "LABEL_CLIENT_MODULE", this.INFOPOP_PWRS_COMBO_PROJECT, 2052);
            this.earProject_ = uiUtils.createCombo(parent, "LABEL_CLIENT_EAR_PROJECT", "LABEL_CLIENT_EAR_PROJECT", this.INFOPOP_PWRS_COMBO_PROJECT, 2052);
            this.earModule_ = uiUtils.createCombo(parent, "LABEL_CLIENT_EAR_MODULE", "LABEL_CLIENT_EAR_MODULE", this.INFOPOP_PWRS_COMBO_EAR, 2052);
        } else {
            this.moduleProject_ = uiUtils.createCombo(parent, "LABEL_SERVICE_PROJECT", "LABEL_SERVICE_PROJECT", this.INFOPOP_PWRS_COMBO_PROJECT, 2052);
            this.module_ = uiUtils.createCombo(parent, "LABEL_SERVICE_MODULE", "LABEL_SERVICE_MODULE", this.INFOPOP_PWRS_COMBO_PROJECT, 2052);
            this.earProject_ = uiUtils.createCombo(parent, "LABEL_SERVICE_EAR_PROJECT", "LABEL_SERVICE_EAR_PROJECT", this.INFOPOP_PWRS_COMBO_PROJECT, 2052);
            this.earModule_ = uiUtils.createCombo(parent, "LABEL_SERVICE_EAR_MODULE", "LABEL_SERVICE_EAR_MODULE", this.INFOPOP_PWRS_COMBO_EAR, 2052);
        }
        this.moduleProjectListener_ = new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ProjectSelectionWidget.this.handleModuleProjectChanged(null);
                ProjectSelectionWidget.this.statusListener_.handleEvent(null);
            }
        };
        this.moduleListener_ = new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ProjectSelectionWidget.this.handleModuleChanged();
                ProjectSelectionWidget.this.statusListener_.handleEvent(null);
            }
        };
        this.earProjectListener_ = new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ProjectSelectionWidget.this.handleEarProjectChanged();
                ProjectSelectionWidget.this.statusListener_.handleEvent(null);
            }
        };
        this.earModuleListener_ = new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ProjectSelectionWidget.this.statusListener_.handleEvent(null);
            }
        };
        this.messageText_ = uiUtils.createText(parent, "LABEL_NO_LABEL", "LABEL_NO_LABEL", null, 74);
        return this;
    }

    private void listenersOn() {
        this.module_.addModifyListener(this.moduleListener_);
        this.moduleProject_.addModifyListener(this.moduleProjectListener_);
        this.earProject_.addModifyListener(this.earProjectListener_);
        this.earModule_.addModifyListener(this.earModuleListener_);
    }

    private void listenersOff() {
        this.module_.removeModifyListener(this.moduleListener_);
        this.moduleProject_.removeModifyListener(this.moduleProjectListener_);
        this.earProject_.removeModifyListener(this.earProjectListener_);
        this.earModule_.removeModifyListener(this.earModuleListener_);
    }

    private void handleModuleProjectChanged(String moduleName) {
        String projectName = this.moduleProject_.getText();
        IProject project = null;
        if (projectName.equals("")) {
            this.module_.setItems(new String[0]);
            return;
        }
        project = ProjectUtilities.getProject((String)projectName);
        IVirtualComponent[] components = J2EEUtils.getComponentsByType((IProject)project, (String)this.componentType_);
        String[] modules = new String[components.length];
        int index = 0;
        while (index < components.length) {
            modules[index] = components[index].getName();
            ++index;
        }
        this.module_.setItems(modules);
        if (modules.length > 0) {
            if (moduleName != null) {
                this.module_.setText(moduleName);
            } else {
                this.module_.setText(modules[0]);
            }
        } else {
            this.module_.setText(projectName);
        }
    }

    private void handleModuleChanged() {
        IVirtualComponent component = this.getEarModuleForModule();
        if (component != null) {
            String earProject = component.getProject().getName();
            String componentName = component.getName();
            this.earProject_.setText(earProject);
            this.earModule_.setText(componentName);
        } else {
            this.earProject_.setText("");
            this.earModule_.setText("");
        }
        this.updateEAREnabledState();
    }

    private void handleEarProjectChanged() {
        String projectName = this.earProject_.getText();
        if (projectName != null && !projectName.equals("")) {
            IProject project = ProjectUtilities.getProject((String)projectName);
            IVirtualComponent[] components = J2EEUtils.getComponentsByType((IProject)project, (int)8);
            String[] earModules = new String[components.length];
            int index = 0;
            while (index < components.length) {
                earModules[index] = components[index].getName();
                ++index;
            }
            this.earModule_.setItems(earModules);
            if (earModules.length > 0) {
                this.earModule_.setText(earModules[0]);
            } else {
                this.earModule_.setText(projectName);
            }
        } else {
            this.earModule_.setItems(new String[0]);
        }
    }

    private IVirtualComponent getEarModuleForModule() {
        String compName;
        String projectName = this.moduleProject_.getText();
        if (projectName.equals("")) {
            return null;
        }
        IProject project = ProjectUtilities.getProject((String)projectName);
        IVirtualComponent[] components = J2EEUtils.getReferencingEARComponents((IProject)project, (String)(compName = this.module_.getText()));
        return components.length == 0 ? null : components[0];
    }

    public void setProjectChoices(SelectionListChoices projects) {
        this.listenersOff();
        this.projects_ = projects;
        String selectedModuleProject = projects.getList().getSelection();
        String selectedEarModuleProject = projects.getChoice().getList().getSelection();
        String[] projectNames = this.getProjects();
        this.moduleProject_.setItems(projectNames);
        this.moduleProject_.setText(selectedModuleProject);
        this.earProject_.setItems(projectNames);
        this.earProject_.setText(selectedEarModuleProject);
        this.handleModuleProjectChanged(this.initialModuleName_);
        this.handleModuleChanged();
        this.updateEAREnabledState();
        this.listenersOn();
    }

    public SelectionListChoices getProjectChoices() {
        return this.projects_;
    }

    public String getComponentName() {
        return this.module_.getText();
    }

    public void setComponentName(String name) {
        this.listenersOff();
        this.module_.setText(name);
        this.initialModuleName_ = name;
        this.listenersOn();
    }

    public String getEarComponentName() {
        return this.earModule_.getText();
    }

    public void setEarComponentName(String name) {
        this.listenersOff();
        this.earModule_.setText(name);
        this.listenersOn();
    }

    public void setComponentType(String type) {
        this.componentType_ = type;
    }

    public boolean getNeedEAR() {
        return this.needEAR_;
    }

    public String getProjectName() {
        return this.moduleProject_.getText();
    }

    public String getEarProjectName() {
        return this.earProject_.getText();
    }

    public void setNeedEAR(boolean b) {
        this.needEAR_ = b;
    }

    public void setTypeRuntimeServer(TypeRuntimeServer trs) {
        this.trsIds_ = trs;
        this.listenersOff();
        this.updateEAREnabledState();
        this.listenersOn();
    }

    public void setJ2EEVersion(String j2eeVersion) {
        this.j2eeVersion_ = j2eeVersion;
        this.listenersOff();
        this.updateEAREnabledState();
        this.listenersOn();
    }

    public void setProjectTypeId(String id) {
        this.projectTypeId_ = id;
    }

    private String[] getProjects() {
        IProject[] projects = J2EEUtils.getAllFlexibleProjects();
        String[] projectNames = new String[projects.length];
        int index = 0;
        while (index < projects.length) {
            projectNames[index] = projects[index].getName();
            ++index;
        }
        return projectNames;
    }

    private void updateEAREnabledState() {
        if (this.projects_ != null) {
            if (!this.projectNeedsEAR(this.moduleProject_.getText())) {
                this.earModule_.setEnabled(false);
                this.earProject_.setEnabled(false);
                this.earModule_.setText("");
                this.earProject_.setText("");
                this.needEAR_ = false;
            } else {
                this.needEAR_ = true;
                this.earModule_.setEnabled(true);
                this.earProject_.setEnabled(true);
                this.populateEARCombos();
            }
        }
    }

    private void populateEARCombos() {
        IVirtualComponent[] ears;
        this.earModule_.removeAll();
        this.earProject_.removeAll();
        String moduleName = this.module_.getText();
        IProject moduleProj = ResourcesPlugin.getWorkspace().getRoot().getProject(this.moduleProject_.getText());
        if (moduleProj.exists() && (ears = J2EEUtils.getReferencingEARComponents((IProject)moduleProj, (String)moduleName)) != null && ears.length > 0) {
            int i = 0;
            while (i < ears.length) {
                this.earModule_.add(ears[i].getName());
                this.earProject_.add(ears[i].getProject().getName());
                ++i;
            }
            this.earModule_.select(0);
            this.earProject_.select(0);
            return;
        }
        String earName = String.valueOf(moduleName) + "EAR";
        this.earModule_.setText(earName);
        this.earProject_.setText(earName);
    }

    private boolean projectNeedsEAR(String projectName) {
        String targetId;
        if (this.projectTypeId_.equals("jst.utility")) {
            return false;
        }
        if (projectName == null || projectName.length() == 0) {
            return true;
        }
        IProject project = ResourceUtils.getWorkspaceRoot().getProject(projectName);
        if (project != null && project.exists()) {
            IRuntime target = ServerSelectionUtils.getRuntimeTarget(projectName);
            String j2eeVersion = String.valueOf(J2EEUtils.getJ2EEVersion((IProject)project));
            if (target != null && !ServerUtils.isTargetValidForEAR((String)target.getRuntimeType().getId(), (String)j2eeVersion)) {
                return false;
            }
        } else if (this.trsIds_ != null && this.trsIds_.getServerId() != null && (targetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)this.trsIds_.getServerId())) != null && targetId.length() > 0 && !ServerUtils.isTargetValidForEAR((String)targetId, (String)this.j2eeVersion_)) {
            return false;
        }
        return true;
    }

    private Status handleSetMessageText() {
        SimpleStatus status = new SimpleStatus("");
        try {
            byte result = 0;
            if (this.module_.getText().length() != 0 && this.earModule_.getText().length() != 0) {
                String projectText = this.moduleProject_.getText();
                String earText = this.earProject_.getText();
                IProject project = ResourceUtils.getWorkspaceRoot().getProject(projectText);
                IProject ear = ResourceUtils.getWorkspaceRoot().getProject(earText);
                if (project != null) {
                    if (!project.exists()) {
                        result = (byte)(result | this.CREATE_PROJECT);
                    }
                    if (!ear.exists()) {
                        result = (byte)(result | this.CREATE_EAR);
                    }
                    if (project.exists() && ear.exists() && !J2EEUtils.isEARAssociated((IProject)project, (IProject)ear)) {
                        result = (byte)(result | this.ADD_EAR_ASSOCIATION);
                    }
                }
            }
            if (this.isClient_) {
                this.messageText_.setText(this.getValidationMessage(result, this.msgUtils.getMessage("MSG_CLIENT_SUB")));
            } else {
                this.messageText_.setText(this.getValidationMessage(result, this.msgUtils.getMessage("MSG_SERVICE_SUB")));
            }
        }
        catch (Exception exception) {
            return new SimpleStatus("", this.msgUtils.getMessage("PAGE_MSG_VALIDATION_INTERNAL_ERROR"), 4);
        }
        return status;
    }

    private String getValidationMessage(byte result, String serviceOrClient) {
        String msg = null;
        switch (result) {
            case 0: {
                return "";
            }
            case 1: 
            case 5: {
                msg = "MSG_PROJECT_WILL_BE_CREATED";
                break;
            }
            case 2: 
            case 6: {
                msg = "MSG_EAR_WILL_BE_CREATED";
                break;
            }
            case 3: 
            case 7: {
                msg = "MSG_PROJECT_AND_EAR_CREATED";
                break;
            }
            case 4: {
                msg = "MSG_EAR_WILL_BE_ASSOCIATED";
            }
        }
        return msg != null ? this.msgUtils.getMessage(msg, new Object[]{serviceOrClient}) : "";
    }

    public Status getStatus() {
        String moduleName;
        IVirtualComponent component;
        IProject project;
        SimpleStatus finalStatus = new SimpleStatus("");
        this.handleSetMessageText();
        String projectText = this.moduleProject_.getText();
        String earText = this.earProject_.getText();
        String moduleText = this.msgUtils.getMessage("MSG_MODULE");
        if (projectText == null || projectText.length() == 0) {
            if (this.isClient_) {
                return new SimpleStatus("", this.msgUtils.getMessage("MSG_CLIENT_PROJECT_EMPTY", (Object[])new String[]{""}), 4);
            }
            return new SimpleStatus("", this.msgUtils.getMessage("MSG_SERVICE_PROJECT_EMPTY", (Object[])new String[]{""}), 4);
        }
        if (this.needEAR_ && (earText == null || earText.length() == 0)) {
            if (this.isClient_) {
                return new SimpleStatus("", this.msgUtils.getMessage("MSG_CLIENT_EAR_EMPTY", (Object[])new String[]{""}), 4);
            }
            return new SimpleStatus("", this.msgUtils.getMessage("MSG_SERVICE_EAR_EMPTY", (Object[])new String[]{""}), 4);
        }
        if (this.module_ == null || this.module_.getText().length() == 0) {
            if (this.isClient_) {
                return new SimpleStatus("", this.msgUtils.getMessage("MSG_CLIENT_PROJECT_EMPTY", (Object[])new String[]{moduleText}), 4);
            }
            return new SimpleStatus("", this.msgUtils.getMessage("MSG_CLIENT_EAR_EMPTY", (Object[])new String[]{moduleText}), 4);
        }
        if (this.needEAR_ && (this.earModule_ == null || this.earModule_.getText().length() == 0)) {
            if (this.isClient_) {
                return new SimpleStatus("", this.msgUtils.getMessage("MSG_CLIENT_EAR_EMPTY", (Object[])new String[]{moduleText}), 4);
            }
            return new SimpleStatus("", this.msgUtils.getMessage("MSG_SERVICE_EAR_EMPTY", (Object[])new String[]{moduleText}), 4);
        }
        if (!FlexibleJavaProjectPreferenceUtil.getMultipleModulesPerProjectProp() && (project = ResourceUtils.getWorkspaceRoot().getProject(projectText)) != null && project.exists() && !(component = J2EEUtils.getVirtualComponent((IProject)project, (String)(moduleName = this.module_.getText()))).exists() && !moduleName.equals(projectText)) {
            finalStatus = new SimpleStatus("", this.msgUtils.getMessage("MSG_MODULE_NAME_AND_PROJECT_NAME_NOT_THE_SAME"), 4);
        }
        return finalStatus;
    }
}

