/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test.explorer;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.StartProjectCommand;
import org.eclipse.jst.ws.internal.ext.test.WSDLTestFinishCommand;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.ws.internal.explorer.LaunchOption;
import org.eclipse.wst.ws.internal.explorer.WSExplorerLauncherCommand;
import org.eclipse.wst.ws.internal.explorer.plugin.ExplorerPlugin;

public class ExplorerServiceTestCommand
extends SimpleCommand
implements WSDLTestFinishCommand {
    private String LABEL = "ExplorerServiceTestCommand";
    private String DESCRIPTION = "Launch the Explorer";
    private boolean externalBrowser = true;
    private String wsdlServiceURL;
    private String serviceServerTypeID;
    private IServer serviceExistingServer;
    private String serviceProject;
    private List endpoints;

    public ExplorerServiceTestCommand() {
        this.setDescription(this.DESCRIPTION);
        this.setName(this.LABEL);
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        StartProjectCommand spc = new StartProjectCommand(true);
        spc.setServiceServerTypeID(this.serviceServerTypeID);
        spc.setServiceExistingServer(this.serviceExistingServer);
        IProject project = (IProject)ResourceUtils.findResource((String)this.serviceProject);
        spc.setServiceProject(project);
        spc.setIsWebProjectStartupRequested(true);
        status = spc.execute(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        WSExplorerLauncherCommand launchCommand = new WSExplorerLauncherCommand();
        launchCommand.setForceLaunchOutsideIDE(this.externalBrowser);
        Vector<LaunchOption> launchOptionVector = new Vector<LaunchOption>();
        String stateLocation = ExplorerPlugin.getInstance().getPluginStateLocation();
        String defaultFavoritesLocation = ExplorerPlugin.getInstance().getDefaultFavoritesLocation();
        launchOptionVector.add(new LaunchOption("stateLocation", stateLocation));
        launchOptionVector.add(new LaunchOption("defaultFavoritesLocation", defaultFavoritesLocation));
        launchOptionVector.add(new LaunchOption("wsdl", this.wsdlServiceURL));
        if (this.endpoints != null) {
            Iterator it = this.endpoints.iterator();
            while (it.hasNext()) {
                launchOptionVector.add(new LaunchOption("webServiceEndpoint", it.next().toString()));
            }
        }
        launchCommand.setLaunchOptions(launchOptionVector.toArray(new LaunchOption[0]));
        status = launchCommand.execute(env);
        return status;
    }

    public void setExternalBrowser(boolean externalBrowser) {
        this.externalBrowser = externalBrowser;
    }

    public void setWsdlServiceURL(String wsdlServiceURL) {
        this.wsdlServiceURL = wsdlServiceURL;
    }

    public void setServerTypeID(String serviceServerTypeID) {
        this.serviceServerTypeID = serviceServerTypeID;
    }

    public void setExistingServer(IServer serviceExistingServer) {
        this.serviceExistingServer = serviceExistingServer;
    }

    public void setServiceProject(String serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setEndpoint(List endpoints) {
        this.endpoints = endpoints;
    }
}

