/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wizard;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ClientProjectTypeRegistry {
    private static ClientProjectTypeRegistry instance_;
    private IConfigurationElement[] configElements_;

    private ClientProjectTypeRegistry() {
        this.init();
    }

    public static ClientProjectTypeRegistry getInstance() {
        if (instance_ == null) {
            instance_ = new ClientProjectTypeRegistry();
        }
        return instance_;
    }

    public void init() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        this.configElements_ = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "clientProjectType");
    }

    public IConfigurationElement getDefaultElement() {
        return this.getElementById("org.eclipse.jst.ws.consumption.ui.clientProjectType.Web");
    }

    public IConfigurationElement getElementById(String id) {
        return this.getElementByAttribute("id", id);
    }

    public IConfigurationElement getElementByLabel(String label) {
        return this.getElementByAttribute("label", label);
    }

    public IConfigurationElement getElementByProject(IProject project) {
        int i = 0;
        while (i < this.configElements_.length) {
            if (this.include(project, this.configElements_[i].getAttribute("include")) && this.exclude(project, this.configElements_[i].getAttribute("exclude"))) {
                return this.configElements_[i];
            }
            ++i;
        }
        return null;
    }

    private IConfigurationElement getElementByAttribute(String name, String value) {
        int i = 0;
        while (i < this.configElements_.length) {
            if (this.configElements_[i].getAttribute(name).equals(value)) {
                return this.configElements_[i];
            }
            ++i;
        }
        return null;
    }

    public IProject[] getProjects(String id) {
        Vector<IProject> v = new Vector<IProject>();
        IConfigurationElement element = this.getElementById(id);
        if (element != null) {
            ResourceUtils.getWorkspaceRoot().getProjects();
            IVirtualComponent[] comps = J2EEUtils.getAllComponents();
            int i = 0;
            while (i < comps.length) {
                if (J2EEUtils.isWebComponent((IProject)comps[i].getProject(), (String)comps[i].getName()) || J2EEUtils.isEJBComponent((IProject)comps[i].getProject(), (String)comps[i].getName())) {
                    v.add(comps[i].getProject());
                }
                ++i;
            }
        }
        Object[] projects = new IProject[v.size()];
        v.copyInto(projects);
        return projects;
    }

    private boolean include(IProject project, String include) {
        StringTokenizer st = new StringTokenizer(include);
        while (st.hasMoreTokens()) {
            try {
                if (!project.hasNature(st.nextToken())) continue;
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private boolean exclude(IProject project, String exclude) {
        StringTokenizer st = new StringTokenizer(exclude);
        while (st.hasMoreTokens()) {
            try {
                if (!project.hasNature(st.nextToken())) continue;
                return false;
            }
            catch (CoreException coreException) {}
        }
        return true;
    }
}

