/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.AbstractStartServer;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateEJBProjectCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateWebProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.WebServiceStartServerRegistry;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class CreateServiceProjectCommand
extends SimpleCommand {
    private boolean requiresEJB = false;
    private boolean requiresWeb = false;
    private String projectName;
    private String earProjectName;
    private String existingServerId;
    private String serverFactoryId_;
    private String j2eeVersion_;
    private boolean needEAR_;
    private boolean isServiceProjectEJB_ = false;
    private boolean addedProjectToServer_ = false;
    private IServer fExistingServer = null;

    public CreateServiceProjectCommand() {
        super("org.eclipse.jst.ws.internal.consumption.command.common.CreateServiceProjectCommand", "org.eclipse.jst.ws.internal.consumption.command.common.CreateServiceProjectCommand");
    }

    public boolean isUndoable() {
        return true;
    }

    public Status undo(Environment env) {
        SimpleStatus stat = new SimpleStatus("");
        try {
            if (this.fExistingServer != null) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject earProject = null;
                if (this.earProjectName != null && this.earProjectName.length() > 0) {
                    earProject = root.getProject(this.earProjectName);
                }
                AbstractStartServer startServerCommand = null;
                WebServiceStartServerRegistry reg = WebServiceStartServerRegistry.getInstance();
                startServerCommand = (AbstractStartServer)reg.getServerStartByTypeId(this.fExistingServer.getServerType().getId());
                if (earProject != null) {
                    startServerCommand.runPostServerConfig(this.fExistingServer, earProject);
                }
            }
        }
        catch (CoreException ce) {
            IStatus embeddedStatus = ce.getStatus();
            stat = EnvironmentUtils.convertIStatusToStatus((IStatus)embeddedStatus);
            env.getStatusHandler().reportError((Status)stat);
            return stat;
        }
        return stat;
    }

    public Status execute(Environment env) {
        SimpleCommand c;
        if (this.projectName == null) {
            return new SimpleStatus("");
        }
        SimpleStatus status = new SimpleStatus("");
        IServer[] servers = ServerCore.getServers();
        IServer existingServer = null;
        this.fExistingServer = null;
        int i = 0;
        while (i < servers.length) {
            IServer thisServer = servers[i];
            IServerWorkingCopy wc = null;
            String thisServerId = null;
            if (thisServer != null) {
                wc = thisServer.createWorkingCopy();
                String string = thisServerId = wc != null ? wc.getId() : null;
            }
            if (thisServerId.equals(this.existingServerId)) {
                existingServer = thisServer;
            }
            ++i;
        }
        if (this.isServiceProjectEJB_) {
            c = new CreateEJBProjectCommand();
            c.setEjbProjectName(this.projectName);
            c.setEarProjectName(this.earProjectName);
            c.setServiceExistingServer(existingServer);
            c.setServerFactoryId(this.serverFactoryId_);
            c.setJ2EEVersion(this.j2eeVersion_);
            status = c.execute(env);
        } else {
            c = new CreateWebProjectCommand();
            c.setProjectName(this.projectName);
            c.setEarProjectName(this.earProjectName);
            c.setExistingServer(existingServer);
            c.setServerFactoryId(this.serverFactoryId_);
            c.setJ2EEVersion(this.j2eeVersion_);
            c.setNeedEAR(this.needEAR_);
            c.setAddedProjectToServer(this.addedProjectToServer_);
            status = c.execute(env);
        }
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject earProject = null;
            if (this.earProjectName != null && this.earProjectName.length() > 0) {
                earProject = root.getProject(this.earProjectName);
            }
            AbstractStartServer startServerCommand = null;
            WebServiceStartServerRegistry reg = WebServiceStartServerRegistry.getInstance();
            startServerCommand = (AbstractStartServer)reg.getServerStartByTypeId(existingServer.getServerType().getId());
            startServerCommand.runPreServerConfig(existingServer, earProject);
            this.fExistingServer = existingServer;
        }
        catch (CoreException ce) {
            IStatus embeddedStatus = ce.getStatus();
            status = EnvironmentUtils.convertIStatusToStatus((IStatus)embeddedStatus);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        return status;
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName = earProjectName;
    }

    public void setExistingServerId(String existingServerId) {
        this.existingServerId = existingServerId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setRequiresEJB(boolean requiresEJB) {
        this.requiresEJB = requiresEJB;
    }

    public void setRequiresWeb(boolean requiresWeb) {
        this.requiresWeb = requiresWeb;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId_ = serverFactoryId;
    }

    public void setJ2EEVersion(String j2eeVersion) {
        this.j2eeVersion_ = j2eeVersion;
    }

    public void setNeedEAR(boolean needEAR) {
        this.needEAR_ = needEAR;
    }

    public void setIsServiceProjectEJB(boolean isServiceProjectEJB) {
        this.isServiceProjectEJB_ = isServiceProjectEJB;
    }

    public void setAddedProjectToServer(boolean addedProjectToServer) {
        this.addedProjectToServer_ = addedProjectToServer;
    }
}

