/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.internal.common.J2EEUtils;

public final class MappingUtils {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private static final String DEFAULT_SERVICE_EXT = "Service.wsdl";
    private static final String DEFAULT_BINDING_EXT = "Binding.wsdl";
    private static final String DEFAULT_V4_SERVICE_EXT = "-service.wsdl";
    private static final String DEFAULT_V4_BINDING_EXT = "-binding.wsdl";
    private static final String WSDL_EXTENSION = ".wsdl";
    private static final String WSDL_FOLDER = "wsdl";
    public static final String DEFAULT_SKELETON_PACKAGENAME = "service";

    public static IPath getWSDLFolderPath(IProject project, String componentName) {
        IPath wsdlFolder = null;
        IPath webModuleServerRoot = J2EEUtils.getWebContentPath((IProject)project, (String)componentName);
        if (webModuleServerRoot != null) {
            wsdlFolder = webModuleServerRoot.append(WSDL_FOLDER);
        }
        return wsdlFolder;
    }

    public static String getBaseName(String wsdlLocation) {
        String wsdlName = wsdlLocation;
        int index = wsdlLocation.lastIndexOf(47);
        if (index != -1) {
            wsdlName = wsdlLocation.substring(index + 1, wsdlName.length());
        }
        String baseName = wsdlName;
        if (wsdlName.endsWith(DEFAULT_SERVICE_EXT)) {
            baseName = wsdlName.substring(0, wsdlName.length() - DEFAULT_SERVICE_EXT.length());
        } else if (wsdlName.toLowerCase().endsWith(DEFAULT_V4_SERVICE_EXT)) {
            baseName = wsdlName.substring(0, wsdlName.length() - DEFAULT_V4_SERVICE_EXT.length());
        } else if (wsdlName.endsWith(DEFAULT_BINDING_EXT)) {
            baseName = wsdlName.substring(0, wsdlName.length() - DEFAULT_BINDING_EXT.length());
        } else if (wsdlName.toLowerCase().endsWith(DEFAULT_V4_BINDING_EXT)) {
            baseName = wsdlName.substring(0, wsdlName.length() - DEFAULT_V4_BINDING_EXT.length());
        } else if (wsdlName.toLowerCase().endsWith(WSDL_EXTENSION)) {
            baseName = wsdlName.substring(0, wsdlName.length() - WSDL_EXTENSION.length());
        } else {
            int index4 = baseName.lastIndexOf(46);
            if (index4 != -1) {
                baseName = baseName.substring(0, index4);
            }
        }
        return baseName;
    }
}

