/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jst.jsp.core.internal.encoding.JSPDocumentHeadContentDetector;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.jst.jsp.core.internal.text.NullStructuredDocumentPartitioner;
import org.eclipse.wst.html.core.internal.text.StructuredTextPartitionerForHTML;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandlerExtension;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionParser;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextPartitioner;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.rules.StructuredTextPartitioner;
import org.eclipse.wst.sse.core.internal.util.StringUtils;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;

public class StructuredTextPartitionerForJSP
extends StructuredTextPartitioner {
    static final boolean debugPrefixListener = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/partitioner/prefixlistener"));
    private static final boolean fEnableJSPActionPartitions = true;
    private static List fJSPActionTagNames = null;
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String XHTML_MIME_TYPE = "text/xhtml";
    private static final String XML_MIME_TYPE = "text/xml";
    private static final String[] fConfiguredContentTypes = new String[]{"org.eclipse.jst.jsp.DEFAULT_JSP", "org.eclipse.jst.jsp.SCRIPT.JSP_EL", "org.eclipse.jst.jsp.JSP_DIRECTIVE", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.jst.jsp.SCRIPT.JAVA", "org.eclipse.jst.jsp.SCRIPT.JAVASCRIPT", "org.eclipse.jst.jsp.JSP_COMMENT"};
    private IStructuredTextPartitioner fEmbeddedPartitioner = null;
    private String fLanguage = "java";
    private PrefixListener fPrefixParseListener;

    public static String[] getConfiguredContentTypes() {
        return fConfiguredContentTypes;
    }

    public StructuredTextPartitionerForJSP() {
        if (fJSPActionTagNames == null) {
            fJSPActionTagNames = new ArrayList();
            fJSPActionTagNames.add("jsp:declaration");
            fJSPActionTagNames.add("jsp:expression");
            fJSPActionTagNames.add("jsp:fallback");
            fJSPActionTagNames.add("jsp:forward");
            fJSPActionTagNames.add("jsp:getProperty");
            fJSPActionTagNames.add("jsp:include");
            fJSPActionTagNames.add("jsp:param");
            fJSPActionTagNames.add("jsp:params");
            fJSPActionTagNames.add("jsp:plugin");
            fJSPActionTagNames.add("jsp:scriptlet");
            fJSPActionTagNames.add("jsp:setProperty");
            fJSPActionTagNames.add("jsp:text");
            fJSPActionTagNames.add("jsp:useBean");
        }
    }

    public void connect(IDocument document) {
        super.connect(document);
        this.fSupportedTypes = null;
        if (this.structuredDocument.getParser() instanceof JSPSourceParser) {
            StructuredDocumentRegionParser parser = (StructuredDocumentRegionParser)this.structuredDocument.getParser();
            parser.removeStructuredDocumentRegionHandler((StructuredDocumentRegionHandler)this.fPrefixParseListener);
            this.fPrefixParseListener = new PrefixListener();
            parser.addStructuredDocumentRegionHandler((StructuredDocumentRegionHandler)this.fPrefixParseListener);
        }
    }

    private IStructuredTextPartitioner createStructuredTextPartitioner(IStructuredDocument structuredDocument) {
        String contentType;
        NullStructuredDocumentPartitioner result = new NullStructuredDocumentPartitioner();
        JSPDocumentHeadContentDetector jspHeadContentDetector = new JSPDocumentHeadContentDetector();
        jspHeadContentDetector.set((IDocument)structuredDocument);
        try {
            contentType = jspHeadContentDetector.getContentType();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        if (contentType == null) {
            contentType = HTML_MIME_TYPE;
        }
        if (contentType.equalsIgnoreCase(HTML_MIME_TYPE)) {
            result = new StructuredTextPartitionerForHTML();
            result.connect((IDocument)structuredDocument);
        } else if (contentType.equalsIgnoreCase(XHTML_MIME_TYPE)) {
            result = new StructuredTextPartitionerForHTML();
            result.connect((IDocument)structuredDocument);
        } else if (contentType.equalsIgnoreCase(XML_MIME_TYPE) || contentType.endsWith("+xml")) {
            result = new StructuredTextPartitionerForXML();
            result.connect((IDocument)structuredDocument);
        }
        return result;
    }

    public void disconnect() {
        if (this.structuredDocument != null) {
            StructuredDocumentRegionParser parser = (StructuredDocumentRegionParser)this.structuredDocument.getParser();
            if (this.fPrefixParseListener != null) {
                parser.removeStructuredDocumentRegionHandler((StructuredDocumentRegionHandler)this.fPrefixParseListener);
            }
            this.fPrefixParseListener = null;
        }
        if (this.fEmbeddedPartitioner != null) {
            this.fEmbeddedPartitioner.disconnect();
            this.fEmbeddedPartitioner = null;
        }
        super.disconnect();
    }

    public String getDefaultPartitionType() {
        return this.getEmbeddedPartitioner().getDefaultPartitionType();
    }

    public IStructuredTextPartitioner getEmbeddedPartitioner() {
        if (this.fEmbeddedPartitioner == null) {
            this.fEmbeddedPartitioner = this.createStructuredTextPartitioner(this.structuredDocument);
            this.fEmbeddedPartitioner.connect((IDocument)this.structuredDocument);
        }
        return this.fEmbeddedPartitioner;
    }

    public String getLanguage() {
        return this.fLanguage;
    }

    private List getLocalLegalContentTypes() {
        ArrayList<String> types = new ArrayList<String>();
        String[] configuredTypes = StructuredTextPartitionerForJSP.getConfiguredContentTypes();
        int i = 0;
        while (i < configuredTypes.length) {
            types.add(configuredTypes[i]);
            ++i;
        }
        return types;
    }

    private String getParentName(IStructuredDocumentRegion sdRegion) {
        ITextRegionList regions;
        String result = "UNKNOWN";
        while (sdRegion != null && this.isValidJspActionRegionType(sdRegion.getType())) {
            sdRegion = sdRegion.getPrevious();
        }
        if (sdRegion != null && (regions = sdRegion.getRegions()).size() > 1) {
            ITextRegion r = regions.get(1);
            if (regions.get(0).getType().equals("XML_TAG_OPEN") && r.getType().equals("XML_TAG_NAME")) {
                result = sdRegion.getText(r);
            }
        }
        return result;
    }

    protected String getPartitionType(ForeignRegion region, int offset) {
        return this.getEmbeddedPartitioner().getPartitionType((ITextRegion)region, offset);
    }

    public String getPartitionType(ITextRegion region, int offset) {
        IStructuredDocumentRegion sdRegion;
        String result = null;
        String region_type = region.getType();
        result = region_type == "JSP_CONTENT" ? this.getPartitionTypeForDocumentLanguage() : (region_type == "JSP_COMMENT_TEXT" || region_type == "JSP_COMMENT_OPEN" || region_type == "JSP_COMMENT_CLOSE" ? "org.eclipse.jst.jsp.JSP_COMMENT" : (region_type == "JSP_DIRECTIVE_NAME" || region_type == "JSP_DIRECTIVE_OPEN" || region_type == "JSP_DIRECTIVE_CLOSE" ? "org.eclipse.jst.jsp.JSP_DIRECTIVE" : (region_type == "JSP_CLOSE" || region_type == "JSP_SCRIPTLET_OPEN" || region_type == "JSP_EXPRESSION_OPEN" || region_type == "JSP_DECLARATION_OPEN" ? "org.eclipse.jst.jsp.SCRIPT.DELIMITER" : (region_type == "JSP_ROOT_TAG_NAME" ? "org.eclipse.jst.jsp.DEFAULT_JSP" : (region_type == "JSP_EL_OPEN" || region_type == "JSP_EL_CONTENT" || region_type == "JSP_EL_CLOSE" || region_type == "JSP_EL_DQUOTE" || region_type == "JSP_EL_SQUOTE" || region_type == "JSP_EL_QUOTED_CONTENT" ? "org.eclipse.jst.jsp.SCRIPT.JSP_EL" : (region_type == "XML_CONTENT" ? (this.isJspJavaActionName(this.getParentName(sdRegion = this.structuredDocument.getRegionAtCharacterOffset(offset))) ? this.getPartitionTypeForDocumentLanguage() : this.getDefaultPartitionType()) : this.getEmbeddedPartitioner().getPartitionType(region, offset)))))));
        return result;
    }

    public String getPartitionTypeBetween(IStructuredDocumentRegion previousNode, IStructuredDocumentRegion nextNode) {
        return this.getEmbeddedPartitioner().getPartitionTypeBetween(previousNode, nextNode);
    }

    private String getPartitionTypeForDocumentLanguage() {
        String result = this.fLanguage == null || this.fLanguage.equalsIgnoreCase("java") ? "org.eclipse.jst.jsp.SCRIPT.JAVA" : (this.fLanguage.equalsIgnoreCase("javascript") ? "org.eclipse.jst.jsp.SCRIPT.JAVASCRIPT" : "org.eclipse.jst.jsp.SCRIPT." + this.getLanguage().toUpperCase(Locale.ENGLISH));
        return result;
    }

    protected void initLegalContentTypes() {
        List combinedTypes = this.getLocalLegalContentTypes();
        if (this.getEmbeddedPartitioner() != null) {
            String[] moreTypes = this.getEmbeddedPartitioner().getLegalContentTypes();
            int i = 0;
            while (i < moreTypes.length) {
                combinedTypes.add(moreTypes[i]);
                ++i;
            }
        }
        this.fSupportedTypes = new String[0];
        combinedTypes.toArray(this.fSupportedTypes);
    }

    private boolean isAction(IStructuredDocumentRegion sdRegion, int offset) {
        if (!sdRegion.getType().equals("XML_TAG_NAME")) {
            return false;
        }
        ITextRegion tagNameRegion = sdRegion.getRegions().get(1);
        String tagName = sdRegion.getText(tagNameRegion);
        return this.fPrefixParseListener.startsWithCustomActionPrefix(tagName);
    }

    protected boolean isDocumentRegionBasedPartition(IStructuredDocumentRegion sdRegion, ITextRegion containedChildRegion, int offset) {
        String documentRegionContext = sdRegion.getType();
        if (containedChildRegion != null) {
            if (documentRegionContext.equals("JSP_DIRECTIVE_NAME") || documentRegionContext.equals("JSP_ROOT_TAG_NAME")) {
                this.setInternalPartition(offset, containedChildRegion.getLength(), "org.eclipse.jst.jsp.JSP_DIRECTIVE");
                return true;
            }
            if (this.isAction(sdRegion, offset)) {
                this.setInternalPartition(offset, containedChildRegion.getLength(), "org.eclipse.jst.jsp.JSP_DIRECTIVE");
                return true;
            }
        }
        return super.isDocumentRegionBasedPartition(sdRegion, containedChildRegion, offset);
    }

    private boolean isJspJavaActionName(String possibleJspJavaAction) {
        return possibleJspJavaAction.equals("jsp:scriptlet") || possibleJspJavaAction.equals("jsp:expression") || possibleJspJavaAction.equals("jsp:declaration");
    }

    private boolean isValidJspActionRegionType(String type) {
        return type == "XML_CONTENT" || type == "BLOCK_TEXT" || type == "XML_CDATA_OPEN" || type == "XML_CDATA_TEXT" || type == "XML_CDATA_CLOSE";
    }

    public IDocumentPartitioner newInstance() {
        StructuredTextPartitionerForJSP instance = new StructuredTextPartitionerForJSP();
        instance.setEmbeddedPartitioner(this.createStructuredTextPartitioner(this.structuredDocument));
        instance.setLanguage(this.fLanguage);
        return instance;
    }

    public void setEmbeddedPartitioner(IStructuredTextPartitioner embeddedPartitioner) {
        if (this.fEmbeddedPartitioner != null && this.structuredDocument != null) {
            this.fEmbeddedPartitioner.disconnect();
        }
        this.fEmbeddedPartitioner = embeddedPartitioner;
        if (this.fEmbeddedPartitioner != null && this.structuredDocument != null) {
            this.fEmbeddedPartitioner.connect((IDocument)this.structuredDocument);
        }
    }

    protected void setInternalPartition(int offset, int length, String type) {
        this.internalReusedTempInstance = this.getEmbeddedPartitioner().createPartition(offset, length, type);
    }

    public void setLanguage(String language) {
        this.fLanguage = language;
    }

    private class PrefixListener
    implements StructuredDocumentRegionHandler,
    StructuredDocumentRegionHandlerExtension {
        private List fCustomActionPrefixes = new ArrayList(1);
        private String fLastTrue = null;

        public PrefixListener() {
            this.resetNodes();
        }

        private JSPSourceParser getTextSource() {
            return (JSPSourceParser)StructuredTextPartitionerForJSP.this.structuredDocument.getParser();
        }

        public void nodeParsed(IStructuredDocumentRegion sdRegion) {
            if (sdRegion.getNumberOfRegions() > 4 && sdRegion.getRegions().get(1).getType() == "JSP_DIRECTIVE_NAME") {
                ITextRegion nameRegion = sdRegion.getRegions().get(1);
                try {
                    boolean directiveTaglibdetected;
                    boolean tablibdetected = false;
                    int startOffset = sdRegion.getStartOffset(nameRegion);
                    int textLength = nameRegion.getTextLength();
                    if (this.getTextSource() != null) {
                        tablibdetected = this.getTextSource().regionMatches(startOffset, textLength, "taglib");
                        directiveTaglibdetected = this.getTextSource().regionMatches(startOffset, textLength, "jsp:directive.taglib");
                    } else {
                        String directiveName = this.getTextSource().getText(startOffset, textLength);
                        tablibdetected = directiveName.equals("taglib");
                        directiveTaglibdetected = directiveName.equals("jsp:directive.taglib");
                    }
                    if (tablibdetected || directiveTaglibdetected) {
                        this.processTaglib(sdRegion);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            }
        }

        private void processTaglib(IStructuredDocumentRegion taglibStructuredDocumentRegion) {
            String prefixText;
            ITextRegionList regions = taglibStructuredDocumentRegion.getRegions();
            String prefixValue = null;
            boolean prefixnameDetected = false;
            try {
                int i = 0;
                while (i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    int startOffset = taglibStructuredDocumentRegion.getStartOffset(region);
                    int textLength = region.getTextLength();
                    if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                        prefixnameDetected = this.getTextSource().regionMatches(startOffset, textLength, "prefix");
                    } else if (prefixnameDetected && region.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                        prefixValue = this.getTextSource().getText(startOffset, textLength);
                    }
                    ++i;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                prefixValue = null;
            }
            if (prefixValue != null && !this.fCustomActionPrefixes.contains(prefixText = String.valueOf(StringUtils.strip(prefixValue)) + ":")) {
                if (debugPrefixListener) {
                    System.out.println("StructuredTextPartitionerForJSP.PrefixListener learning prefix: " + prefixText);
                }
                this.fCustomActionPrefixes.add(prefixText);
            }
        }

        public void resetNodes() {
            this.fLastTrue = null;
            this.fCustomActionPrefixes.clear();
            this.fCustomActionPrefixes.add("jsp:");
            if (debugPrefixListener) {
                System.out.println("StructuredTextPartitionerForJSP.PrefixListener forgetting learned prefixes");
            }
        }

        public void setStructuredDocument(IStructuredDocument newDocument) {
            this.resetNodes();
            ((StructuredDocumentRegionParser)StructuredTextPartitionerForJSP.this.structuredDocument.getParser()).removeStructuredDocumentRegionHandler((StructuredDocumentRegionHandler)this);
            if (newDocument != null) {
                ((StructuredDocumentRegionParser)newDocument.getParser()).addStructuredDocumentRegionHandler((StructuredDocumentRegionHandler)this);
            }
        }

        public boolean startsWithCustomActionPrefix(String tagname) {
            if (tagname.equals(this.fLastTrue)) {
                return true;
            }
            int i = 0;
            while (i < this.fCustomActionPrefixes.size()) {
                if (tagname.startsWith((String)this.fCustomActionPrefixes.get(i))) {
                    this.fLastTrue = tagname;
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

