/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.ui.preferences;

import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.ws.internal.context.ProjectTopologyContext;
import org.eclipse.jst.ws.internal.context.ProjectTopologyDefaults;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.jst.ws.internal.ui.plugin.WebServiceUIPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ProjectTopologyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private String INFOPOP_PTPP_PAGE = "org.eclipse.jst.ws.ui.PPTP0001";
    private TableViewer clientTypeViewer_;
    private Button moveUp_;
    private Button moveDown_;
    private Vector clientTypes_;
    private final String INFOPOP_PTPP_CLIENT_TYPE = "org.eclipse.jst.ws.ui.PTPP0002";
    private final String INFOPOP_PTPP_MOVE_UP = "org.eclipse.jst.ws.ui.PTPP0003";
    private final String INFOPOP_PTPP_MOVE_DOWN = "org.eclipse.jst.ws.ui.PTPP0004";
    private Button twoEAR_;
    private final String INFOPOP_PTPP_TWO_EAR_CHECKBOX = "org.eclipse.jst.ws.ui.PTPP0005";

    protected Control createContents(Composite superparent) {
        Composite parent = new Composite(superparent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        parent.setToolTipText(this.getMessage("%TOOLTIP_PTPP_PAGE"));
        parent.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.INFOPOP_PTPP_PAGE);
        Text clientTypeLabel = new Text(parent, 72);
        clientTypeLabel.setText(this.getMessage("%LABEL_CLIENT_TYPE_NAME"));
        clientTypeLabel.setLayoutData((Object)new GridData(768));
        Composite clientTypeComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        clientTypeComposite.setLayout((Layout)gl);
        clientTypeComposite.setLayoutData((Object)new GridData(768));
        Table table = new Table(clientTypeComposite, 68356);
        GridData gd = new GridData(1808);
        gd.widthHint = 256;
        table.setLayoutData((Object)gd);
        table.setToolTipText(this.getMessage("%TOOLTIP_CLIENT_TYPE_TABLE_VIEWER"));
        this.clientTypes_ = new Vector();
        this.clientTypeViewer_ = new TableViewer(table);
        this.clientTypeViewer_.setContentProvider((IContentProvider)new ClientTypeContentProvider());
        this.clientTypeViewer_.setLabelProvider((IBaseLabelProvider)new ClientTypeLabelProvider());
        this.clientTypeViewer_.setInput((Object)this.clientTypes_);
        TableLayout tableLayout = new TableLayout();
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(this.getMessage("%LABEL_CLIENT_TYPE"));
        ColumnWeightData columnData = new ColumnWeightData(256, 256, false);
        tableLayout.addColumnData((ColumnLayoutData)columnData);
        table.setLayout((Layout)tableLayout);
        Composite c = new Composite(clientTypeComposite, 0);
        gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginHeight = 10;
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        this.moveUp_ = new Button(c, 8);
        this.moveUp_.setText(this.getMessage("%LABEL_MOVE_UP"));
        this.moveUp_.setLayoutData((Object)new GridData(256));
        this.moveUp_.addSelectionListener((SelectionListener)this);
        this.moveUp_.setToolTipText(this.getMessage("%TOOLTIP_MOVE_UP"));
        this.moveDown_ = new Button(c, 8);
        this.moveDown_.setText(this.getMessage("%LABEL_MOVE_DOWN"));
        this.moveDown_.setLayoutData((Object)new GridData(256));
        this.moveDown_.addSelectionListener((SelectionListener)this);
        this.moveDown_.setToolTipText(this.getMessage("%TOOLTIP_MOVE_DOWN"));
        this.twoEAR_ = new Button(parent, 96);
        this.twoEAR_.setText(this.getMessage("%LABEL_ENABLE_TWO_EARS"));
        this.twoEAR_.setToolTipText(this.getMessage("%TOOLTIP_ENABLE_TWO_EARS"));
        this.initializeValues();
        Dialog.applyDialogFont((Control)superparent);
        return parent;
    }

    private String getMessage(String key) {
        return WebServiceUIPlugin.getMessage(key);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        this.clientTypes_.clear();
        String[] types = ProjectTopologyDefaults.getClientTypes();
        int i = 0;
        while (i < types.length) {
            this.clientTypes_.add(types[i]);
            ++i;
        }
        this.clientTypeViewer_.refresh();
        this.twoEAR_.setSelection(true);
    }

    private void initializeValues() {
        ProjectTopologyContext context = WebServicePlugin.getInstance().getProjectTopologyContext();
        Object[] types = context.getClientTypes();
        int i = 0;
        while (i < types.length) {
            this.clientTypes_.add(types[i]);
            ++i;
        }
        boolean missed = false;
        types = ProjectTopologyDefaults.getClientTypes();
        int i2 = 0;
        while (i2 < types.length) {
            if (this.clientTypes_.indexOf(types[i2]) == -1) {
                this.clientTypes_.add(types[i2]);
                missed = true;
            }
            ++i2;
        }
        if (missed) {
            types = new String[this.clientTypes_.size()];
            this.clientTypes_.copyInto(types);
            context.setClientTypes((String[])types);
        }
        this.clientTypeViewer_.refresh();
        this.twoEAR_.setSelection(context.isUseTwoEARs());
    }

    private void storeValues() {
        ProjectTopologyContext context = WebServicePlugin.getInstance().getProjectTopologyContext();
        Object[] types = new String[this.clientTypes_.size()];
        this.clientTypes_.copyInto(types);
        context.setClientTypes((String[])types);
        context.setUseTwoEARs(this.twoEAR_.getSelection());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        int index = this.clientTypeViewer_.getTable().getSelectionIndex();
        if (index != -1) {
            if (e.widget == this.moveUp_ && index > 0) {
                Object object = this.clientTypes_.remove(index);
                this.clientTypes_.insertElementAt(object, index - 1);
                this.clientTypeViewer_.refresh();
            } else if (e.widget == this.moveDown_ && index < this.clientTypes_.size() - 1) {
                Object object = this.clientTypes_.remove(index);
                this.clientTypes_.insertElementAt(object, index + 1);
                this.clientTypeViewer_.refresh();
            }
        }
    }

    private class ClientTypeContentProvider
    implements IStructuredContentProvider {
        ClientTypeContentProvider() {
        }

        public Object[] getElements(Object value) {
            return ((Vector)value).toArray(new String[0]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private class ClientTypeLabelProvider
    extends LabelProvider {
        private IConfigurationElement[] configElements_;

        public ClientTypeLabelProvider() {
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            this.configElements_ = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "clientProjectType");
        }

        private IConfigurationElement getElementByAttribute(String name, String value) {
            int i = 0;
            while (i < this.configElements_.length) {
                if (this.configElements_[i].getAttribute(name).equals(value)) {
                    return this.configElements_[i];
                }
                ++i;
            }
            return null;
        }

        public Image getImage(Object arg0) {
            return null;
        }

        public String getText(Object value) {
            return this.getElementByAttribute("id", value.toString()).getAttribute("label");
        }
    }
}

