/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.log.MimePart;
import org.eclipse.wst.wsi.internal.core.log.MimeParts;
import org.eclipse.wst.wsi.internal.core.log.impl.MimePartImpl;
import org.eclipse.wst.wsi.internal.core.log.impl.MimePartsImpl;
import org.eclipse.wst.wsi.internal.core.profile.ProfileAssertions;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;
import org.eclipse.wst.wsi.internal.core.util.MIMEUtils;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class Utils {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static ResourceBundle javaEncodingResource = null;
    private static final String JAVA_ENCODING_RESOURCE = "org.wsi.test.util.JavaEncoding";
    private static final String JAVA_ENCODING_DEFAULT = "UTF-8";

    public static final void logError(String inError) {
        System.err.println("Error: " + inError);
    }

    public static final String getExceptionDetails(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Exception: ");
        throwable.printStackTrace(pw);
        return sw.toString();
    }

    public static String getTimestamp() {
        timestampFormat.setTimeZone(TimeZone.getDefault());
        return timestampFormat.format(new Date());
    }

    public static String getDate() {
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(new Date());
    }

    public static String getHTTPStatusCode(String httpHeaders) throws WSIException {
        int index2;
        int index;
        String statusCode = null;
        if (httpHeaders.startsWith("HTTP")) {
            index = httpHeaders.indexOf(" ");
            index2 = httpHeaders.indexOf(" ", index + 1);
            if (index == -1 || index2 == -1) {
                throw new WSIException("Could not find status code in http headers: [" + httpHeaders + "].");
            }
        } else {
            throw new WSIException("Could not find status code in http headers: [" + httpHeaders + "].");
        }
        statusCode = httpHeaders.substring(index + 1, index2);
        return statusCode;
    }

    public static String getHTTPHeaders(String fullMessage) {
        int index = fullMessage.indexOf("\r\n\r\n");
        if (index != -1) {
            index += 4;
        } else {
            index = Utils.getFirstCRLFCRLF(fullMessage);
            if (index == -1) {
                Utils.logError("Unable to parse HTTP message to find headers.  Full message: " + fullMessage);
                return "x-WSI-Test-Tool-Error: Couldn't find headers.  Full message: [" + fullMessage + "].";
            }
        }
        return fullMessage.substring(0, index);
    }

    public static String getContent(String fullMessage) {
        String message = "";
        int index = fullMessage.indexOf("\r\n\r\n");
        index = index != -1 ? (index += 4) : Utils.getFirstCRLFCRLF(fullMessage);
        if (index < 0) {
            Utils.logError("Unable to parse message to get content.  Full message: " + fullMessage);
            message = "x-WSI-Test-Tool-Error: Couldn't find message content.  Full message: [" + fullMessage + "].";
        } else {
            message = index >= fullMessage.length() ? "" : fullMessage.substring(index);
        }
        return message;
    }

    public static byte[] getHTTPHeaders(byte[] fullMessage) {
        int index = Utils.getFirstCRLFCRLF(fullMessage, 0);
        if (index == -1) {
            Utils.logError("Unable to parse HTTP message to find headers.  Full message: " + fullMessage);
            return ("x-WSI-Test-Tool-Error: Couldn't find headers.  Full message: [" + fullMessage + "].").getBytes();
        }
        byte[] b = new byte[index];
        System.arraycopy(fullMessage, 0, b, 0, index);
        return b;
    }

    public static String getHTTPHeadersAsString(byte[] fullMessage, String encoding) {
        int index = Utils.getFirstCRLFCRLF(fullMessage, 0);
        if (index == -1) {
            Utils.logError("Unable to parse HTTP message to find headers.  Full message: " + fullMessage);
            return "x-WSI-Test-Tool-Error: Couldn't find headers.  Full message: [" + fullMessage + "].";
        }
        try {
            return new String(fullMessage, 0, index, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Utils.logError("Unsupported Encoding: " + encoding + ".  Full message: " + fullMessage);
            return "x-WSI-Test-Tool-Error: Unsupported Encoding \"" + encoding + "\".  Full message: [" + fullMessage + "].";
        }
    }

    public static String getContentAsString(byte[] message) {
        String content = "";
        int index = Utils.getFirstCRLFCRLF(message, 0);
        if (index < 0) {
            Utils.logError("Unable to parse message to get content.  Full message: " + message);
            content = "x-WSI-Test-Tool-Error: Couldn't find message content.  Full message: [" + message.toString() + "].";
        } else if (index < message.length) {
            try {
                content = new String(message, index, message.length - index);
            }
            catch (Exception exception) {
                Utils.logError("Unable to parse message to get content.  Full message: " + message);
                content = "x-WSI-Test-Tool-Error: Couldn't find message content.  Full message: [" + message.toString() + "].";
            }
        }
        return content;
    }

    public static byte[] getContent(byte[] message) {
        byte[] content = new byte[]{};
        int index = Utils.getFirstCRLFCRLF(message, 0);
        if (index < 0) {
            Utils.logError("Unable to parse message to get content.  Full message: " + message);
            message = ("x-WSI-Test-Tool-Error: Couldn't find message content.  Full message: [" + message.toString() + "].").getBytes();
        } else if (index < message.length) {
            byte[] b = new byte[message.length - index];
            System.arraycopy(message, index, b, 0, message.length - index);
            content = b;
        }
        return content;
    }

    public static int getFirstCRLF(byte[] buffer, int index) {
        int size = buffer.length;
        int i = index;
        while (i < size - 1) {
            if (buffer[i] == 13 && buffer[i + 1] == 10) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getFirstCRLFCRLF(byte[] buffer, int index) {
        int size = buffer.length;
        int i = index;
        while (i < size - 3) {
            if (buffer[i] == 13 && buffer[i + 1] == 10 && buffer[i + 2] == 13) {
                if (buffer[i + 3] == 10) {
                    return i + 4;
                }
                int j = i + 3;
                while (j < buffer.length && buffer[j] == 13) {
                    ++j;
                }
                if (j < buffer.length && buffer[j] == 10) {
                    return j + 1;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int getFirstCRLFCRLF(String buffer) {
        int index = buffer.indexOf("\r\n\r");
        if (index != -1) {
            int i = index + 3;
            while (i < buffer.length() && buffer.startsWith("\r", i)) {
                ++i;
            }
            if (i < buffer.length() && buffer.startsWith("\n", i)) {
                return i + 1;
            }
            return Utils.getFirstCRLFCRLF(buffer.substring(index + 3));
        }
        return -1;
    }

    public static int[] getBoundaryIndices(byte[] message, String boundaryStr) {
        int[] indices = new int[256];
        int indicesIndex = 0;
        try {
            byte[] boundary = ("\r\n--" + boundaryStr).getBytes("US-ASCII");
            int index = 0;
            int start = 0;
            int cfr_ignored_0 = message.length;
            while (index != -1) {
                index = Utils.indexOf(message, boundary, start);
                if (index == -1) continue;
                start = index + boundary.length;
                indices[indicesIndex] = index;
                ++indicesIndex;
            }
            int[] b = new int[indicesIndex];
            System.arraycopy(indices, 0, b, 0, indicesIndex);
            indices = b;
        }
        catch (Exception exception) {}
        return indices;
    }

    public static int indexOf(byte[] buffer, byte[] key, int start) {
        int bufferLen = buffer.length;
        int keyLen = key.length;
        int k = 0;
        if (keyLen > bufferLen - start) {
            return -1;
        }
        k = start + keyLen - 1;
        while (k < bufferLen) {
            int j = keyLen - 1;
            int i = k;
            while (j >= 0 && buffer[i] == key[j]) {
                --i;
                --j;
            }
            if (j == -1) {
                return i + 1;
            }
            ++k;
        }
        return -1;
    }

    public static InputStream getInputStream(String resourceName) throws IOException {
        URL aURL;
        InputStream is;
        block10: {
            is = null;
            try {
                URL urlResource = new URL(resourceName);
                is = Utils.getInputStream(urlResource);
            }
            catch (MalformedURLException malformedURLException) {
                boolean bTryClassLoader = false;
                try {
                    is = new BufferedInputStream(new FileInputStream(resourceName));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    bTryClassLoader = true;
                }
                catch (SecurityException securityException) {
                    bTryClassLoader = true;
                }
                catch (Exception e) {
                    System.out.println("Exception in getInputStream :" + e.toString());
                }
                if (!bTryClassLoader) break block10;
                is = ClassLoader.getSystemResourceAsStream(resourceName);
            }
        }
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        }
        if (is == null && (aURL = Thread.currentThread().getContextClassLoader().getResource(resourceName)) != null) {
            is = Utils.getInputStream(aURL);
        }
        if (is == null) {
            throw new FileNotFoundException("Could not locate resource file: " + resourceName);
        }
        return is;
    }

    public static InputStream getInputStream(URL urlFile) throws IOException, ConnectException {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(urlFile.openStream());
        }
        catch (ConnectException connectException) {
            throw new ConnectException("Could not connect to URL: " + urlFile.toExternalForm() + ".");
        }
        return is;
    }

    public static boolean fileExists(String fileLocation) {
        boolean fileExists = false;
        try {
            URL url = new URL(fileLocation);
            url.openStream();
            fileExists = true;
        }
        catch (MalformedURLException malformedURLException) {
            try {
                File file = new File(fileLocation);
                fileExists = file.exists();
            }
            catch (Exception exception) {
                fileExists = false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileExists = false;
        }
        catch (Exception exception) {
            fileExists = false;
        }
        return fileExists;
    }

    public static String getLocalHostName() {
        String sLocalHostName;
        try {
            sLocalHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            sLocalHostName = "127.0.0.1";
        }
        return sLocalHostName;
    }

    public static String formatURL(String hostname, String port, String urn) {
        String formatURN = urn;
        if (!formatURN.startsWith("/")) {
            formatURN = "/" + urn;
        }
        return "http://" + hostname + ":" + port + formatURN;
    }

    public static String replaceString(String sText, String sFind, String sReplace) {
        int iPrevIndex = 0;
        int iFindLen = sFind.length();
        int iReplaceLen = sReplace.length();
        String sUpdatedText = sText;
        int iIndex = sUpdatedText.indexOf(sFind);
        while (iIndex < sUpdatedText.length() - 1 && iIndex != -1) {
            sUpdatedText = String.valueOf(sUpdatedText.substring(0, iIndex)) + sReplace + sUpdatedText.substring(iIndex + iFindLen);
            iPrevIndex = iIndex;
            iIndex = sUpdatedText.indexOf(sFind, iPrevIndex + iReplaceLen);
        }
        return sUpdatedText;
    }

    public static String toHexString(String data) {
        char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        byte[] byteData = data.getBytes();
        int length = byteData.length;
        char[] charBuffer = new char[length * 2];
        int byteCnt = 0;
        int charCnt = 0;
        while (byteCnt < length) {
            byte next = byteData[byteCnt++];
            charBuffer[charCnt++] = HEX_CHARS[next >>> 4 & 0xF];
            charBuffer[charCnt++] = HEX_CHARS[next & 0xF];
        }
        return new String(charBuffer);
    }

    public static String toHexString(byte[] byteData) {
        char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int length = byteData.length;
        char[] charBuffer = new char[length * 2];
        int byteCnt = 0;
        int charCnt = 0;
        while (byteCnt < length) {
            byte next = byteData[byteCnt++];
            charBuffer[charCnt++] = HEX_CHARS[next >>> 4 & 0xF];
            charBuffer[charCnt++] = HEX_CHARS[next & 0xF];
        }
        return new String(charBuffer);
    }

    public static String getHTTPCharset(String httpHeaders) {
        String mimeCharset = null;
        mimeCharset = httpHeaders.toUpperCase();
        int[] index = new int[]{-1, -1, -1};
        int indexS = mimeCharset.indexOf("CHARSET");
        int indexE = Integer.MAX_VALUE;
        if (indexS < 17) {
            return "";
        }
        if ((indexS = mimeCharset.indexOf("=", indexS + 7)) == -1) {
            return "";
        }
        index[0] = mimeCharset.indexOf("'", ++indexS);
        index[1] = mimeCharset.indexOf("\r\n", indexS);
        index[2] = mimeCharset.indexOf("\"", indexS);
        int i = 0;
        while (i < 3) {
            if (index[i] != -1 & indexE > index[i]) {
                indexE = index[i];
            }
            ++i;
        }
        if (indexE != Integer.MAX_VALUE) {
            mimeCharset = httpHeaders.substring(indexS, indexE);
            mimeCharset.trim();
        } else {
            mimeCharset = "";
        }
        return mimeCharset;
    }

    public static boolean isMultipartRelatedMessage(String httpHeaders) {
        boolean result = false;
        try {
            String contentType = HTTPUtils.getHttpHeaderAttribute(httpHeaders, "Content-Type");
            if (contentType == null) {
                String boundary = Utils.getHttpHeaderSubAttribute(httpHeaders, "Content-Type", "boundary");
                if (boundary != null && !boundary.equals("")) {
                    result = true;
                }
            } else {
                result = contentType.equalsIgnoreCase("multipart/related");
            }
        }
        catch (WSIException wSIException) {
            result = false;
        }
        return result;
    }

    public static String getHttpHeaderAttribute(String httpHeaders, String attributeName) {
        String result = null;
        try {
            result = HTTPUtils.getHttpHeaderAttribute(httpHeaders, attributeName);
        }
        catch (WSIException wSIException) {
            result = null;
        }
        return result;
    }

    public static String getHttpHeaderSubAttribute(String httpHeaders, String attributeName, String subAttributeName) {
        String result = null;
        try {
            result = HTTPUtils.getHttpHeaderSubAttribute(httpHeaders, attributeName, subAttributeName);
        }
        catch (WSIException wSIException) {
            result = null;
        }
        return result;
    }

    public static String getMimeHeaderAttribute(String mimeHeaders, String attributeName) {
        String result = null;
        try {
            result = MIMEUtils.getMimeHeaderAttribute(mimeHeaders, attributeName);
        }
        catch (WSIException wSIException) {
            result = null;
        }
        return result;
    }

    public static String getMimeHeaderSubAttribute(String mimeHeaders, String attributeName, String subAttributeName) {
        String result = null;
        try {
            result = MIMEUtils.getMimeHeaderSubAttribute(mimeHeaders, attributeName, subAttributeName);
        }
        catch (WSIException wSIException) {
            result = null;
        }
        return result;
    }

    public static String getXMLEncoding(String message) {
        String xmlDef = null;
        int indexS = message.indexOf("<?xml");
        int indexE = -1;
        if (indexS != -1 && (indexE = message.indexOf("?>", indexS)) > indexS) {
            xmlDef = message.substring(indexS, indexE);
        }
        if (xmlDef != null) {
            indexS = xmlDef.indexOf("encoding");
            if (indexS == -1) {
                xmlDef = "";
            } else {
                xmlDef = xmlDef.substring(indexS + 8);
                xmlDef = xmlDef.trim();
            }
        } else {
            return "";
        }
        if (xmlDef.length() > 3) {
            indexS = xmlDef.indexOf("=");
            if (indexS == 0) {
                xmlDef = xmlDef.substring(1);
            } else {
                return "";
            }
        }
        if (xmlDef.length() > 3) {
            String end = "\"";
            indexS = xmlDef.indexOf(end);
            if (indexS != 0) {
                end = "'";
                indexS = xmlDef.indexOf("'");
            }
            xmlDef = indexS == 0 ? ((indexE = xmlDef.indexOf(end, 3)) != -1 ? xmlDef.substring(1, indexE) : "") : "";
        }
        return xmlDef;
    }

    public static String getJavaEncoding(String mimeEncoding) {
        if (mimeEncoding == null || mimeEncoding.length() == 0) {
            return JAVA_ENCODING_DEFAULT;
        }
        try {
            if (javaEncodingResource == null) {
                javaEncodingResource = ResourceBundle.getBundle(JAVA_ENCODING_RESOURCE);
            }
            return javaEncodingResource.getString(mimeEncoding);
        }
        catch (Throwable throwable) {
            return mimeEncoding;
        }
    }

    public static Vector arrayToVector(Object[] array) {
        if (array == null) {
            return null;
        }
        Vector<Object> v = new Vector<Object>(array.length);
        int i = 0;
        while (i < array.length) {
            v.add(array[i]);
            ++i;
        }
        return v;
    }

    public static boolean isValidProfileTADVersion(ProfileAssertions profileAssertions) {
        boolean result = false;
        String name = profileAssertions.getTADName();
        String version = profileAssertions.getTADVersion();
        if ("Basic Profile Test Assertions".equals(name)) {
            result = Utils.checkVersionNumber("1.1.0", version);
        } else if ("Basic Profile 1.1 Test Assertions".equals(name)) {
            result = Utils.checkVersionNumber("1.1.0", version);
        } else if ("Simple Soap Binding Profile [1.0] (with Basic Profile [1.1]) Test Assertions".equals(name)) {
            result = Utils.checkVersionNumber("1.0.0", version);
        } else if ("Attachments Profile [1.0] (with Basic Profile [1.1] and Simple Soap Binding Profile [1.0]) Test Assertions".equals(name)) {
            result = Utils.checkVersionNumber("1.0.0", version);
        }
        return result;
    }

    private static boolean checkVersionNumber(String supportedVersion, String actualVersion) {
        boolean validVersion = true;
        try {
            StringTokenizer supportedVersionTokenizer = new StringTokenizer(supportedVersion, ".");
            StringTokenizer actualVersionTokenizer = new StringTokenizer(actualVersion, ".");
            while (supportedVersionTokenizer.hasMoreTokens() && validVersion) {
                int supportedVersionToken = Integer.parseInt(supportedVersionTokenizer.nextToken());
                if (!actualVersionTokenizer.hasMoreTokens()) continue;
                int actualVersionToken = Integer.parseInt(actualVersionTokenizer.nextToken());
                if (supportedVersionToken <= actualVersionToken) {
                    boolean bl = validVersion = supportedVersionToken >= actualVersionToken;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            validVersion = false;
        }
        return validVersion;
    }

    public static MimePart findRootPart(String httpHeaders, Collection parts) {
        MimePart root = null;
        String start = Utils.getHttpHeaderSubAttribute(httpHeaders, "Content-Type", "start");
        if (!parts.isEmpty()) {
            root = (MimePart)parts.iterator().next();
            if (start != null && !start.equals("")) {
                Iterator i = parts.iterator();
                boolean rootNotFound = true;
                while (i.hasNext() && rootNotFound) {
                    String contentId;
                    MimePart part = (MimePart)i.next();
                    String headers = part.getHeaders();
                    if (headers == null || !start.equals(contentId = Utils.getMimeHeaderAttribute(headers, "Content-ID"))) continue;
                    root = part;
                    rootNotFound = false;
                }
            }
        }
        return root;
    }

    public static byte[] decodeBase64(String str) {
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            return decoder.decodeBuffer(str);
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public static String encodeBase64(byte[] buffer) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encodeBuffer(buffer);
    }

    public static MimeParts parseMultipartRelatedMessage(String message, String httpHeaders, String encoding) {
        byte[] buffer = null;
        try {
            buffer = message.getBytes(encoding);
        }
        catch (Exception exception) {
            return null;
        }
        return Utils.parseMultipartRelatedMessage(buffer, httpHeaders, encoding);
    }

    public static MimeParts parseMultipartRelatedMessage(byte[] message, String httpHeaders, String encoding) {
        MimePartsImpl mimeParts = new MimePartsImpl();
        String boundary = Utils.getHttpHeaderSubAttribute(httpHeaders, "Content-Type", "boundary");
        ArrayList<MimePartImpl> parts = new ArrayList<MimePartImpl>();
        if (boundary == null) {
            return null;
        }
        String start = Utils.getHttpHeaderSubAttribute(httpHeaders, "Content-Type", "start");
        int[] indices = Utils.getBoundaryIndices(message, boundary);
        boolean rootNotFound = true;
        int i = indices.length - 2;
        while (i >= 0) {
            try {
                MimePartImpl part = new MimePartImpl();
                int index = Utils.getFirstCRLFCRLF(message, indices[i]);
                if (index > indices[i] && index < indices[i + 1]) {
                    String str = new String(message, indices[i], index - indices[i], "US-ASCII");
                    String delimiter = str.substring(0, str.indexOf("\r\n", 2) + 2);
                    if (i == indices.length - 2) {
                        String endDelimiter = new String(message, indices[i + 1], message.length - indices[i + 1], "US-ASCII");
                        int j = str.indexOf("\r\n", 2);
                        if (j != -1) {
                            endDelimiter = str.substring(0, str.indexOf("\r\n", 2) + 2);
                        }
                        part.setBoundaryStrings(new String[]{delimiter, endDelimiter});
                    } else {
                        part.setBoundaryStrings(new String[]{delimiter});
                    }
                    String headers = str.substring(delimiter.length());
                    if (headers.startsWith("\r\n")) {
                        part.setHeaders("");
                    } else {
                        part.setHeaders(headers);
                    }
                    String contentId = Utils.getMimeHeaderAttribute(headers, "Content-ID");
                    int size = indices[i + 1] - index;
                    byte[] content = new byte[size];
                    System.arraycopy(message, index, content, 0, size);
                    if (rootNotFound && i == 0 || start != null && !start.equals("") && start.equals(contentId)) {
                        part.setContent(new String(content, encoding));
                        mimeParts.setRootPart(part);
                    } else {
                        String transferEncoding = Utils.getMimeHeaderAttribute(headers, "Content-Transfer-Encoding");
                        if (transferEncoding != null && transferEncoding.equalsIgnoreCase("base64")) {
                            part.setContent(new String(content, encoding));
                        } else {
                            part.setContent(Utils.encodeBase64(content));
                        }
                    }
                    parts.add(part);
                }
            }
            catch (Exception exception) {
                return null;
            }
            --i;
        }
        int size = parts.size();
        int i2 = size - 1;
        while (i2 >= 0) {
            mimeParts.addPart((MimePart)parts.get(i2));
            --i2;
        }
        return mimeParts;
    }

    public static String toXMLString(MimeParts mimeParts) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("<messageContentWithAttachments");
        pw.print(">");
        Collection partList = mimeParts.getParts();
        if (!partList.isEmpty()) {
            Iterator iMimeParts = partList.iterator();
            while (iMimeParts.hasNext()) {
                MimePart mimePart = (MimePart)iMimeParts.next();
                pw.print(mimePart.toXMLString(""));
            }
        }
        pw.println("</messageContentWithAttachments>");
        return sw.toString();
    }

    public static void main(String[] args) {
        try {
            FileInputStream inputStream = new FileInputStream("d:\\b.xml");
            int i = inputStream.available();
            byte[] buffer = new byte[i];
            inputStream.read(buffer);
            String message = new String(buffer);
            message = XMLUtils.xmlRemoveEscapedString(message);
            String headers = Utils.getHTTPHeaders(message);
            Utils.getContent(message);
            MimeParts parts = Utils.parseMultipartRelatedMessage(message, headers, JAVA_ENCODING_DEFAULT);
            System.out.println(Utils.toXMLString(parts));
        }
        catch (Exception exception) {}
    }
}

