/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.tree;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.ProgressUtil;
import org.eclipse.wst.server.ui.internal.ServerLabelProvider;
import org.eclipse.wst.server.ui.internal.Trace;

public class SwitchConfigurationAction
extends Action {
    protected IServer server;
    protected IFolder config;
    protected Shell shell;
    protected IStatus status;

    public SwitchConfigurationAction(Shell shell, String label, IServer server, IFolder config) {
        super(label);
        this.shell = shell;
        this.server = server;
        this.config = config;
        IFolder tempConfig = server.getServerConfiguration();
        if (tempConfig == null && config == null || tempConfig != null && tempConfig.equals((Object)config)) {
            this.setChecked(true);
        }
        if (config == null) {
            this.setImageDescriptor(ImageResource.getImageDescriptor("noConfiguration"));
        } else {
            this.setImageDescriptor(((ServerLabelProvider)ServerUICore.getLabelProvider()).getImageDescriptor(config));
        }
        if (server.getServerState() != 4) {
            this.setEnabled(false);
        }
    }

    public void run() {
        IFolder tempConfig = this.server.getServerConfiguration();
        if (tempConfig == null && this.config == null || tempConfig != null && tempConfig.equals((Object)this.config)) {
            return;
        }
        if (!EclipseUtil.validateEdit(this.shell, this.server)) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor = ProgressUtil.getMonitorFor(monitor);
                    IServerWorkingCopy workingCopy = SwitchConfigurationAction.this.server.createWorkingCopy();
                    workingCopy.setServerConfiguration(SwitchConfigurationAction.this.config);
                    workingCopy.save(false, monitor);
                }
                catch (Exception e) {
                    Trace.trace(Trace.SEVERE, "Could not save configuration", e);
                }
            }
        };
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
            dialog.run(true, true, runnable);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error switching server configuration", e);
        }
    }
}

