/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.earcreation.AddModuleToEARProjectCommand;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.ejb.project.EJBNatureRuntime;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.operations.J2EEWebNatureRuntime;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.env.eclipse.EclipseLog;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IFlexibleProject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public final class J2EEUtils {
    public static final int WEB = 1;
    public static final int EJB = 2;
    public static final int APPCLIENT = 4;
    public static final int EAR = 8;
    static /* synthetic */ Class class$0;

    public static IVirtualComponent getVirtualComponent(IProject project, String componentName) {
        return ComponentCore.createComponent((IProject)project, (String)componentName);
    }

    public static IVirtualComponent getVirtualComponent(String projectName, String componentName) {
        IProject project = null;
        if (projectName != null && projectName.length() > 0) {
            project = ProjectUtilities.getProject((String)projectName);
        }
        return ComponentCore.createComponent(project, (String)componentName);
    }

    public static int getJ2EEVersion(IProject p) {
        J2EENature nature = J2EENature.getRegisteredRuntime((IProject)p);
        if (nature != null) {
            return nature.getJ2EEVersion();
        }
        return -1;
    }

    public static int getJ2EEVersion(IProject p, String componentName) {
        int j2eeVer = -1;
        try {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)p, (String)componentName);
            if (vc != null) {
                j2eeVer = J2EEUtils.getJ2EEVersion(vc);
            }
        }
        catch (Exception exception) {}
        return j2eeVer;
    }

    public static int getJ2EEVersion(IVirtualComponent ch) {
        int j2eeVer = -1;
        if (ch != null) {
            if (J2EEUtils.isWebComponent(ch)) {
                j2eeVer = J2EEUtils.getWebComponentJ2EEVersion(ch);
            } else if (J2EEUtils.isAppClientComponent(ch)) {
                j2eeVer = J2EEUtils.getAppClientComponentJ2EEVersion(ch);
            } else if (J2EEUtils.isEJBComponent(ch)) {
                j2eeVer = J2EEUtils.getEJBComponentJ2EEVersion(ch);
            } else if (J2EEUtils.isEARComponent(ch)) {
                j2eeVer = J2EEUtils.getEARComponentJ2EEVersion(ch);
            }
        }
        return j2eeVer;
    }

    /*
     * Exception decompiling
     */
    private static int getEARComponentJ2EEVersion(IVirtualComponent ch) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 50->53)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getJ2EEVersionAsString(IProject p) {
        int j2eeVer = J2EEUtils.getJ2EEVersion(p);
        if (j2eeVer != -1) {
            return String.valueOf(j2eeVer);
        }
        return null;
    }

    public static String getJ2EEVersionAsString(IProject p, String compName) {
        int j2eeVer = J2EEUtils.getJ2EEVersion(p, compName);
        if (j2eeVer != -1) {
            return J2EEVersionUtil.getJ2EETextVersion((int)j2eeVer);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static int getWebComponentJ2EEVersion(IVirtualComponent ch) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 50->53)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static int getAppClientComponentJ2EEVersion(IVirtualComponent ch) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 50->53)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static int getEJBComponentJ2EEVersion(IVirtualComponent ch) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 50->53)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static EARNatureRuntime[] getEARProjects(IProject project) {
        EARNatureRuntime[] ears = J2EEProjectUtilities.getReferencingEARProjects((IProject)project);
        return ears;
    }

    public static IVirtualComponent[] getAllComponents() {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        IProject[] projects = ResourceUtils.getWorkspaceRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IFlexibleProject fp = ComponentCore.createFlexibleProject((IProject)projects[i]);
            IVirtualComponent[] vcs = fp.getComponents();
            int j = 0;
            while (j < vcs.length) {
                v.add(vcs[j]);
                ++j;
            }
            ++i;
        }
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getAllEARComponents() {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        IProject[] projects = ResourceUtils.getWorkspaceRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                IVirtualComponent[] components = J2EEUtils.getEARComponentsFromProject(projects[i]);
                int j = 0;
                while (j < components.length) {
                    if (components[j] != null) {
                        v.add(components[j]);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getAllWebComponents() {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        IProject[] projects = ResourceUtils.getWorkspaceRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                IVirtualComponent[] components = J2EEUtils.getWebComponents(projects[i]);
                int j = 0;
                while (j < components.length) {
                    if (components[j] != null) {
                        v.add(components[j]);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getEARComponentsFromProject(IProject project) {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        try {
            IFlexibleProject flex = ComponentCore.createFlexibleProject((IProject)project);
            IVirtualComponent[] components = flex.getComponents();
            int i = 0;
            while (i < components.length) {
                if (J2EEUtils.isEARComponent(project, components[i].getName())) {
                    v.add(components[i]);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getWebComponents(IProject project) {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        try {
            IFlexibleProject flex = ComponentCore.createFlexibleProject((IProject)project);
            IVirtualComponent[] components = flex.getComponents();
            int i = 0;
            while (i < components.length) {
                if (J2EEUtils.isWebComponent(project, components[i].getName())) {
                    v.add(components[i]);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return v.toArray(new IVirtualComponent[0]);
    }

    public static String[] getWebComponentNames(IProject project) {
        IVirtualComponent[] vcs = J2EEUtils.getWebComponents(project);
        return J2EEUtils.toComponentNamesArray(vcs);
    }

    public static String[] getEARComponentNames(IProject project) {
        IVirtualComponent[] vcs = J2EEUtils.getEARComponentsFromProject(project);
        return J2EEUtils.toComponentNamesArray(vcs);
    }

    public static IVirtualComponent[] getComponentsByType(IProject project, int componentType) {
        ArrayList v = new ArrayList();
        if ((1 & componentType) == 1) {
            IVirtualComponent[] webVC = J2EEUtils.getWebComponents(project);
            J2EEUtils.addToArrayListHelper(webVC, v);
        }
        if ((2 & componentType) == 2) {
            IVirtualComponent[] ejbVC = J2EEUtils.getEJBComponents(project);
            J2EEUtils.addToArrayListHelper(ejbVC, v);
        }
        if ((4 & componentType) == 4) {
            IVirtualComponent[] appClientVC = J2EEUtils.getAppClientComponents(project);
            J2EEUtils.addToArrayListHelper(appClientVC, v);
        }
        if ((8 & componentType) == 8) {
            IVirtualComponent[] earVC = J2EEUtils.getEARComponentsFromProject(project);
            J2EEUtils.addToArrayListHelper(earVC, v);
        }
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getComponentsByType(IProject project, String componentTypeId) {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        try {
            IFlexibleProject flex = ComponentCore.createFlexibleProject((IProject)project);
            IVirtualComponent[] components = flex.getComponents();
            int i = 0;
            while (i < components.length) {
                IVirtualComponent vc = ComponentCore.createComponent((IProject)project, (String)components[i].getName());
                if (vc.getComponentTypeId().equals(componentTypeId)) {
                    v.add(components[i]);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return v.toArray(new IVirtualComponent[0]);
    }

    public static String[] getProjectsContainingComponentOfType(String componentTypeId) {
        Vector<String> v = new Vector<String>();
        IVirtualComponent[] comps = J2EEUtils.getAllComponents();
        int i = 0;
        while (i < comps.length) {
            String name;
            if (comps[i].getComponentTypeId().equals(componentTypeId) && !v.contains(name = comps[i].getProject().getName())) {
                v.add(name);
            }
            ++i;
        }
        return v.toArray(new String[0]);
    }

    private static void addToArrayListHelper(IVirtualComponent[] vcs, List al) {
        int i = 0;
        while (i < vcs.length) {
            al.add(vcs[i]);
            ++i;
        }
    }

    public static IProject[] getAllFlexibleProjects() {
        ArrayList<IProject> v = new ArrayList<IProject>();
        try {
            IProject[] projects = ProjectUtilities.getAllProjects();
            int i = 0;
            while (i < projects.length) {
                if (ModuleCoreNature.getModuleCoreNature((IProject)projects[i]) != null) {
                    v.add(projects[i]);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return v.toArray(new IProject[0]);
    }

    public static boolean exists(String projectName, String componentName) {
        IProject project = null;
        if (projectName == null || projectName.length() <= 0) {
            return false;
        }
        project = ProjectUtilities.getProject((String)projectName);
        return J2EEUtils.exists(project, componentName);
    }

    public static boolean exists(IProject project, String componentName) {
        if (project != null && componentName != null && componentName.length() > 0) {
            if (!project.exists()) {
                return false;
            }
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project, (String)componentName);
            return vc.exists();
        }
        return false;
    }

    public static String[] getEARProjectNamesForWebProject(IProject project) {
        ArrayList<String> EARNames = new ArrayList<String>();
        if (project != null) {
            EARNatureRuntime[] ears = J2EEUtils.getEARProjects(project);
            int i = 0;
            while (i < ears.length) {
                EARNames.add(ears[i].getProject().getName());
                ++i;
            }
        }
        return EARNames.isEmpty() ? null : EARNames.toArray(new String[0]);
    }

    public static IVirtualComponent[] getReferencingEARComponents(IProject project, String componentName) {
        ArrayList<IVirtualComponent> ears = new ArrayList<IVirtualComponent>();
        try {
            IVirtualComponent targetVC = ComponentCore.createComponent((IProject)project, (String)componentName);
            IVirtualComponent[] earVC = J2EEUtils.getAllEARComponents();
            int i = 0;
            while (i < earVC.length) {
                IVirtualReference[] refs = earVC[i].getReferences();
                int k = 0;
                while (k < refs.length) {
                    if (targetVC.equals(refs[k].getReferencedComponent())) {
                        ears.add(refs[k].getEnclosingComponent());
                    }
                    ++k;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return ears.toArray(new IVirtualComponent[0]);
    }

    public static EARNatureRuntime[] getEJBEARProjects(IProject project) {
        EARNatureRuntime[] ears = J2EEProjectUtilities.getReferencingEARProjects((IProject)project);
        return ears;
    }

    public static String[] getEARProjectNamesForEJBProject(IProject project) {
        ArrayList<String> EARNames = new ArrayList<String>();
        if (project != null) {
            EARNatureRuntime[] ears = J2EEUtils.getEJBEARProjects(project);
            int i = 0;
            while (i < ears.length) {
                EARNames.add(ears[i].getProject().getName());
                ++i;
            }
        }
        return EARNames.isEmpty() ? null : EARNames.toArray(new String[0]);
    }

    public static EARNatureRuntime[] getAppClientEARProjects(IProject project) {
        EARNatureRuntime[] ears = J2EEProjectUtilities.getReferencingEARProjects((IProject)project);
        return ears;
    }

    public static EARNatureRuntime getEARNatureRuntimeFromProject(IProject project) {
        return EARNatureRuntime.getRuntime((IProject)project);
    }

    public static String[] getEARNames(IProject project) {
        EARNatureRuntime[] ears = J2EEUtils.getEARProjects(project);
        String[] earNames = new String[ears == null ? 0 : ears.length];
        int index = 0;
        while (index < earNames.length) {
            earNames[index] = ears[index].getProject().getName();
            ++index;
        }
        return earNames;
    }

    public static Vector getEJBProjects(EARNatureRuntime ear) {
        Vector<J2EENature> ejbs = new Vector<J2EENature>();
        Iterator earProjects = ear.getModuleProjects().values().iterator();
        while (earProjects.hasNext()) {
            J2EENature j2eeNature;
            Object object = earProjects.next();
            if (object == null || !((j2eeNature = (J2EENature)object) instanceof EJBNatureRuntime)) continue;
            ejbs.add(j2eeNature);
        }
        return ejbs;
    }

    public static IVirtualComponent[] getReferencingEJBComponentsFromEAR(IProject project, String earComponentName) {
        ArrayList<IVirtualComponent> ejbComps = new ArrayList<IVirtualComponent>();
        try {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project, (String)earComponentName);
            IVirtualReference[] refs = vc.getReferences();
            int i = 0;
            while (i < refs.length) {
                if (J2EEUtils.isEJBComponent(refs[i].getReferencedComponent())) {
                    ejbComps.add(refs[i].getReferencedComponent());
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return ejbComps.toArray(new IVirtualComponent[0]);
    }

    public static Vector getWebProjects(EARNatureRuntime ear) {
        Vector<J2EENature> webProjects = new Vector<J2EENature>();
        Iterator earProjects = ear.getModuleProjects().values().iterator();
        while (earProjects.hasNext()) {
            J2EENature j2eeNature;
            Object object = earProjects.next();
            if (object == null || !((j2eeNature = (J2EENature)object) instanceof J2EEWebNatureRuntime)) continue;
            webProjects.add(j2eeNature);
        }
        return webProjects;
    }

    public static String[] getEJBProjectNames(EARNatureRuntime ear) {
        Vector ejbNatures = J2EEUtils.getEJBProjects(ear);
        String[] ejbProjectNames = new String[ejbNatures.size()];
        int index = 0;
        while (index < ejbProjectNames.length) {
            ejbProjectNames[index] = ((EJBNatureRuntime)ejbNatures.elementAt(index)).getProject().getName();
            ++index;
        }
        return ejbProjectNames;
    }

    public static Vector getBeanNames(EJBJar jar) {
        List sessionBeans = jar.getSessionBeans();
        Vector names = new Vector();
        J2EEUtils.getBeanNames(names, sessionBeans);
        return names;
    }

    private static void getBeanNames(Vector names, List beans) {
        Iterator iterator = beans.iterator();
        while (iterator.hasNext()) {
            Session sessionBean;
            EnterpriseBean bean = (EnterpriseBean)iterator.next();
            if (!bean.isSession() || (sessionBean = (Session)bean).getSessionType().getValue() != 1) continue;
            names.add(bean.getName());
        }
    }

    public static IProject getProjectFromEJB(EnterpriseBean ejb) {
        return ProjectUtilities.getProject((EObject)ejb);
    }

    public static IProject[] getIProjectsFromJ2EENatures(Vector j2eenatureVector) {
        IProject[] projects = new IProject[j2eenatureVector == null ? 0 : j2eenatureVector.size()];
        Enumeration e = j2eenatureVector.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            IProject project;
            J2EENature nature = (J2EENature)e.nextElement();
            projects[i] = project = nature.getProject();
            ++i;
        }
        return projects;
    }

    public static EARNatureRuntime get12EAR() {
        try {
            IProject[] allEARs = J2EEUtils.getEARProjects();
            int i = 0;
            while (i < allEARs.length) {
                EARNatureRuntime thisEAR = (EARNatureRuntime)allEARs[i].getNature("org.eclipse.jst.j2ee.EARNature");
                if (thisEAR.getJ2EEVersion() == 12) {
                    return thisEAR;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static IProject getDefault12EARProject() {
        try {
            IProject[] allEARs = ResourceUtils.getWorkspaceRoot().getProjects();
            int i = 0;
            while (i < allEARs.length) {
                IProject ear = allEARs[i];
                if (J2EEUtils.getJ2EEVersionAsString(ear).equals("1.2")) {
                    return ear;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static EARNatureRuntime get13EAR() {
        try {
            IProject[] allEARs = J2EEUtils.getEARProjects();
            int i = 0;
            while (i < allEARs.length) {
                EARNatureRuntime thisEAR = (EARNatureRuntime)allEARs[i].getNature("org.eclipse.jst.j2ee.EARNature");
                if (thisEAR.getJ2EEVersion() == 13) {
                    return thisEAR;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    public static IVirtualComponent getDefault13EARComponent() {
        IVirtualComponent[] allEARComponents = J2EEUtils.getAllEARComponents();
        int j = 0;
        while (j < allEARComponents.length) {
            int j2eeVersion = J2EEUtils.getJ2EEVersion(allEARComponents[j]);
            if (j2eeVersion == 13) {
                return allEARComponents[j];
            }
            ++j;
        }
        return null;
    }

    public static IVirtualComponent getDefault14EARComponent() {
        IVirtualComponent[] allEARComponents = J2EEUtils.getAllEARComponents();
        int j = 0;
        while (j < allEARComponents.length) {
            int j2eeVersion = J2EEUtils.getJ2EEVersion(allEARComponents[j]);
            if (j2eeVersion == 14) {
                return allEARComponents[j];
            }
            ++j;
        }
        return null;
    }

    public static EARNatureRuntime getEAR(int versionId) {
        try {
            IProject[] allEARs = J2EEUtils.getEARProjects();
            int i = 0;
            while (i < allEARs.length) {
                EARNatureRuntime thisEAR = (EARNatureRuntime)allEARs[i].getNature("org.eclipse.jst.j2ee.EARNature");
                if (thisEAR.getJ2EEVersion() == versionId) {
                    return thisEAR;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static IVirtualComponent getEARComponentofJ2EEVersion(int versionId) {
        IVirtualComponent[] components = J2EEUtils.getAllEARComponents();
        int i = 0;
        while (i < components.length) {
            if (J2EEUtils.getJ2EEVersion(components[i]) == versionId) {
                return components[i];
            }
            ++i;
        }
        return null;
    }

    public static String getLabelFromJ2EEVersion(String j2eeVersionInt) {
        if (j2eeVersionInt == null || j2eeVersionInt.length() == 0) {
            return "";
        }
        int j2eeVersion = Integer.parseInt(j2eeVersionInt);
        switch (j2eeVersion) {
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
            case 14: {
                return "1.4";
            }
        }
        return "";
    }

    public static String getJ2EEVersionFromLabel(String j2eeLabel) {
        String j2ee12String = String.valueOf(12);
        String j2ee13String = String.valueOf(13);
        String j2ee14String = String.valueOf(14);
        if (j2eeLabel.equals("1.2")) {
            return j2ee12String;
        }
        if (j2eeLabel.equals("1.3")) {
            return j2ee13String;
        }
        if (j2eeLabel.equals("1.4")) {
            return j2ee14String;
        }
        return "";
    }

    public static String getJ2EEIntVersionAsString(String aVersion) {
        if (aVersion.equals("1.4")) {
            return new Integer(14).toString();
        }
        if (aVersion.equals("1.3")) {
            return new Integer(13).toString();
        }
        if (aVersion.equals("1.2")) {
            return new Integer(12).toString();
        }
        return new Integer(14).toString();
    }

    public static EARNatureRuntime[] getEARProjects(IProject serviceProject, IServer server) {
        EARNatureRuntime[] earProjects = null;
        EARNatureRuntime ear = null;
        IProject earProject = null;
        if (serviceProject != null && serviceProject.exists()) {
            try {
                boolean isWebEJBOrAppClient;
                EARNatureRuntime[] ears = null;
                boolean bl = isWebEJBOrAppClient = ResourceUtils.isWebProject(serviceProject) || ResourceUtils.isEJBProject(serviceProject) || ResourceUtils.isAppClientProject(serviceProject);
                if (!isWebEJBOrAppClient) {
                    return null;
                }
                ears = J2EEProjectUtilities.getReferencingEARProjects((IProject)serviceProject);
                if (ears != null && ears.length >= 1) {
                    ArrayList<Object> preferredEARList = new ArrayList<Object>();
                    ArrayList<EARNatureRuntime> secondaryEARList = new ArrayList<EARNatureRuntime>();
                    int i = 0;
                    while (i < ears.length) {
                        ear = ears[i];
                        earProject = ear.getProject();
                        IModule module = ResourceUtils.getModule(earProject);
                        if (module != null) {
                            if (server != null || ServerUtil.containsModule((IServer)server, (IModule)module, (IProgressMonitor)new NullProgressMonitor())) {
                                preferredEARList.add(ear);
                            } else {
                                secondaryEARList.add(ear);
                            }
                        }
                        ++i;
                    }
                    int j = 0;
                    while (j < secondaryEARList.size()) {
                        preferredEARList.add(secondaryEARList.get(j));
                        ++j;
                    }
                    if (preferredEARList != null) {
                        earProjects = preferredEARList.toArray(new EARNatureRuntime[0]);
                    }
                }
            }
            catch (Exception ce) {
                EclipseLog log = new EclipseLog();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jst.ws.internal.common.J2EEUtils");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                log.log(4, 5039, (Object)clazz, "getEARProjects", (Throwable)ce);
            }
        }
        return earProjects;
    }

    public static IProject[] getEARProjects() {
        Vector<IProject> v = new Vector<IProject>();
        IProject[] projects = ResourceUtils.getWorkspaceRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                if (ResourceUtils.isEARProject(projects[i])) {
                    v.add(projects[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return v.toArray(new IProject[0]);
    }

    public static IProject getDefaultEARProject(IProject serviceProject, IServer server) {
        IProject[] earProjects = null;
        IProject ear = null;
        if (serviceProject != null && serviceProject.exists()) {
            try {
                boolean isWebEJBOrAppClient;
                boolean bl = isWebEJBOrAppClient = ResourceUtils.isWebProject(serviceProject) || ResourceUtils.isEJBProject(serviceProject) || ResourceUtils.isAppClientProject(serviceProject);
                if (!isWebEJBOrAppClient) {
                    return null;
                }
                IProject[] ears = J2EEUtils.getEARProjects();
                if (ears != null && ears.length >= 1) {
                    ArrayList<Object> preferredEARList = new ArrayList<Object>();
                    ArrayList<IProject> secondaryEARList = new ArrayList<IProject>();
                    int i = 0;
                    while (i < ears.length) {
                        ear = ears[i];
                        IModule module = ResourceUtils.getModule(ear);
                        if (module != null) {
                            if (server != null || ServerUtil.containsModule((IServer)server, (IModule)module, (IProgressMonitor)new NullProgressMonitor())) {
                                preferredEARList.add(ear);
                            } else {
                                secondaryEARList.add(ear);
                            }
                        }
                        ++i;
                    }
                    int j = 0;
                    while (j < secondaryEARList.size()) {
                        preferredEARList.add(secondaryEARList.get(j));
                        ++j;
                    }
                    if (preferredEARList != null) {
                        earProjects = preferredEARList.toArray(new IProject[0]);
                    }
                }
            }
            catch (Exception ce) {
                EclipseLog log = new EclipseLog();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jst.ws.internal.common.J2EEUtils");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                log.log(4, 5039, (Object)clazz, "getEARProjects", (Throwable)ce);
            }
        }
        return earProjects[0];
    }

    public static IProject[] getEJB2_0ProjectsFromEARS(EARNatureRuntime[] earProjects) {
        if (earProjects == null) {
            return null;
        }
        ArrayList<IProject> ejbProjects = new ArrayList<IProject>();
        int i = 0;
        while (i < earProjects.length) {
            EARNatureRuntime ear;
            Map projectsInEAR;
            if (earProjects[i] instanceof EARNatureRuntime && (projectsInEAR = (ear = earProjects[i]).getModuleProjects()) != null && !projectsInEAR.isEmpty()) {
                Iterator iter = projectsInEAR.values().iterator();
                while (iter.hasNext()) {
                    IProject project;
                    Object MOFObject = iter.next();
                    if (!(MOFObject instanceof EJBNatureRuntime) || ((EJBNatureRuntime)MOFObject).getModuleVersion() < 20 || (project = ((EJBNatureRuntime)MOFObject).getProject()) == null) continue;
                    ejbProjects.add(project);
                }
            }
            ++i;
        }
        return ejbProjects.toArray(new IProject[0]);
    }

    public static IProject[] getEJBProjectsFromEARS(EARNatureRuntime[] earProjects) {
        if (earProjects == null) {
            return null;
        }
        ArrayList<IProject> ejbProjects = new ArrayList<IProject>();
        int i = 0;
        while (i < earProjects.length) {
            EARNatureRuntime ear;
            Map projectsInEAR;
            if (earProjects[i] instanceof EARNatureRuntime && (projectsInEAR = (ear = earProjects[i]).getModuleProjects()) != null && !projectsInEAR.isEmpty()) {
                Iterator iter = projectsInEAR.values().iterator();
                while (iter.hasNext()) {
                    IProject project;
                    Object MOFObject = iter.next();
                    if (!(MOFObject instanceof EJBNatureRuntime) || (project = ((EJBNatureRuntime)MOFObject).getProject()) == null) continue;
                    ejbProjects.add(project);
                }
            }
            ++i;
        }
        return ejbProjects.toArray(new IProject[0]);
    }

    public static IVirtualComponent[] getEJBComponents(IProject project) {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        try {
            IFlexibleProject flex = ComponentCore.createFlexibleProject((IProject)project);
            IVirtualComponent[] comps = flex.getComponents();
            int i = 0;
            while (i < comps.length) {
                if (J2EEUtils.isEJBComponent(comps[i])) {
                    v.add(comps[i]);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getAppClientComponents(IProject project) {
        ArrayList<IVirtualComponent> v = new ArrayList<IVirtualComponent>();
        try {
            IFlexibleProject flex = ComponentCore.createFlexibleProject((IProject)project);
            IVirtualComponent[] comps = flex.getComponents();
            int i = 0;
            while (i < comps.length) {
                if (J2EEUtils.isAppClientComponent(comps[i])) {
                    v.add(comps[i]);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return v.toArray(new IVirtualComponent[0]);
    }

    public static IVirtualComponent[] getReferencingEJB20ComponentsFromEAR(IProject project, String earComponentName) {
        ArrayList<IVirtualComponent> ejbComps = new ArrayList<IVirtualComponent>();
        try {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project, (String)earComponentName);
            IVirtualReference[] refs = vc.getReferences();
            int i = 0;
            while (i < refs.length) {
                if (J2EEUtils.isEJB20Component(refs[i].getReferencedComponent())) {
                    ejbComps.add(refs[i].getReferencedComponent());
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return ejbComps.toArray(new IVirtualComponent[0]);
    }

    public static IProject[] combineProjectArrays(IProject[] projectArray1, IProject[] projectArray2) {
        if (projectArray1 == null && projectArray2 == null) {
            return null;
        }
        if (projectArray1 != null && projectArray2 == null) {
            return projectArray1;
        }
        if (projectArray1 == null && projectArray2 != null) {
            return projectArray2;
        }
        IProject[] combinedProjects = new IProject[projectArray1.length + projectArray2.length];
        System.arraycopy(projectArray1, 0, combinedProjects, 0, projectArray1.length);
        if (projectArray2.length > 0) {
            System.arraycopy(projectArray2, 0, combinedProjects, projectArray1.length, projectArray2.length);
        }
        return combinedProjects;
    }

    public static IProject[] getWebProjectsFromEARS(EARNatureRuntime[] earProjects) {
        if (earProjects == null) {
            return null;
        }
        ArrayList<IProject> webProjects = new ArrayList<IProject>();
        int i = 0;
        while (i < earProjects.length) {
            EARNatureRuntime ear;
            Map projectsInEAR;
            if (earProjects[i] instanceof EARNatureRuntime && (projectsInEAR = (ear = earProjects[i]).getModuleProjects()) != null && !projectsInEAR.isEmpty()) {
                Iterator iter = projectsInEAR.values().iterator();
                while (iter.hasNext()) {
                    IProject project;
                    Object MOFObject = iter.next();
                    if (!(MOFObject instanceof J2EEWebNatureRuntime) || (project = ((J2EEWebNatureRuntime)MOFObject).getProject()) == null) continue;
                    webProjects.add(project);
                }
            }
            ++i;
        }
        return webProjects.toArray(new IProject[0]);
    }

    public static IVirtualComponent[] getReferencingWebComponentsFromEAR(IProject project, String earComponentName) {
        ArrayList<IVirtualComponent> webComps = new ArrayList<IVirtualComponent>();
        try {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project, (String)earComponentName);
            IVirtualReference[] refs = vc.getReferences();
            int i = 0;
            while (i < refs.length) {
                if (J2EEUtils.isWebComponent(refs[i].getReferencedComponent())) {
                    webComps.add(refs[i].getReferencedComponent());
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return webComps.toArray(new IVirtualComponent[0]);
    }

    public static boolean isEJB2_0Project(IProject project) {
        if (ResourceUtils.isEJBProject(project)) {
            try {
                if (project.hasNature("org.eclipse.jst.j2ee.ejb.EJBNature") && EJBNatureRuntime.getRuntime((IProject)project).getModuleVersion() >= 20) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public static boolean isEJB20Component(IVirtualComponent ejbComponent) {
        return J2EEUtils.isEJB20Component(ejbComponent.getProject(), ejbComponent.getName());
    }

    /*
     * Exception decompiling
     */
    public static boolean isEJB20Component(IProject project, String componentName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 73->79)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isEARProject(IProject project) {
        try {
            if (project.hasNature("org.eclipse.jst.j2ee.EARNature")) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static boolean isEARAssociated(IProject module, IProject earProject) {
        EARNatureRuntime[] ears = J2EEUtils.getEARProjects(module);
        if (ears != null && ears.length != 0) {
            Vector<String> EARNames = new Vector<String>();
            int i = 0;
            while (i < ears.length) {
                EARNames.add(ears[i].getProject().getName());
                ++i;
            }
            Object[] earNames = EARNames.toArray(new String[0]);
            if (Arrays.binarySearch(earNames, earProject.getName()) >= 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean isComponentAssociated(IProject earProject, String earCompName, IProject project, String compName) {
        IVirtualComponent vc1 = ComponentCore.createComponent((IProject)earProject, (String)earCompName);
        IVirtualComponent vc2 = ComponentCore.createComponent((IProject)project, (String)compName);
        return J2EEUtils.isComponentAssociated(vc1, vc2);
    }

    private static boolean isComponentAssociated(IVirtualComponent ear, IVirtualComponent component) {
        boolean isAssociated = false;
        IVirtualReference[] compRefs = ear.getReferences();
        if (compRefs != null) {
            int i = 0;
            while (i < compRefs.length) {
                IVirtualReference vref = compRefs[i];
                if (component.equals(vref.getReferencedComponent())) {
                    isAssociated = true;
                }
                ++i;
            }
        }
        return isAssociated;
    }

    public static void associateComponentToEAR(IProject project, String componentName, IProject earProject, String earComponentName) {
        IFlexibleProject flexearProj = ComponentCore.createFlexibleProject((IProject)earProject);
        ComponentHandle earHandle = flexearProj.getComponent(earComponentName).getComponentHandle();
        IFlexibleProject flexcompProj = ComponentCore.createFlexibleProject((IProject)project);
        ComponentHandle compHandle = flexcompProj.getComponent(componentName).getComponentHandle();
        IDataModel addComponentToEARDataModel = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
        addComponentToEARDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT_HANDLE", (Object)earHandle);
        List modList = (List)addComponentToEARDataModel.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST");
        modList.add(compHandle);
        addComponentToEARDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_HANDLE_LIST", (Object)modList);
        try {
            addComponentToEARDataModel.getDefaultOperation().execute(null, null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    public static void associateWebProject(IProject module, IProject EARProject) {
        String contextRoot;
        String uri = String.valueOf(module.getName()) + ".war";
        AddModuleToEARProjectCommand amiec = new AddModuleToEARProjectCommand(module, EARProject, uri, contextRoot = module.getName(), null);
        if (amiec.canExecute()) {
            amiec.execute();
        }
    }

    public static IPath getWebInfPath(IProject project, String componentName) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project, (String)componentName);
        IVirtualFolder webInfDir = component.getRootFolder().getFolder((IPath)new Path("/WEB-INF"));
        IPath modulePath = webInfDir.getWorkspaceRelativePath();
        return modulePath;
    }

    public static IPath getFirstWebContentPath(IProject project) {
        IPath modulePath = null;
        try {
            IFlexibleProject fp = ComponentCore.createFlexibleProject((IProject)project);
            IVirtualComponent[] vcs = fp.getComponents();
            if (vcs.length != 0) {
                modulePath = vcs[0].getRootFolder().getWorkspaceRelativePath();
            }
        }
        catch (Exception exception) {}
        return modulePath;
    }

    public static IPath getWebContentPath(IProject project, String componentName) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project, (String)componentName);
        IPath modulePath = component.getRootFolder().getWorkspaceRelativePath();
        return modulePath;
    }

    public static IContainer getFirstWebContentContainer(IProject project) {
        IContainer container = null;
        IPath modulePath = J2EEUtils.getFirstWebContentPath(project);
        IResource res = ResourceUtils.findResource(modulePath);
        if (res != null) {
            container = res.getParent();
        }
        return container;
    }

    public static IContainer getWebContentContainer(IProject project, String componentName) {
        IContainer container = null;
        IPath modulePath = J2EEUtils.getWebContentPath(project, componentName);
        IResource res = ResourceUtils.findResource(modulePath);
        if (res instanceof IContainer) {
            container = (IContainer)res;
        }
        return container;
    }

    public static String getFirstWebModuleName(IProject project) {
        String moduleName = null;
        try {
            IFlexibleProject fp = ComponentCore.createFlexibleProject((IProject)project);
            IVirtualComponent[] vcs = fp.getComponents();
            if (vcs.length != 0) {
                moduleName = vcs[0].getName();
            }
        }
        catch (Exception exception) {}
        return moduleName;
    }

    public static boolean isWebComponent(IProject project, String componentName) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project, (String)componentName);
        return J2EEUtils.isWebComponent(vc);
    }

    public static boolean isWebComponent(IVirtualComponent comp) {
        return comp.getComponentTypeId().equals("jst.web");
    }

    public static boolean isEARComponent(IProject project, String componentName) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project, (String)componentName);
        return J2EEUtils.isEARComponent(vc);
    }

    public static boolean isEARComponent(IVirtualComponent comp) {
        return comp.getComponentTypeId().equals("jst.ear");
    }

    public static boolean isEJBComponent(IProject project, String componentName) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project, (String)componentName);
        return J2EEUtils.isEJBComponent(vc);
    }

    public static boolean isEJBComponent(IVirtualComponent comp) {
        return comp.getComponentTypeId().equals("jst.ejb");
    }

    public static boolean isAppClientComponent(IProject project, String componentName) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project, (String)componentName);
        return J2EEUtils.isAppClientComponent(vc);
    }

    public static boolean isAppClientComponent(IVirtualComponent comp) {
        return comp.getComponentTypeId().equals("jst.appclient");
    }

    public static boolean isJavaComponent(IProject project, String componentName) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project, (String)componentName);
        return J2EEUtils.isJavaComponent(vc);
    }

    public static boolean isJavaComponent(IVirtualComponent comp) {
        return comp.getComponentTypeId().equals("jst.utility");
    }

    public static String getComponentTypeId(IProject project, String componentName) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project, (String)componentName);
        return vc.getComponentTypeId();
    }

    public static String[] toComponentNamesArray(IVirtualComponent[] components) {
        String[] ecNames = new String[components.length];
        int i = 0;
        while (i < components.length) {
            ecNames[i] = components[i].getName();
            ++i;
        }
        return ecNames;
    }

    public static IProject[] toProjectArray(IVirtualComponent[] components) {
        IProject[] projects = new IProject[components.length];
        int i = 0;
        while (i < components.length) {
            projects[i] = components[i].getProject();
            ++i;
        }
        return projects;
    }

    public static Integer getServletVersionForJ2EEVersion(String j2eeLevel) {
        int aVersion = Integer.valueOf(j2eeLevel);
        switch (aVersion) {
            case 12: {
                return new Integer(22);
            }
            case 13: {
                return new Integer(23);
            }
            case 14: {
                return new Integer(24);
            }
        }
        return new Integer(23);
    }

    public static Integer getEJBVersionForJ2EEVersion(String j2eeLevel) {
        int aVersion = Integer.valueOf(j2eeLevel);
        switch (aVersion) {
            case 12: {
                return new Integer(11);
            }
            case 13: {
                return new Integer(20);
            }
            case 14: {
                return new Integer(21);
            }
        }
        return new Integer(20);
    }
}

