/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operation.extensionui;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.AbstractRegistryDescriptor;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMExtendedPageHandler;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMExtendedWizardPage;
import org.eclipse.wst.common.frameworks.internal.enablement.IdentifiableComparator;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.DMWizardPageFactoryElement;

public class DMWizardPageElement
extends AbstractRegistryDescriptor
implements Comparable {
    public static final int EXTENDED_EDITOR_PAGE = 0;
    public static final int NESTED_EDITOR = 1;
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final String ELEMENT_PAGE_GROUP = "wizardPageGroup";
    static final String ATT_PAGE_ID = "pageGroupID";
    static final String ATT_WIZARD_ID = "wizardID";
    static final String ATT_GROUP_ID = "groupID";
    static final String ATT_ALLOWS_EXTENDED_PAGES_AFTER = "allowsExtendedPagesAfter";
    static final String ATT_PAGE_INSERTION_ID = "pageGroupInsertionID";
    static final String ELEMENT_FACTORY = "factory";
    protected DMWizardPageFactoryElement wizardPageFactoryElement;
    protected String pluginID;
    protected String wizardID;
    public String pageGroupID;
    protected String wizardFactoryElement;
    protected boolean allowsExtendedPagesAfter;
    protected String pageInsertionID;
    private int loadOrder;
    private static int loadOrderCounter;
    private int type;

    public DMWizardPageElement(IConfigurationElement element1) {
        super(element1);
        this.pluginID = element1.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
        this.wizardID = element1.getAttribute(ATT_WIZARD_ID);
        this.pageGroupID = element1.getAttribute(ATT_PAGE_ID);
        this.readAllowsExtendedPageAfter(element1);
        this.pageInsertionID = element1.getAttribute(ATT_PAGE_INSERTION_ID);
        this.readFactory(element1);
        this.validateSettings();
        this.loadOrder = loadOrderCounter++;
    }

    private void validateSettings() {
        if (this.wizardID == null || this.wizardPageFactoryElement == null) {
            Logger.getLogger().logError("Incomplete page extension specification.");
        }
    }

    private void readAllowsExtendedPageAfter(IConfigurationElement element1) {
        String allowsPageAfterValue = element1.getAttribute(ATT_ALLOWS_EXTENDED_PAGES_AFTER);
        this.allowsExtendedPagesAfter = allowsPageAfterValue == null ? false : Boolean.valueOf(allowsPageAfterValue);
    }

    private void readFactory(IConfigurationElement element1) {
        IConfigurationElement[] factories = element1.getChildren(ELEMENT_FACTORY);
        if (factories != null && factories.length > 0) {
            this.wizardPageFactoryElement = new DMWizardPageFactoryElement(factories[0], this.pageGroupID);
        }
    }

    public IDMExtendedPageHandler createPageHandler(IDataModel dataModel) {
        if (this.wizardPageFactoryElement != null) {
            return this.wizardPageFactoryElement.createPageHandler(dataModel);
        }
        return null;
    }

    public IDMExtendedWizardPage[] createPageGroup(IDataModel dataModel) {
        if (this.wizardPageFactoryElement != null) {
            return this.wizardPageFactoryElement.createPageGroup(dataModel);
        }
        return null;
    }

    public int compareTo(Object o) {
        return IdentifiableComparator.getInstance().compare((Object)this, o);
    }

    public boolean allowsExtendedPagesAfter() {
        return this.allowsExtendedPagesAfter;
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public String getPageID() {
        return this.pageGroupID;
    }

    public String getPageInsertionID() {
        return this.pageInsertionID;
    }

    public int getType() {
        return this.type;
    }

    public int getLoadOrder() {
        return this.loadOrder;
    }

    public boolean isAllowsExtendedPagesAfter() {
        return this.allowsExtendedPagesAfter;
    }

    public void setAllowsExtendedPagesAfter(boolean allowsExtendedPagesAfter) {
        this.allowsExtendedPagesAfter = allowsExtendedPagesAfter;
    }

    public String getWizardFactoryElement() {
        return this.wizardFactoryElement;
    }

    public void setWizardFactoryElement(String wizardFactoryElement) {
        this.wizardFactoryElement = wizardFactoryElement;
    }

    public String getWizardID() {
        return this.wizardID;
    }

    public void setWizardID(String wizardID) {
        this.wizardID = wizardID;
    }

    public DMWizardPageFactoryElement getWizardPageFactoryElement() {
        return this.wizardPageFactoryElement;
    }

    public void setWizardPageFactoryElement(DMWizardPageFactoryElement wizardPageFactoryElement) {
        this.wizardPageFactoryElement = wizardPageFactoryElement;
    }

    public void setPageID(String pageID) {
        this.pageGroupID = pageID;
    }

    public String getID() {
        return this.getPageID();
    }
}

