/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operation.extensionui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementManager;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.DMWizardPageElement;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;

public class DMWizardPageExtensionManager {
    public static final String ORG_ECLIPSE_UI = "org.eclipse.ui";
    protected static DMWizardPageExtensionManager instance = null;
    HashMap wizardPluginIDMap = null;
    TreeMap wizardPageElements = null;
    List nonSyncedPageElementList = null;
    private WizardPageExtensionReader reader = null;
    protected ArrayList listRemoveObjects;

    private DMWizardPageExtensionManager() {
        this.setupWizardPluginIDMap();
        this.readFromRegistry();
        this.postReadFromRegistry();
    }

    private void setupWizardPluginIDMap() {
        this.wizardPluginIDMap = new HashMap();
        IExtensionPoint[] point = new IExtensionPoint[]{Platform.getPluginRegistry().getExtensionPoint(ORG_ECLIPSE_UI, "exportWizards"), Platform.getPluginRegistry().getExtensionPoint(ORG_ECLIPSE_UI, "importWizards"), Platform.getPluginRegistry().getExtensionPoint(ORG_ECLIPSE_UI, "newWizards"), Platform.getPluginRegistry().getExtensionPoint("org.eclipse.wst.common.frameworks.ui", "extendableWizard")};
        int x = 0;
        while (x < point.length) {
            IConfigurationElement[] elements = point[x].getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String wizardID = elements[i].getAttribute("id");
                String pluginID = elements[i].getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
                this.wizardPluginIDMap.put(wizardID, pluginID);
                ++i;
            }
            ++x;
        }
    }

    private void readFromRegistry() {
        this.wizardPageElements = new TreeMap();
        this.nonSyncedPageElementList = new ArrayList();
        this.reader = new WizardPageExtensionReader();
        this.reader.readRegistry();
    }

    public boolean hasExtensionElements(String wizardID) {
        TreeMap treeMap = (TreeMap)this.wizardPageElements.get(wizardID);
        return treeMap.isEmpty();
    }

    public DMWizardPageElement[] getPageElements(String wizardID) {
        TreeMap elementMap = (TreeMap)this.wizardPageElements.get(wizardID);
        if (elementMap == null || elementMap.isEmpty()) {
            return new DMWizardPageElement[0];
        }
        ArrayList alreadyVistedList = new ArrayList(elementMap.size());
        Set allPageElementsList = elementMap.keySet();
        ArrayList<DMWizardPageElement> orderedPageList = new ArrayList<DMWizardPageElement>(elementMap.size());
        Iterator iter = allPageElementsList.iterator();
        while (iter.hasNext()) {
            DMWizardPageElement element = (DMWizardPageElement)iter.next();
            if (alreadyVistedList.contains(element) || !EnablementManager.INSTANCE.getIdentifier(element.getID(), null).isEnabled()) continue;
            orderedPageList.add(element);
            TreeSet treeSet = (TreeSet)elementMap.get(element);
            if (treeSet == null || treeSet.isEmpty()) continue;
            this.flatenTreeSet(treeSet, allPageElementsList, alreadyVistedList, orderedPageList, elementMap);
        }
        return this.getPageArray(orderedPageList);
    }

    private DMWizardPageElement[] getPageArray(ArrayList orderedPageList) {
        DMWizardPageElement[] pageElements = new DMWizardPageElement[orderedPageList.size()];
        int i = 0;
        while (i < orderedPageList.size()) {
            pageElements[i] = (DMWizardPageElement)orderedPageList.get(i);
            ++i;
        }
        return pageElements;
    }

    private void flatenTreeSet(TreeSet treeSet, Set allPageElementsList, ArrayList alreadyVistedList, ArrayList orderedPageList, TreeMap elementMap) {
        Iterator iter = treeSet.iterator();
        while (iter.hasNext()) {
            DMWizardPageElement element = (DMWizardPageElement)iter.next();
            if (alreadyVistedList.contains(element)) {
                Logger.getLogger().logError(WTPCommonUIResourceHandler.getString("WizardPageExtensionManager_UI_2", new Object[]{element.getPageID(), "pageGroupInsertionID"}));
                return;
            }
            if (allPageElementsList.contains(element)) {
                TreeSet set = (TreeSet)elementMap.get(element);
                orderedPageList.add(element);
                alreadyVistedList.add(element);
                this.flatenTreeSet(set, allPageElementsList, alreadyVistedList, orderedPageList, elementMap);
                continue;
            }
            orderedPageList.add(element);
            alreadyVistedList.add(element);
        }
    }

    private void postReadFromRegistry() {
        this.listRemoveObjects = new ArrayList(this.nonSyncedPageElementList.size());
        int i = 0;
        while (i < this.nonSyncedPageElementList.size()) {
            DMWizardPageElement element = (DMWizardPageElement)this.nonSyncedPageElementList.get(i);
            TreeMap pageMap = (TreeMap)this.wizardPageElements.get(element.wizardID);
            if (element.pageInsertionID == null) {
                this.addToFirstAvialiable(pageMap, element);
            } else if (this.reader != null && pageMap != null) {
                this.reader.insertPageElement(pageMap, element);
            }
            ++i;
        }
        this.nonSyncedPageElementList.removeAll(this.listRemoveObjects);
        if (!this.nonSyncedPageElementList.isEmpty()) {
            this.logMissingClassError();
        }
        this.nonSyncedPageElementList.clear();
    }

    private void addToFirstAvialiable(TreeMap pageMap, DMWizardPageElement newElement) {
        boolean insertNotFound = true;
        Iterator iter = pageMap.keySet().iterator();
        while (iter.hasNext()) {
            DMWizardPageElement element = (DMWizardPageElement)iter.next();
            if (!element.allowsExtendedPagesAfter) continue;
            TreeSet set = (TreeSet)pageMap.get(element);
            set.add(newElement);
            this.listRemoveObjects.add(newElement);
            return;
        }
        if (insertNotFound) {
            Logger logger = Logger.getLogger();
            logger.logError(WTPCommonUIResourceHandler.getString("WizardPageExtensionManager_UI_3"));
        }
    }

    private void logMissingClassError() {
        Logger logger = Logger.getLogger();
        int i = 0;
        while (i < this.nonSyncedPageElementList.size()) {
            DMWizardPageElement element = (DMWizardPageElement)this.nonSyncedPageElementList.get(i);
            logger.logError(WTPCommonUIResourceHandler.getString("WizardPageExtensionManager_UI_4", new Object[]{element.pageInsertionID, element.getPageID(), element.pluginID}));
            ++i;
        }
        this.nonSyncedPageElementList.clear();
    }

    public static DMWizardPageExtensionManager getInstance() {
        if (instance == null) {
            instance = new DMWizardPageExtensionManager();
        }
        return instance;
    }

    protected class WizardPageExtensionReader
    extends RegistryReader {
        public WizardPageExtensionReader() {
            super("org.eclipse.wst.common.frameworks.ui", "wizardPageGroup");
        }

        public boolean readElement(IConfigurationElement element) {
            if (!"wizardPageGroup".equals(element.getName())) {
                return false;
            }
            DMWizardPageElement newElement = new DMWizardPageElement(element);
            String wizardID = newElement.getWizardID();
            if (!DMWizardPageExtensionManager.this.wizardPageElements.containsKey(wizardID)) {
                DMWizardPageExtensionManager.this.wizardPageElements.put(wizardID, this.createPageMapEntry(newElement));
            } else {
                TreeMap pageMap = (TreeMap)DMWizardPageExtensionManager.this.wizardPageElements.get(wizardID);
                this.insertPageElement(pageMap, newElement);
            }
            return true;
        }

        public void insertPageElement(TreeMap pageMap, DMWizardPageElement newElement) {
            if (newElement.pageInsertionID == null) {
                pageMap.put(newElement, new TreeSet());
            } else {
                String elementName = newElement.pageInsertionID;
                DMWizardPageElement parentElement = this.getPageElement(elementName, pageMap);
                this.insertExtPageElement(pageMap, parentElement, newElement);
            }
            newElement.getPageInsertionID();
        }

        private void insertExtPageElement(TreeMap pageMap, DMWizardPageElement parentElement, DMWizardPageElement newElement) {
            if (parentElement == null) {
                DMWizardPageExtensionManager.this.nonSyncedPageElementList.add(newElement);
                return;
            }
            if (!parentElement.allowsExtendedPagesAfter()) {
                Logger.getLogger().logError(WTPCommonUIResourceHandler.getString("WizardPageExtensionManager_UI_0", new Object[]{parentElement.getPageID()}));
                Logger.getLogger().logError(WTPCommonUIResourceHandler.getString("WizardPageExtensionManager_UI_1", new Object[]{newElement.getPageID()}));
                return;
            }
            TreeSet set = (TreeSet)pageMap.get(parentElement);
            set.add(newElement);
            if (newElement.allowsExtendedPagesAfter) {
                pageMap.put(newElement, new TreeSet());
            }
            if (DMWizardPageExtensionManager.this.nonSyncedPageElementList.contains(newElement)) {
                DMWizardPageExtensionManager.this.nonSyncedPageElementList.remove(newElement);
            }
        }

        private DMWizardPageElement getPageElement(String elementName, TreeMap map) {
            Set keySet = map.keySet();
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                DMWizardPageElement element = (DMWizardPageElement)iter.next();
                if (!element.getPageID().equals(elementName)) continue;
                return element;
            }
            return null;
        }

        private TreeMap createPageMapEntry(DMWizardPageElement newElement) {
            TreeMap pageMap = new TreeMap();
            TreeSet pageExtensionSet = new TreeSet();
            pageMap.put(newElement, pageExtensionSet);
            return pageMap;
        }
    }
}

