/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.jca.archive.operations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.jca.archive.operations.RARProjectLoadStrategyImpl;

public class NestedJARLoadStrategyImpl
extends LoadStrategyImpl {
    private RARProjectLoadStrategyImpl rarStrategy;
    private List sourceIFiles;
    private int rootSegmentCount;
    private boolean exportSource = false;
    private Map urisToIFiles;

    public NestedJARLoadStrategyImpl(RARProjectLoadStrategyImpl parent, List sourceFiles, IFolder root) {
        this.rarStrategy = parent;
        this.sourceIFiles = sourceFiles;
        this.rootSegmentCount = root.getProjectRelativePath().segmentCount();
    }

    protected boolean primContains(String uri) {
        return true;
    }

    public List getFiles() {
        int outputLocSegmentCount = this.rarStrategy.getModuleRootSegmentCount();
        this.urisToIFiles = new HashMap();
        ArrayList result = new ArrayList();
        int size = this.sourceIFiles.size();
        int i = 0;
        while (i < size) {
            IFile iFile = (IFile)this.sourceIFiles.get(i);
            IPath relPath = this.getRelativePath(iFile, this.rootSegmentCount);
            if (this.rarStrategy.isJava(iFile)) {
                if (this.exportSource) {
                    this.addFile(iFile, relPath, result);
                }
                this.addClassFiles(outputLocSegmentCount, result, relPath);
            } else {
                this.addFile(iFile, relPath, result);
            }
            ++i;
        }
        return result;
    }

    private void addClassFiles(int outputLocSegmentCount, List result, IPath relPath) {
        List classFiles = this.getClassFiles(relPath);
        int j = 0;
        while (j < classFiles.size()) {
            IFile classFile = (IFile)classFiles.get(j);
            if (classFile.exists()) {
                this.addFile(classFile, this.getRelativePath(classFile, outputLocSegmentCount), result);
            }
            ++j;
        }
    }

    protected void addFile(IFile iFile, IPath relPath, List result) {
        File cFile = this.createFile(iFile, relPath);
        result.add(cFile);
        this.urisToIFiles.put(cFile.getURI(), iFile);
    }

    protected long getLastModified(IResource aResource) {
        return aResource.getLocation().toFile().lastModified();
    }

    private File createFile(IFile iFile, IPath relPath) {
        File cFile = this.createFile(relPath.toString());
        cFile.setLastModified(this.getLastModified((IResource)iFile));
        return cFile;
    }

    private IPath getRelativePath(IFile file, int parentSegmentCount) {
        return file.getProjectRelativePath().removeFirstSegments(parentSegmentCount);
    }

    private List getClassFiles(IPath relativePath) {
        ArrayList<IFile> result = new ArrayList<IFile>(1);
        IPath path = relativePath.removeFileExtension();
        result.add(this.rarStrategy.getModuleRoot().getFile(path.addFileExtension("class")));
        List inners = this.rarStrategy.retrieveInnerClasses(path.toString());
        if (inners != null) {
            result.addAll(inners);
        }
        return result;
    }

    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        IFile file;
        if (this.urisToIFiles == null) {
            this.getFiles();
        }
        if ((file = (IFile)this.urisToIFiles.get(uri)) != null) {
            try {
                return file.getContents();
            }
            catch (CoreException core) {
                throw new ArchiveRuntimeException(uri, (Exception)((Object)core));
            }
        }
        throw new FileNotFoundException(uri);
    }

    public boolean isExportSource() {
        return this.exportSource;
    }

    public void setExportSource(boolean includeSource) {
        this.exportSource = includeSource;
    }
}

