/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.ApplicationClientNatureRuntime;
import org.eclipse.jst.j2ee.internal.J2EEPropertiesConstants;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.ejb.project.EJBNatureRuntime;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorNatureRuntime;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.jst.j2ee.internal.web.operations.WebProjectInfo;
import org.eclipse.jst.j2ee.internal.web.operations.WebProjectPropertiesUpdateOperation;
import org.eclipse.jst.j2ee.internal.web.operations.WebPropertiesUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;

public class J2EEPropertiesPage
extends PropertyPage
implements J2EEPropertiesConstants {
    protected IProject project = null;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    Text contextRootNameField;
    Text webContentFolderField;
    protected WebProjectInfo wtWebProjectInfo = new WebProjectInfo();

    protected Control createContents(Composite parent) {
        Composite control = null;
        IProject aProject = this.getJ2EEProject();
        if (aProject != null) {
            Composite containerGroup;
            control = containerGroup = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            containerGroup.setLayout((Layout)layout);
            this.fillInformation(aProject, containerGroup);
        }
        return control;
    }

    private void fillInformation(IProject p, Composite c) {
        try {
            if (EARNatureRuntime.hasRuntime((IProject)p)) {
                EARNatureRuntime nature = EARNatureRuntime.getRuntime((IProject)p);
                this.fillJ2EELevel((J2EENature)nature, c);
            } else if (EJBNatureRuntime.hasRuntime((IProject)p)) {
                this.fillEJBLevel(p, c);
            } else if (ApplicationClientNatureRuntime.hasRuntime((IProject)p)) {
                this.fillAppClientLevel(p, c);
            } else if (ConnectorNatureRuntime.hasRuntime((IProject)p)) {
                this.fillConnectorLevel(p, c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillWebLevel(IProject p, Composite c) {
        int servletVersion = this.getModuleServletVersion();
        Label label = new Label(c, 0);
        label.setText(String.valueOf(WEB_LEVEL) + " " + this.getModuleServletVersion());
        String moduleDesc = null;
        switch (servletVersion) {
            case 22: {
                moduleDesc = WEB_22_DESCRIPTION;
                break;
            }
            case 23: {
                moduleDesc = WEB_23_DESCRIPTION;
                break;
            }
            default: {
                moduleDesc = WEB_24_DESCRIPTION;
            }
        }
        this.fillDescription(c, moduleDesc);
        this.fillContextRoot(p, c);
        this.fillWebContentFolderName(p, c);
    }

    private void fillWebContentFolderName(IProject p, Composite c) {
        Label webContentFolderLabel = new Label(c, 0);
        webContentFolderLabel.setText(WEB_CONTENT_FOLDER_NAME);
        GridData data = new GridData();
        data.horizontalIndent = 15;
        webContentFolderLabel.setLayoutData((Object)data);
        this.webContentFolderField = new Text(c, 2048);
        data = new GridData(768);
        data.widthHint = 250;
        this.webContentFolderField.setLayoutData((Object)data);
        this.webContentFolderField.setEditable(true);
        String s = this.getModuleServerRoot().getName();
        this.webContentFolderField.setText(s);
        this.webContentFolderField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newWebContent = J2EEPropertiesPage.this.webContentFolderField.getText();
                J2EEPropertiesPage.this.validateWebContentName(newWebContent);
            }
        });
    }

    private void fillContextRoot(IProject p, Composite c) {
        Label contextRootLabel = new Label(c, 0);
        contextRootLabel.setText(WEB_CONTEXT_ROOT);
        GridData data = new GridData();
        data.horizontalIndent = 15;
        contextRootLabel.setLayoutData((Object)data);
        this.contextRootNameField = new Text(c, 2048);
        data = new GridData(768);
        data.widthHint = 250;
        this.contextRootNameField.setLayoutData((Object)data);
        this.contextRootNameField.setEditable(true);
        String s = this.getModuleContextRoot();
        this.contextRootNameField.setText(s);
        this.contextRootNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newContextRoot = J2EEPropertiesPage.this.contextRootNameField.getText();
                J2EEPropertiesPage.this.validateContextRoot(newContextRoot);
            }
        });
    }

    private void fillConnectorLevel(IProject p, Composite c) {
        ConnectorNatureRuntime nature = ConnectorNatureRuntime.getRuntime((IProject)p);
        Label label = new Label(c, 0);
        label.setText(String.valueOf(CONNECTOR_LEVEL) + " " + nature.getModuleVersionText());
        String moduleDesc = null;
        switch (nature.getModuleVersion()) {
            case 10: {
                moduleDesc = CONNECTOR_10_DESCRIPTION;
                break;
            }
            default: {
                moduleDesc = CONNECTOR_15_DESCRIPTION;
            }
        }
        this.fillDescription(c, moduleDesc);
    }

    private void fillAppClientLevel(IProject p, Composite c) {
        ApplicationClientNatureRuntime nature = ApplicationClientNatureRuntime.getRuntime((IProject)p);
        Label label = new Label(c, 0);
        label.setText(String.valueOf(APP_CLIENT_LEVEL) + " " + nature.getModuleVersionText());
        String moduleDesc = null;
        switch (nature.getModuleVersion()) {
            case 12: {
                moduleDesc = APP_CLIENT_12_DESCRIPTION;
                break;
            }
            case 13: {
                moduleDesc = APP_CLIENT_13_DESCRIPTION;
                break;
            }
            default: {
                moduleDesc = APP_CLIENT_14_DESCRIPTION;
            }
        }
        this.fillDescription(c, moduleDesc);
    }

    private void fillEJBLevel(IProject p, Composite c) {
        EJBNatureRuntime nature = EJBNatureRuntime.getRuntime((IProject)p);
        Label label = new Label(c, 0);
        label.setText(String.valueOf(EJB_LEVEL) + " " + nature.getModuleVersionText());
        String moduleDesc = null;
        switch (nature.getModuleVersion()) {
            case 11: {
                moduleDesc = EJB_11_DESCRIPTION;
                break;
            }
            case 20: {
                moduleDesc = EJB_20_DESCRIPTION;
                break;
            }
            default: {
                moduleDesc = EJB_21_DESCRIPTION;
            }
        }
        this.fillDescription(c, moduleDesc);
    }

    private void fillDescription(Composite c, String s) {
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalIndent = 15;
        Label label = new Label(c, 0);
        label.setLayoutData((Object)data);
        label.setText(DESCRIPTION);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.horizontalIndent = 15;
        data.widthHint = 250;
        data.heightHint = 70;
        Text text = new Text(c, 2626);
        text.setLayoutData((Object)data);
        text.setTextLimit(80);
        text.setSize(300, 120);
        text.setEditable(false);
        text.setText(s);
    }

    private void fillJ2EELevel(J2EENature nature, Composite c) {
        Label label = new Label(c, 0);
        label.setText(String.valueOf(J2EE_LEVEL) + " " + nature.getJ2EEVersionText());
        String desc = null;
        switch (nature.getJ2EEVersion()) {
            case 12: {
                desc = J2EE_12_DESCRIPTION;
                break;
            }
            case 13: {
                desc = J2EE_13_DESCRIPTION;
                break;
            }
            default: {
                desc = J2EE_14_DESCRIPTION;
            }
        }
        this.fillDescription(c, desc);
    }

    private IProject getJ2EEProject() {
        if (this.project == null) {
            IAdaptable element = this.getElement();
            if (element == null) {
                return null;
            }
            if (element instanceof IProject) {
                this.project = J2EEPropertiesPage.isJ2EEProject((IProject)element) ? (IProject)element : null;
                return this.project;
            }
            return null;
        }
        return this.project;
    }

    private static boolean isJ2EEProject(IProject p) {
        return EARNatureRuntime.hasRuntime((IProject)p) || EJBNatureRuntime.hasRuntime((IProject)p) || ApplicationClientNatureRuntime.hasRuntime((IProject)p) || ConnectorNatureRuntime.hasRuntime((IProject)p);
    }

    private IHeadlessRunnableWithProgress getWebPropertiesUpdateOperation() {
        IProject aProject = this.getJ2EEProject();
        this.wtWebProjectInfo.setProject(aProject);
        int servletLevel = this.getModuleServletVersion();
        int jspLevel = this.getModuleJSPVersion();
        if (this.getContextRoot() != null) {
            this.wtWebProjectInfo.setContextRoot(this.getContextRoot());
        }
        if (this.getModuleServerRootName() != null) {
            this.wtWebProjectInfo.setWebContentName(this.getModuleServerRootName());
        }
        this.wtWebProjectInfo.setJSPLevel(jspLevel);
        this.wtWebProjectInfo.setServletLevel(servletLevel);
        return new WebProjectPropertiesUpdateOperation(this.wtWebProjectInfo);
    }

    private String getModuleServerRootName() {
        return this.webContentFolderField != null ? this.webContentFolderField.getText() : null;
    }

    private String getContextRoot() {
        return this.contextRootNameField != null ? this.contextRootNameField.getText() : null;
    }

    protected boolean hasUpdatedInformation() {
        return this.hasContextRootChanged() || this.hasWebContentNameChanged();
    }

    private boolean hasContextRootChanged() {
        String oldContextRoot = this.getModuleContextRoot();
        return oldContextRoot == null || !oldContextRoot.equals(this.getContextRoot());
    }

    private boolean hasWebContentNameChanged() {
        String oldWebContentName = this.getModuleServerRoot().getName();
        return oldWebContentName == null || !oldWebContentName.equals(this.getModuleServerRootName());
    }

    protected void performDefaults() {
        super.performDefaults();
        String contextRoot = this.getModuleContextRoot();
        String moduleServerRoot = this.getModuleServerRoot().getName();
        if (this.contextRootNameField != null) {
            this.contextRootNameField.setText(contextRoot);
        }
        if (this.webContentFolderField != null) {
            this.webContentFolderField.setText(moduleServerRoot);
        }
    }

    public boolean performOk() {
        boolean retVal = true;
        return retVal;
    }

    public void validateWebContentName(String name) {
        String msg = WebPropertiesUtil.validateWebContentName((String)this.getModuleServerRootName(), (IProject)this.getJ2EEProject(), null);
        if (msg != null) {
            this.setValid(false);
            this.setErrorMessage(msg);
        } else {
            this.setValid(true);
            this.setErrorMessage(null);
        }
    }

    public void validateContextRoot(String name) {
        boolean bValid = true;
        if (name == null || name.length() == 0) {
            this.setErrorMessage(ProjectSupportResourceHandler.getString((String)"Context_Root_cannot_be_empty_2"));
            bValid = false;
        }
        if (name.trim().equals(name)) {
            StringTokenizer stok = new StringTokenizer(name, ".");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                int i = 0;
                while (i < token.length()) {
                    if (token.charAt(i) != '_' && token.charAt(i) != '-' && token.charAt(i) != '/' && !Character.isLetterOrDigit(token.charAt(i)) && !Character.isWhitespace(token.charAt(i))) {
                        this.setErrorMessage(ProjectSupportResourceHandler.getString((String)"The_character_is_invalid_in_a_context_root", (Object[])new Object[]{new Character(token.charAt(i)).toString()}));
                        bValid = false;
                    }
                    ++i;
                }
            }
        } else {
            this.setErrorMessage(ProjectSupportResourceHandler.getString((String)"Names_cannot_begin_or_end_with_whitespace_5"));
            bValid = false;
        }
        if (bValid) {
            this.setErrorMessage(null);
        }
        this.setValid(bValid);
    }

    protected String getModuleContextRoot() {
        return null;
    }

    protected IContainer getModuleServerRoot() {
        return WebPropertiesUtil.getModuleServerRoot((IProject)this.project);
    }

    protected int getModuleServletVersion() {
        return 22;
    }

    protected int getModuleJSPVersion() {
        return 22;
    }
}

