/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelSynchHelper;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class NewModuleGroup
implements IJ2EEComponentCreationDataModelProperties {
    private IDataModel model;
    protected Text moduleNameText = null;
    protected Button newButton = null;
    protected Text serverTargetText;
    private DataModelSynchHelper synchHelper;
    private Composite parentComposite;
    private static final int SIZING_TEXT_FIELD_WIDTH = 305;
    private static final String NEW_LABEL_UI = J2EEUIMessages.getResourceString("14");
    private static final String MODULE_NAME_UI = J2EEUIMessages.getResourceString("99");

    public NewModuleGroup(Composite parent, int style, IDataModel model, DataModelSynchHelper syncHelper) {
        this.model = model;
        this.parentComposite = parent;
        this.synchHelper = syncHelper;
        this.buildComposites(parent);
    }

    public void buildComposites(Composite parent) {
        this.createModuleGroup(parent);
    }

    private IProject getSelectedProject() {
        IWorkbenchWindow window = Workbench.getInstance().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null || !(selection instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection stucturedSelection = (StructuredSelection)selection;
        Object obj = stucturedSelection.getFirstElement();
        if (obj instanceof IProject) {
            return (IProject)obj;
        }
        return null;
    }

    private void createModuleGroup(Composite parent) {
        GridData data = new GridData();
        Label moduleNameLabel = new Label(parent, 0);
        moduleNameLabel.setText(MODULE_NAME_UI);
        this.moduleNameText = new Text(parent, 2048);
        data = new GridData(768);
        data.widthHint = 305;
        this.moduleNameText.setLayoutData((Object)data);
        this.synchHelper.synchText(this.moduleNameText, "IComponentCreationDataModelProperties.COMPONENT_NAME", new Control[0]);
        new Label(parent, 0);
    }

    public void dispose() {
        if (this.synchHelper != null) {
            if (this.model != null) {
                this.model.removeListener((IDataModelListener)this.synchHelper);
            }
            this.synchHelper.dispose();
        }
        this.model = null;
    }

    public void addSeperator(Composite parent, int hSpan) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hSpan;
        separator.setLayoutData((Object)gd);
    }

    protected void createServerTargetComposite(Composite parent) {
        IRuntime runtime;
        IProject project;
        Label label = new Label(parent, 0);
        label.setText(J2EEUIMessages.getResourceString("2"));
        this.serverTargetText = new Text(parent, 2056);
        this.serverTargetText.setLayoutData((Object)new GridData(768));
        new Label(parent, 0);
        String projectName = this.moduleNameText.getText();
        if (projectName != null && projectName.length() != 0 && (project = ProjectUtilities.getProject((String)projectName)) != null && (runtime = ServerCore.getProjectProperties((IProject)project).getRuntimeTarget()) != null) {
            this.serverTargetText.setText(runtime.getName());
            this.synchHelper.synchText(this.serverTargetText, "IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", null);
        }
    }
}

