/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.factory;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.contentmodel.factory.CMDocumentFactoryDescriptor;
import org.eclipse.wst.xml.core.internal.contentmodel.factory.CMDocumentFactoryRegistry;

public class CMDocumentFactoryRegistryReader {
    protected static final String EXTENSION_POINT_ID = "documentFactories";
    protected static final String TAG_NAME = "factory";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_TYPE = "type";
    protected String pluginId;
    protected String extensionPointId;
    protected CMDocumentFactoryRegistry registry;

    public CMDocumentFactoryRegistryReader(CMDocumentFactoryRegistry registry) {
        this.registry = registry;
    }

    public void readRegistry() {
        String bundleid = "org.eclipse.wst.xml.core";
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(bundleid, EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    protected void readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_NAME)) {
            String factoryClass = element.getAttribute(ATT_CLASS);
            String filenameExtensions = element.getAttribute(ATT_TYPE);
            if (factoryClass != null && filenameExtensions != null) {
                try {
                    CMDocumentFactoryDescriptor descriptor = new CMDocumentFactoryDescriptor(element);
                    StringTokenizer st = new StringTokenizer(filenameExtensions, ",");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken().trim();
                        this.registry.putFactory(token, descriptor);
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
        }
    }
}

