/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.project.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyDataModel;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyOperation;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;

public class InvertClientJARDependencyCompoundOperation
extends WTPOperation {
    protected EARNatureRuntime[] earNatures;
    protected IProject oldProject;
    protected IProject newProject;
    protected List childOperations = null;
    protected IProgressMonitor monitor;

    public InvertClientJARDependencyCompoundOperation(EARNatureRuntime[] referencingEARs, IProject anOldProject, IProject aNewProject) {
        this.earNatures = referencingEARs;
        this.oldProject = anOldProject;
        this.newProject = aNewProject;
    }

    protected void execute(IProgressMonitor aMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.monitor = aMonitor;
        this.createChildOperations();
        this.executeChildOperations();
    }

    private void createChildOperations() {
        this.childOperations = new ArrayList();
        int i = 0;
        while (i < this.earNatures.length) {
            Iterator projects = this.earNatures[i].getAllMappedProjects().values().iterator();
            while (projects.hasNext()) {
                IProject project = (IProject)projects.next();
                if (project == null || project.equals((Object)this.oldProject) || project.equals((Object)this.newProject) || JemProjectUtilities.isBinaryProject((IProject)project)) continue;
                JARDependencyDataModel model = new JARDependencyDataModel();
                model.setIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE", 2);
                model.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)project.getName());
                model.setProperty("AbstractJARDependencyDataModel.OPPOSITE_PROJECT_NAME", (Object)this.newProject.getName());
                model.setProperty("AbstractJARDependencyDataModel.EAR_PROJECT_NAME", (Object)this.earNatures[i].getProject().getName());
                model.setProperty("AbstractJARDependencyDataModel.REFERENCED_PROJECT_NAME", (Object)this.oldProject.getName());
                this.childOperations.add(new JARDependencyOperation(model));
            }
            ++i;
        }
    }

    private void executeChildOperations() throws InvocationTargetException, InterruptedException {
        this.monitor.beginTask("", this.childOperations.size());
        int i = 0;
        while (i < this.childOperations.size()) {
            JARDependencyOperation op = (JARDependencyOperation)this.childOperations.get(i);
            op.run((IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            ++i;
        }
    }
}

