/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.xsd.XSDConcreteComponent;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class MoveAction
extends Action {
    protected List selectedNodes;
    protected Node parentNode;
    protected Node refChild;

    public MoveAction(Node parentNode, List selectedNodes, Node refChild) {
        this.parentNode = parentNode;
        this.selectedNodes = selectedNodes;
        this.refChild = refChild;
    }

    public MoveAction(XSDConcreteComponent parentComponent, List selectedComponents, XSDConcreteComponent refChildComponent) {
        this.selectedNodes = new ArrayList(selectedComponents.size());
        Iterator i = selectedComponents.iterator();
        while (i.hasNext()) {
            XSDConcreteComponent concreteComponent = (XSDConcreteComponent)i.next();
            this.selectedNodes.add(concreteComponent.getElement());
        }
        this.parentNode = parentComponent.getElement();
        this.refChild = refChildComponent != null ? refChildComponent.getElement() : null;
    }

    public boolean canMove() {
        boolean result = true;
        Iterator i = this.selectedNodes.iterator();
        while (i.hasNext()) {
            Node child = (Node)i.next();
            if (!this.isDecendantOrSelf(child, this.parentNode)) continue;
            result = false;
            break;
        }
        return result;
    }

    protected boolean isDecendantOrSelf(Node potentialParent, Node node) {
        boolean result = false;
        while (node != null) {
            if (node == potentialParent) {
                result = true;
                break;
            }
            node = node.getParentNode();
        }
        return result;
    }

    protected void beginRecording() {
        IDOMModel model = this.getModel();
        if (model != null) {
            model.beginRecording((Object)this, XSDEditorPlugin.getXSDString("_UI_LABEL_MOVE"));
        }
    }

    protected void endRecording() {
        IDOMModel model = this.getModel();
        if (model != null) {
            model.endRecording((Object)this);
        }
    }

    protected IDOMModel getModel() {
        IDOMModel model = null;
        if (this.parentNode instanceof IDOMNode) {
            model = ((IDOMNode)this.parentNode).getModel();
        }
        return model;
    }

    public void run() {
        this.beginRecording();
        try {
            Iterator i = this.selectedNodes.iterator();
            while (i.hasNext()) {
                Node child = (Node)i.next();
                this.repositionBefore(this.parentNode, child, this.refChild);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.endRecording();
    }

    public void repositionBefore(Node parent, Node child, Node refChild) {
        Node oldParent = child.getParentNode();
        if (oldParent != null && refChild != child) {
            Node textNode = MoveAction.isWhitespaceTextNode(child.getPreviousSibling()) ? child.getPreviousSibling() : null;
            oldParent.removeChild(child);
            Node adjustedRefChild = refChild;
            if (refChild != null && MoveAction.isWhitespaceTextNode(refChild.getPreviousSibling())) {
                adjustedRefChild = refChild.getPreviousSibling();
            }
            parent.insertBefore(child, adjustedRefChild);
            if (textNode != null) {
                oldParent.removeChild(textNode);
                parent.insertBefore(textNode, child);
            }
        }
    }

    protected static boolean isWhitespaceTextNode(Node node) {
        boolean result = false;
        if (node != null && node.getNodeType() == 3) {
            String data = ((Text)node).getData();
            result = data == null || data.trim().length() == 0;
        }
        return result;
    }
}

