/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph;

import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.Tool;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.wst.xsd.ui.internal.XSDEditor;
import org.eclipse.wst.xsd.ui.internal.XSDMenuListener;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.ConnectionRenderingFigure;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.IConnectionRenderingViewer;
import org.eclipse.wst.xsd.ui.internal.graph.FigureCanvasKeyboardHandler;
import org.eclipse.wst.xsd.ui.internal.graph.GraphContextMenuProvider;
import org.eclipse.wst.xsd.ui.internal.graph.XSDGraphicalViewerKeyHandler;
import org.eclipse.wst.xsd.ui.internal.graph.figures.CenterLayout;
import org.eclipse.xsd.XSDConcreteComponent;

public abstract class BaseGraphicalViewer
extends ScrollingGraphicalViewer
implements IConnectionRenderingViewer {
    protected FigureCanvasKeyboardHandler figureCanvasKeyboardHandler;
    protected EditDomain editDomain;
    protected boolean isInputEnabled = true;
    protected boolean isSelectionEnabled = true;
    protected ISelectionProvider menuSelectionProvider;
    protected GraphContextMenuProvider menuProvider;
    protected XSDEditor editor;
    protected XSDConcreteComponent input;
    protected ConnectionRenderingFigure connectionRenderingFigure;
    protected static Color white = null;

    public BaseGraphicalViewer(XSDEditor editor, ISelectionProvider selectionProvider) {
        this.editor = editor;
        this.menuSelectionProvider = selectionProvider;
    }

    public ConnectionRenderingFigure getConnectionRenderingFigure() {
        return this.connectionRenderingFigure;
    }

    public void setInputEnabled(boolean enabled) {
        this.isInputEnabled = enabled;
    }

    public void setSelectionEnabled(boolean enabled) {
        this.isSelectionEnabled = enabled;
    }

    public XSDMenuListener getMenuListener() {
        return this.menuProvider.getMenuListener();
    }

    protected void hookControl() {
        super.hookControl();
        if (white == null) {
            white = new Color((Device)this.getControl().getDisplay(), 255, 255, 255);
        }
        this.getControl().setBackground(white);
        this.editDomain = new DefaultEditDomain(null);
        ((DefaultEditDomain)this.editDomain).setDefaultTool((Tool)new SelectionTool());
        this.editDomain.loadDefaultTool();
        this.editDomain.addViewer((EditPartViewer)this);
        this.menuProvider = new GraphContextMenuProvider((EditPartViewer)this, this.menuSelectionProvider, this.editor.getXSDTextEditor());
        this.setContextMenu((MenuManager)this.menuProvider);
        MenuManager manager = new MenuManager();
        manager.addMenuListener((IMenuListener)this.getMenuListener());
        manager.setRemoveAllWhenShown(true);
        Menu menu = manager.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
        this.editor.getSite().registerContextMenu("org.eclipse.wst.xsd.ui.popup.graph", manager, this.menuSelectionProvider);
        new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f') {
                    BaseGraphicalViewer.this.getMenuListener().getDeleteAction().run();
                }
            }
        };
        this.setKeyHandler(new XSDGraphicalViewerKeyHandler((GraphicalViewer)this).setParent(new KeyHandler()));
        this.figureCanvasKeyboardHandler = new FigureCanvasKeyboardHandler(this);
        this.getFigureCanvas().addKeyListener((KeyListener)this.figureCanvasKeyboardHandler);
        this.getRootEditPart().activate();
        ScalableRootEditPart graphicalRootEditPart = (ScalableRootEditPart)this.getRootEditPart();
        graphicalRootEditPart.getLayer((Object)"Primary Layer").setLayoutManager((LayoutManager)new CenterLayout());
        IFigure figure = graphicalRootEditPart.getLayer((Object)"Handle Layer");
        figure.setLayoutManager((LayoutManager)new StackLayout());
        this.connectionRenderingFigure = new ConnectionRenderingFigure(graphicalRootEditPart.getLayer((Object)"Primary Layer"));
        figure.add((IFigure)this.connectionRenderingFigure);
        figure.validate();
    }

    public XSDConcreteComponent getInput() {
        return this.input;
    }

    protected EditPart getEditPart(EditPart parent, Object object) {
        EditPart editPart;
        EditPart result = null;
        Iterator i = parent.getChildren().iterator();
        while (i.hasNext()) {
            editPart = (EditPart)i.next();
            if (editPart.getModel() != object) continue;
            result = editPart;
            break;
        }
        if (result == null) {
            i = parent.getChildren().iterator();
            while (i.hasNext()) {
                editPart = this.getEditPart((EditPart)i.next(), object);
                if (editPart == null) continue;
                result = editPart;
                break;
            }
        }
        return result;
    }

    public abstract void setInput(XSDConcreteComponent var1);

    public abstract void setSelection(XSDConcreteComponent var1);
}

