/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editparts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDComponentSelectionDialog;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDComponentSelectionProvider;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDSetTypeHelper;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.SpacingFigure;
import org.eclipse.wst.xsd.ui.internal.graph.XSDChildUtility;
import org.eclipse.wst.xsd.ui.internal.graph.XSDGraphUtil;
import org.eclipse.wst.xsd.ui.internal.graph.XSDSubstitutionGroupChildUtility;
import org.eclipse.wst.xsd.ui.internal.graph.XSDSubstitutionGroupsViewer;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ExpandableGraphNodeEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.SimpleTypeDefinitionEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.ComboBoxCellEditorManager;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.ComponentNameDirectEditManager;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.SimpleDirectEditPolicy;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ContainerFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ExpandableGraphNodeFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.FillLayout;
import org.eclipse.wst.xsd.ui.internal.graph.figures.GraphNodeFigure;
import org.eclipse.wst.xsd.ui.internal.graph.model.XSDModelAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;

public class ElementDeclarationEditPart
extends ExpandableGraphNodeEditPart {
    public Label label;
    protected Label contentIconLabel;
    protected Label typeValueLabel;
    protected SimpleDirectEditPolicy simpleDirectEditPolicy = new SimpleDirectEditPolicy();
    protected boolean isContentIconLabelSelected = false;
    protected static final String ELEMENT_TYPE_PLACE_HOLDER = "ELEMENT_TYPE_PLACE_HOLDER";

    public XSDParticle getXSDParticle() {
        XSDConcreteComponent o = this.getXSDElementDeclaration().getContainer();
        return o instanceof XSDParticle ? (XSDParticle)o : null;
    }

    public XSDElementDeclaration getXSDElementDeclaration() {
        return (XSDElementDeclaration)this.getModel();
    }

    protected boolean isDefaultExpanded() {
        int depth = 0;
        ElementDeclarationEditPart part = this;
        while (part != null) {
            ++depth;
            part = part.getParent();
        }
        return depth <= 3;
    }

    protected GraphNodeFigure createGraphNodeFigure() {
        ExpandableGraphNodeFigure figure = new ExpandableGraphNodeFigure();
        figure.getOutlinedArea().setFill(true);
        figure.getOutlinedArea().setLayoutManager((LayoutManager)new FillLayout());
        this.label = new Label();
        figure.getIconArea().add((IFigure)this.label);
        this.label.setFont(mediumBoldFont);
        SpacingFigure spacingFigure = new SpacingFigure();
        figure.getIconArea().add((IFigure)spacingFigure);
        this.contentIconLabel = new Label();
        figure.getIconArea().add((IFigure)this.contentIconLabel);
        if (this.getParent() != null && this.getRoot() != null && this.getViewer() instanceof XSDSubstitutionGroupsViewer) {
            figure.getOuterContentArea().getContainerLayout().setSpacing(5);
        } else {
            RectangleFigure line = new RectangleFigure();
            line.setPreferredSize(20, 1);
            figure.getOutlinedArea().add((IFigure)line, 1);
            figure.getInnerContentArea().setLayoutManager((LayoutManager)new FillLayout(2));
            figure.getInnerContentArea().setBorder((Border)new MarginBorder(2, 2, 2, 1));
            ContainerFigure labelGroup = new ContainerFigure();
            Label typeLabel = new Label("type");
            labelGroup.add((IFigure)typeLabel);
            labelGroup.setBorder((Border)new MarginBorder(0, 4, 0, 4));
            Label equalsLabel = new Label(" = ");
            labelGroup.add((IFigure)equalsLabel);
            this.typeValueLabel = new Label();
            labelGroup.add((IFigure)this.typeValueLabel);
            figure.getOutlinedArea().add((IFigure)labelGroup, 2);
        }
        return figure;
    }

    protected ExpandableGraphNodeFigure getExpandableGraphNodeFigure() {
        return (ExpandableGraphNodeFigure)this.graphNodeFigure;
    }

    protected List getModelChildren() {
        XSDTypeDefinition typeDef = this.getXSDElementDeclaration().getTypeDefinition();
        ArrayList<XSDSimpleTypeDefinition> list = new ArrayList<XSDSimpleTypeDefinition>();
        if (typeDef instanceof XSDSimpleTypeDefinition) {
            list.add((XSDSimpleTypeDefinition)typeDef);
            if (this.getExpandableGraphNodeFigure().isExpanded()) {
                list.addAll(this.getModelChildrenHelper());
            }
            return list;
        }
        return this.getExpandableGraphNodeFigure().isExpanded() ? this.getModelChildrenHelper() : Collections.EMPTY_LIST;
    }

    protected List getModelChildrenHelper() {
        if (this.getViewer() instanceof XSDSubstitutionGroupsViewer) {
            return XSDSubstitutionGroupChildUtility.getModelChildren(this.getXSDElementDeclaration().getResolvedElementDeclaration());
        }
        return XSDChildUtility.getModelChildren(this.getXSDElementDeclaration().getResolvedElementDeclaration());
    }

    protected void refreshContentIcon() {
        XSDComplexTypeDefinition complexTypeDefinition;
        String iconName = null;
        XSDTypeDefinition td = this.getXSDElementDeclaration().getResolvedElementDeclaration().getTypeDefinition();
        if (td instanceof XSDComplexTypeDefinition && (complexTypeDefinition = (XSDComplexTypeDefinition)td).getAttributeUses().size() > 0) {
            iconName = "icons/XSDAttribute.gif";
        }
        Image image = iconName != null ? XSDEditorPlugin.getXSDImage(iconName) : null;
        this.contentIconLabel.setIcon(image);
    }

    protected void refreshVisuals() {
        XSDElementDeclaration ed;
        String text = this.getXSDElementDeclaration().isElementDeclarationReference() ? this.getXSDElementDeclaration().getResolvedElementDeclaration().getQName((XSDConcreteComponent)this.getXSDElementDeclaration().getSchema()) : this.getXSDElementDeclaration().getName();
        this.label.setText(text);
        ContainerFigure rectangle = this.graphNodeFigure.getOutlinedArea();
        if (XSDGraphUtil.isEditable(this.getXSDElementDeclaration())) {
            rectangle.setBorder((Border)new LineBorder(this.isSelected ? ColorConstants.black : elementBorderColor, 2));
            rectangle.setBackgroundColor(elementBackgroundColor);
            rectangle.setForegroundColor(elementBorderColor);
            this.graphNodeFigure.getInnerContentArea().setForegroundColor(ColorConstants.black);
            if (XSDGraphUtil.isEditable(this.getXSDElementDeclaration().getResolvedElementDeclaration())) {
                this.graphNodeFigure.getInnerContentArea().setForegroundColor(elementLabelColor);
            } else {
                this.graphNodeFigure.getInnerContentArea().setForegroundColor(elementBorderColor);
            }
            this.label.setBackgroundColor(elementBackgroundColor);
            this.label.setForegroundColor(elementLabelColor);
        } else {
            rectangle.setBorder((Border)new LineBorder(this.isSelected ? ColorConstants.black : readOnlyBorderColor, 2));
            rectangle.setBackgroundColor(readOnlyBackgroundColor);
            rectangle.setForegroundColor(readOnlyBorderColor);
            this.graphNodeFigure.getInnerContentArea().setForegroundColor(readOnlyBorderColor);
            this.label.setBackgroundColor(readOnlyBackgroundColor);
        }
        if (this.getXSDElementDeclaration().isElementDeclarationReference()) {
            this.label.setIcon(XSDEditorPlugin.getXSDImage("icons/GraphViewElementRef.gif"));
            this.label.setBorder((Border)new MarginBorder(0, 0, 0, 4));
        } else {
            this.label.setIcon(null);
            this.label.setBorder((Border)new MarginBorder(0, 6, 0, 4));
        }
        if (this.getXSDParticle() != null) {
            this.refreshOccurenceLabel(this.getXSDParticle().getMinOccurs(), this.getXSDParticle().getMaxOccurs());
        }
        if (this.typeValueLabel != null && (ed = this.getXSDElementDeclaration()).getElement() != null) {
            String type = ed.getElement().getAttribute("type");
            if (type == null) {
                type = "";
            }
            if (!this.getXSDElementDeclaration().isElementDeclarationReference()) {
                this.typeValueLabel.setText(type.equals("") ? "<anonymous>" : type);
            } else {
                String resolvedType = "";
                if (ed.getResolvedElementDeclaration() != null && ed.getResolvedElementDeclaration().getTypeDefinition() != null && (resolvedType = ed.getResolvedElementDeclaration().getTypeDefinition().getQName((XSDConcreteComponent)ed.getSchema())) == null) {
                    resolvedType = "<anonymous>";
                }
                this.typeValueLabel.setText(resolvedType);
            }
        }
        this.refreshContentIcon();
    }

    public void performRequest(Request request) {
        if ((request.getType() == "direct edit" || request.getType() == "open") && XSDGraphUtil.isEditable(this.getXSDElementDeclaration()) && request instanceof LocationRequest) {
            LocationRequest locationRequest = (LocationRequest)request;
            Point p = locationRequest.getLocation();
            this.isContentIconLabelSelected = false;
            if (this.hitTest((IFigure)this.label, p)) {
                this.performDirectEditForLabel();
            } else if (this.hitTest((IFigure)this.typeValueLabel, p)) {
                this.performDirectEditForTypeValueLabel();
            }
        }
    }

    private void performDirectEditForTypeValueLabel() {
        if (!this.getXSDElementDeclaration().isElementDeclarationReference()) {
            Shell shell = Display.getCurrent().getActiveShell();
            IWorkbench workbench = XSDEditorPlugin.getPlugin().getWorkbench();
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            IEditorPart editorPart = workbenchWindow.getActivePage().getActiveEditor();
            IFile currentIFile = ((IFileEditorInput)editorPart.getEditorInput()).getFile();
            XSDSchema schema = this.getXSDElementDeclaration().getSchema();
            XSDComponentSelectionProvider provider = new XSDComponentSelectionProvider(currentIFile, schema);
            XSDComponentSelectionDialog dialog = new XSDComponentSelectionDialog(shell, XSDEditorPlugin.getXSDString("_UI_LABEL_SET_TYPE"), provider);
            provider.setDialog(dialog);
            dialog.setBlockOnOpen(true);
            dialog.create();
            if (dialog.open() == 0) {
                Element element = this.getXSDElementDeclaration().getElement();
                XSDSetTypeHelper helper = new XSDSetTypeHelper(currentIFile, schema);
                helper.setType(element, "type", dialog.getSelection());
            }
        }
    }

    private void performDirectEditForLabel() {
        if (this.getXSDElementDeclaration().isElementDeclarationReference()) {
            ComboBoxCellEditorManager manager = new ComboBoxCellEditorManager((GraphicalEditPart)this, this.label){

                protected List computeComboContent() {
                    XSDSchema schema = ElementDeclarationEditPart.this.getXSDElementDeclaration().getSchema();
                    List globalElementNameList = new ArrayList();
                    if (schema != null) {
                        TypesHelper typesHelper = new TypesHelper(schema);
                        globalElementNameList = typesHelper.getGlobalElements();
                    }
                    return globalElementNameList;
                }

                public void performModify(String value) {
                    ElementDeclarationEditPart.this.getXSDElementDeclaration().getElement().setAttribute("ref", value);
                }
            };
            this.simpleDirectEditPolicy.setDelegate(manager);
            manager.show();
        } else {
            ComponentNameDirectEditManager manager = new ComponentNameDirectEditManager((GraphicalEditPart)this, this.label, (XSDNamedComponent)this.getXSDElementDeclaration());
            this.simpleDirectEditPolicy.setDelegate(manager);
            manager.show();
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.simpleDirectEditPolicy);
    }

    public void activate() {
        super.activate();
        if (this.getXSDParticle() != null) {
            XSDModelAdapterFactory.addModelAdapterListener(this.getXSDParticle(), this);
        }
    }

    public void deactivate() {
        if (this.getXSDParticle() != null) {
            XSDModelAdapterFactory.removeModelAdapterListener(this.getXSDParticle(), this);
        }
        super.deactivate();
    }

    public boolean isContentIconLabelSelected() {
        return this.isContentIconLabelSelected;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof SimpleTypeDefinitionEditPart) {
            this.graphNodeFigure.getIconArea().add(child, index + 1);
            SpacingFigure spacingFigure = new SpacingFigure();
            this.graphNodeFigure.getIconArea().add((IFigure)spacingFigure, index + 1);
        } else {
            this.getContentPane().add(child, index);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof SimpleTypeDefinitionEditPart) {
            this.graphNodeFigure.getIconArea().remove(child);
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    public void doEditName() {
        ComponentNameDirectEditManager manager = new ComponentNameDirectEditManager((GraphicalEditPart)this, this.label, (XSDNamedComponent)this.getXSDElementDeclaration());
        this.simpleDirectEditPolicy.setDelegate(manager);
        manager.show();
    }
}

