/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ContainerFigure;

public class GraphNodeFigure
extends ContainerFigure {
    protected ContainerFigure verticalGroup;
    protected ContainerFigure outlinedArea;
    protected ContainerFigure iconArea;
    protected ContainerFigure innerContentArea;
    protected boolean isConnected;
    protected boolean isIsolated = false;
    protected List childGraphNodeFigures = new ArrayList();
    protected GraphNodeFigure parentGraphNodeFigure;

    public GraphNodeFigure() {
        this.createFigure();
    }

    public boolean isExpanded() {
        return true;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    public void setIsIsolated(boolean isIsolated) {
        this.isIsolated = isIsolated;
    }

    public boolean getIsIsolated() {
        return this.isIsolated;
    }

    protected void createFigure() {
        this.createVerticalGroup((IFigure)this);
        this.createOutlinedArea((IFigure)this.verticalGroup);
    }

    protected void createVerticalGroup(IFigure parent) {
        this.verticalGroup = new ContainerFigure();
        this.verticalGroup.getContainerLayout().setHorizontal(false);
        parent.add((IFigure)this.verticalGroup);
    }

    protected void createOutlinedArea(IFigure parent) {
        this.outlinedArea = new ContainerFigure();
        this.outlinedArea.getContainerLayout().setHorizontal(false);
        parent.add((IFigure)this.outlinedArea);
        this.iconArea = new ContainerFigure();
        this.outlinedArea.add((IFigure)this.iconArea);
        this.innerContentArea = new ContainerFigure();
        this.innerContentArea.getContainerLayout().setHorizontal(false);
        this.outlinedArea.add((IFigure)this.innerContentArea);
    }

    public ContainerFigure getIconArea() {
        return this.iconArea;
    }

    public ContainerFigure getOutlinedArea() {
        return this.outlinedArea;
    }

    public ContainerFigure getInnerContentArea() {
        return this.innerContentArea;
    }

    public IFigure getConnectionFigure() {
        return this.outlinedArea;
    }

    public Rectangle getConnectionRectangle() {
        return this.outlinedArea.getBounds();
    }

    public List getChildGraphNodeFigures() {
        return this.childGraphNodeFigures;
    }

    public void addNotify() {
        super.addNotify();
        if (this.isConnected()) {
            this.parentGraphNodeFigure = this.computeParentGraphNodeFigure((IFigure)this);
            if (this.parentGraphNodeFigure != null) {
                this.parentGraphNodeFigure.getChildGraphNodeFigures().add(this);
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.parentGraphNodeFigure != null) {
            this.parentGraphNodeFigure.getChildGraphNodeFigures().remove((Object)this);
        }
    }

    public GraphNodeFigure getParentGraphNodeFigure() {
        return this.parentGraphNodeFigure;
    }

    public GraphNodeFigure computeParentGraphNodeFigure(IFigure figure) {
        GraphNodeFigure result = null;
        IFigure parent = figure != null ? figure.getParent() : null;
        while (parent != null) {
            GraphNodeFigure parentGraphNodeFigure;
            if (parent instanceof GraphNodeFigure && (parentGraphNodeFigure = (GraphNodeFigure)parent).isConnected()) {
                result = (GraphNodeFigure)parent;
                break;
            }
            parent = parent.getParent();
        }
        return result;
    }
}

